const system = require("../../../system");
const ServiceBase = require("../../sve.base");
class ProductpriceService extends ServiceBase {
  constructor() {
    super("product", ServiceBase.getDaoName(ProductpriceService));
  }
  async findCostBySkuCode (skucode) {
    let productpricetmp = await this.dao.model.findOne({
      where: { skucode: skucode, isEnabled: true },
      include: [
        { model: this.db.models.productcost, where: { expensetype: 'service' }, as: "costs", attributes: ['id', 'expensetype', 'costamount'] }
      ],
      raw: true,
    }
    )
    let costAmount = 0
    //获取服务费成本
    if (productpricetmp && productpricetmp['costs.costamount']) {
      costAmount = Number(productpricetmp['costs.costamount'])
    } else {
      console.log("skucode not find product:", skucode)
    }
    return costAmount
  }
  /**
   * @param {*} pname 产品名称
   * @param {*} spname 服务商名称
   */
  async findRegionsByProductName (productname, spname) {
    let ps = await this.dao.model.findAll({
      where: {
        sptags: { [this.db.Op.like]: "%" + spname + "%" },
        pname: { [this.db.Op.like]: "%" + productname + "%" },
        isEnabled: true
      }, attributes: ['pname', 'strategyitems'], raw: true
    })
    //查询出地区
    let rs = await this.db.models.region.findAll({ attributes: ['code', 'name'], raw: true })
    //获取地区JSON 对象
    let psrtn = []
    let cacheregions = {}
    ps.forEach(r => {
      let rpathstr = r.pname.split("~")[1]
      let rpatharray = rpathstr.split("/")
      let lstindex = rpatharray.length - 1
      let regionName = rpatharray[lstindex]
      let regioninfo = {}
      regioninfo["label"] = regionName
      let exAttrTmp = r.strategyitems
      //按照名字去取地区编码
      let areainfos = rs.filter(f => {
        if (f.name.indexOf(regionName) >= 0) {
          return true
        } else {
          return false
        }
      })
      let codeval = String(areainfos[0].code).padEnd(6, '0')
      if ((productname.indexOf("icp") < 0 && productname.indexOf("edi") < 0) && (areainfos[0].name.indexOf("天津") >= 0 || areainfos[0].name.indexOf("北京") >= 0 || areainfos[0].name.indexOf("上海") >= 0 || areainfos[0].name.indexOf("重庆") >= 0)) {
        codeval = String(areainfos[0].code + "01").padEnd(6, '0')
      }
      if (!cacheregions[codeval]) {
        cacheregions[codeval] = regioninfo
        regioninfo["code"] = codeval
        regioninfo["exAttr"] = [exAttrTmp]
        psrtn.push(regioninfo)
      } else {
        let cacheObj = cacheregions[codeval]
        cacheObj["exAttr"].push(exAttrTmp)
      }
    })
    return psrtn
  }
  async updownProduct (uid) {
    let p = await this.dao.findById(uid)
    p.isEnabled = !p.isEnabled
    await p.save()
    return {}
  }
}
module.exports = ProductpriceService;

// let p=new ProductpriceService()
// p.findRegionsByProductName("个体户注册","gao").then((res)=>{
//   console.log(res)
// })