const system = require("../../../system");
const ServiceBase = require("../../sve.base");
const fs=require("fs")
class XProductService extends ServiceBase {
  constructor() {
    super("xproduct", ServiceBase.getDaoName(XProductService));
  }
  async buildProductCat() {
    let ps = await this.dao.model.findAll({ raw: true })
    return ps
  }
}
module.exports = XProductService;

function findTitlePath(items, findstr, results) {
  items.forEach(item => {
    if (item.title.indexOf(findstr) < 0) {
      if (item.children && item.children.length > 0) {
        return findTitlePath(item.children, findstr, results)
      }
    } else {
      results.push(item.titlepath)
      return
    }
  })
}
(async () => {
  let ps = new XProductService()
  let ts = system.getObject("service.common.treearchSve")
  let products = []
  let res = await ps.buildProductCat();
  let rs = await ts.getRegions()
  let tags=[]
  for(let xp of res){
    let product = {}
    product.code = xp.path_code + xp.id
    results = []
    //findTitlePath(rs, xp.region_name, results)
    if(results.length==0 ||  !results[0]){
      fs.writeFileSync("./a.txt",xp.region_name)
    }
    //product.regionpath = results[0]//反查国家标准地区名称
    product.regionpath=xp.region_name
    product.productcatpath = "产品分类" + xp.path_name
    product.name = product.productcatpath + "~" + product.regionpath
    product.sptags = xp.servicer_name
    product.channeltags="腾讯"
    product.desc=product.name
    product.company_id=1
    //构造策略ids
    let stsinfos = await ps.db.models.xproductprice.findAll({ where:{product_name:xp.path_code},raw: true })
    if(xp.region_name=="重庆" && xp.path_code=="/ic/cpreg/"){
       fs.writeFileSync("./b.txt",JSON.stringify(stsinfos))
    }
    let straid=[]
    let skucodemap={}
    for(let stinfo of stsinfos){
       let tg=stinfo.price_name.replace("EDI","").replace("ICP","").replace("（",",").replace("）","").replace("章","").replace("完成","").replace("\t\r\n","").replace("天","工作日")
       //按照price_name去策略表中查询策略id
       let strategy=await ps.db.models.pricestrategy.findOne({where:{optionunion:tg}})
       if(!strategy){
        tags.push(tg)
        strategy=await ps.db.models.pricestrategy.findOne({where:{optionunion:"通用"}})
       }
       straid.push(strategy.id)
       skucodemap[strategy.id]=stinfo.price_code
    }
    //
    // console.log(stsinfos.length,"..................")
    product.sts=straid
    product.skucodemap=skucodemap
    products.push(product)
  }
  let productS=system.getObject("service.product.productSve")
  for(let p of products){
    await productS.create(p)
  }
  console.log(JSON.stringify(tags))
  // { id: 128,
  //   path_code: '/ic/gsreg/'+id,----->code
  //   path_name: '/工商服务/公司注册/',+产品分类---->productcatpath
  //   region_id: '320400',
  //   region_name: '常州'}--->regionpath

  //通过region_name--解析出regionpath
  //path_name--添加“产品分类”
  //code,regionpath,productcatpath,name






  // let treedata={}
  // res.forEach(item=>{
  //   let pathcodes=item.path_code.split("/")
  //   let pathnames=item.path_name.split("/")
  //   let pathcoderesults=pathcodes.slice(1,3)
  //   let pathnameresults=pathnames.slice(1,3)
  //   let codekey=pathcoderesults[0]
  //   if(!treedata[codekey]){
  //     let tmp={}
  //     tmp["code"]=pathcoderesults[0]
  //     tmp["title"]=pathnameresults[0]
  //     tmp["orgpath"]="/"+pathcoderesults[0]
  //     tmp["titlepath"]="/"+pathnameresults[0]
  //     tmp.children=[
  //       {
  //         code:pathcoderesults[1],
  //         title:pathnameresults[1],
  //         orgpath:item.path_code,
  //         titlepath:item.path_name
  //       }
  //     ]
  //   treedata[codekey]= tmp
  //   }else{
  //     let f=treedata[codekey].children.filter(it=>{
  //       if(it.code==pathcoderesults[1]){
  //         return true
  //       }else{
  //         return false
  //       }
  //     })
  //     if(f.length==0){
  //       let n={
  //         code:pathcoderesults[1],
  //         title:pathnameresults[1],
  //         orgpath:item.path_code,
  //         titlepath:item.path_name
  //       }
  //       treedata[codekey].children.push(n)
  //     }
  //   }
  // })
  // let root = {
  //   title: "产品分类",
  //   code: "root",
  //   orgpath: "root",
  //   children: [
  //   ]
  // }
  // Object.keys(treedata).forEach(k=>{
  //   root.children.push(treedata[k])
  // })
  // console.log(JSON.stringify(root))
}) ()
