var express = require('express');
var path = require('path');
var favicon = require('serve-favicon');
var methodOverride = require('method-override');
var cookierParser = require('cookie-parser');
var bodyParser = require('body-parser');
var multer = require('multer');
var errorHandler = require('errorhandler');
var settings = require('./settings');
var system = require('../base/system');
var routes = require('./routes');
var history = require('connect-history-api-fallback');
module.exports = function (app) {
  app.set('port', settings.port);
  app.set('views', settings.basepath + '/app/front/entry');
  app.set('view engine', 'ejs');
  app.use(methodOverride());
  app.use(cookierParser());
  app.use(bodyParser.json({ limit: '50mb' }));
  app.use(bodyParser.urlencoded({ limit: '50mb', extended: true }));
  routes(app);//初始化路由

  

  app.use(history());
  app.use(express.static(path.join(settings.basepath, '/app/front/entry/public')));
  app.all('*',function (req, res, next) {
    // res.header('Access-Control-Allow-Origin', '*');
    // res.header('Access-Control-Allow-Methods', 'PUT, POST, GET, DELETE, OPTIONS');
    // res.header("P3P","CP=CAO PSA OUR");
    // res.header('Access-Control-Allow-Credentials', 'true');
    if (req.method == 'OPTIONS') {
      res.send(200); 
    }
    else {
      next();
    }
  });


  // development only
  if ('development' == app.get('env')) {
    app.use(errorHandler());
  } else {
    app.use(function (err, req, res) {
      console.log("prod error handler................................>>>>>>>>>>>>>>>>>");
      console.log(err);
      //logerApp.error("prod error handler",err);
      res.send("link admin");
    });
  }

};
