var path = require('path');
var ENVINPUT = {
  KONG_ADMIAN: process.env.KONG_ADMIAN,
  DB_HOST: process.env.DB_HOST,
  DB_PORT: process.env.DB_PORT,
  DB_USER: process.env.DB_USER,
  DB_PWD: process.env.DB_PWD,
  DB_NAME: process.env.PAAS_DB_NAME,
  REDIS_HOST: process.env.REDIS_HOST,
  REDIS_PORT: process.env.REDIS_PORT,
  REDIS_PWD: process.env.REDIS_PWD,
  REDIS_DB: process.env.PAAS_REDIS_DB,
  APP_ENV: process.env.APP_ENV ? process.env.APP_ENV : "dev"
};
var settings = {
  env: ENVINPUT.APP_ENV,
  salt: "%iatpD1gcxz7iF#B",
  defaultpwd: "gsb2020",
  basepath: path.normalize(path.join(__dirname, '../..')),
  port: process.env.NODE_PORT || 80,
  logindex: "center_manage",
  appname: "center_manage",
  publickey: function () {
    if (this.env == "dev") {
      return {
        "kty": "RSA",
        "n": "qrie8Rrptw5hGJ9fdI8f6QJuLLbTulWkSmFYDQDPu2aXP65wbRhtPMxn6DA9Qh_o29LqtlNd1L5dhY5ma_hXSwNv-FfiQoUkkdFFZ2H_mODnKaLtV5evho9r3_wGa92dxV_UZQVUurhZ7V6gQk0BzrpUuMqZ1JDOcD4iG_bEEZjuRXWpXtKKj7MoXJyTUrOlCyN1yFo7gxM3ee6rImxfDP4nEhKPnL7HqwTcXCQApLJORRluoThEciVXRs8SYk08MtemZUhCq8QjXTvS52S5u5o_osFqs1DnPYHpiAfydOfEweFCgomt7imD5vIjOlUDEBSGE0mRUFCBnM3Qg_idZQ",
        "e": "AQAB",
        "kid": "dc2c533023a111e9a95769b80b428cd1",
        "alg": "ES256"
      }
    } else {
      return {
        "kty": "RSA",
        "n": "vkjTlSBYiknVYOJZXAGOyckL3aIdxxcR7iBtGtScfmB5xPop3-ZyYIuBnvCDlqx4r33Hut0bBnEbyOCOWPjsL0szsNZO4Ojbzju3INhiXxqJUPsfuPs82zDEuq-MOF2FnxeGeihPY8Va_YPSjZj9ZeN7eUtRP-nct2N4XftOxQrUPwbMAWnfZskMrjiYD-NRsIcwYaKvkvO9sfjzD9Hkp3OVTnz-doVN7FqWTLGAX8veN2bTWOD5vTqfHwhgxFR0jgZgDHMD262zFBj4ULlLlGr2J9zhWPxEOvod58ll_tHA4Q9HLzmol3u8yGuD7heyRmqnF74qEbbal-Xk67uAyw",
        "e": "AQAB",
        "kid": "e1703c2001dd11e9b50fd525bc2a7e1d",
        "alg": "ES256"
      };
    }
  },
  kongurl: function () {
    if (this.env == "dev") {
      var localsettings = require("./localsettings");
      return localsettings.kongurl;
    } else {
      return "http://kong-dbproxy.kong:8001/";
    }
  },
  icUrl: function () {
    if (this.env == "dev") {
      return "http://ic.com:8000";
    } else {
      return "http://icdeliver-service";
    }
  },
  icpUrl: function () {
    if (this.env == "dev") {
      return "http://127.0.0.1:8002" || "http://icp.com:8000";
    } else {
      return "http://icpdeliver-service";
    }
  },
  logUrl: function () {
    if (this.env == "dev") {
      return "http://192.168.18.101:4019/api/queueAction/producer/springBoard";
    } else {
      return "http://logs-sytxpublic-msgq-service.chaolai/api/queueAction/producer/springBoard";
    }
  },
  pushUrl: function () {
    if (this.env == "dev") {
      return "http://192.168.18.101:4018/api/queueAction/producer/springBoard";
    } else {
      return "http://logs-sytxpublic-msgq-service/api/queueAction/producer/springBoard";
    }
  },
  QIFUTONG: {
    appKey: "202003231118",
    secret: "7cbb846246874167b5c7e01cd0016c99",
    centerChannelUrl: () => { //---------center-channel
      if (ENVINPUT.APP_ENV == "dev") {
        return "http://alitm.qifu-dev.gongsibao.com";
      } else {
        return "http://center-channel-service.chaolai";
      }
    },
    qifutongUrl: () => { //---------center-channel
      if (ENVINPUT.APP_ENV == "dev") {
        return "http://gsbweb.qifu-dev.gongsibao.com";
      } else {
        return "https://fqgsbweb.gongsibao.com";
      }
    },
  },
  pmappname: "center-app",
  pmappid: 1,
  pmcompanyid: 1,
  pmroleid: { "ta": 1, "pr": 2 },
  redis: function () {
    if (this.env == "dev") {
      var localsettings = require("./localsettings");
      return localsettings.redis;
    } else {
      return {
        host: ENVINPUT.REDIS_HOST,
        port: ENVINPUT.REDIS_PORT,
        password: ENVINPUT.REDIS_PWD,
        db: ENVINPUT.REDIS_DB,
      };
    }
  },
  database: function () {
    if (this.env == "dev") {
      var localsettings = require("./localsettings");
      console.log(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>....")
      return localsettings.database;
    } else {
      return {
        dbname: ENVINPUT.DB_NAME,
        user: ENVINPUT.DB_USER,
        password: ENVINPUT.DB_PWD,
        config: {
          host: ENVINPUT.DB_HOST,
          port: ENVINPUT.DB_PORT,
          dialect: 'mysql',
          operatorsAliases: false,
          pool: {
            max: 5,
            min: 0,
            acquire: 90000000,
            idle: 1000000
          },
          debug: false,
          logging: false,
          timezone: '+08:00',
          dialectOptions: {
            requestTimeout: 999999,
            // instanceName:'DEV'
          }  //设置MSSQL超时时间
        },
      };
    }
  }
};
settings.ENVINPUT = ENVINPUT;
module.exports = settings;
