//百度工商注册
var APIBase = require("../../api.base");
var system = require("../../../system");
const regCfg = require("./regCfg");

class Order extends APIBase {
    constructor() {
        super();
        this.gatewaypushlogSve = system.getObject("service.common.gatewaypushlogSve");
        this.utilsPushSve = system.getObject("service.utilsSve.utilsPushSve");
    }

    // 20220423 baidu 工商注册新流程 提交公司注册申请材料 baidu->公司宝
    async submitMaterial(pobj,req){
        const params = JSON.stringify(pobj)
        console.log(">>> 提交工商注册申请材料 start...",params)
        this.execClientNew.execLogs(`>>> 提交工商注册申请材料 start...`, params, "center-channel-order-submitMaterial", null, null);
        if(!pobj){
            return regCfg.getResultFail("orderNo不能为空");
        }
        // 将数据推送到资质宝
        var deliveryObj = {
            actionBody: {
                ...pobj,
                servicer: {
                    code: 'gsb',
                    name: '公司宝'
                }
            },
            appInfo: pobj.appInfo
        };
        console.log(`>>> 提交工商注册申请材料 参数...${JSON.stringify(deliveryObj)}`);
        await this.utilsPushSve.business2Channel(deliveryObj, "pushOrderDeliveryMaterial");
        return regCfg.getResultSuccess(pobj.requestId);
    }

    //状态变更
    async notify(pobj, req) {
        if (!pobj.appInfo || !pobj.appInfo.uapp_key || !pobj.appInfo.uapp_secret) {
            return regCfg.getResultFail("未知应用或应用未启用");
        }
        if (!pobj.isDirectBuy || pobj.isDirectBuy == 0) {
            pobj.isDirectBuy = 0;
        }
        if (!pobj.orderNo) {
            return regCfg.getResultFail("orderNo不能为空");
        }
        if (!pobj.orderNo) {
            return regCfg.getResultFail("orderNo不能为空");
        }
        if (pobj.isDirectBuy == 0 && !pobj.bizId) {
            return regCfg.getResultFail("非直接下单bizId不能为空");
        }
        if (pobj.isDirectBuy == 1 && !pobj.phone) {
            return regCfg.getResultFail("直接下单phone不能为空");
        }
        if (pobj.isDirectBuy == 1 && !pobj.consultType) {
            return regCfg.getResultFail("直接下单consultType不能为空");
        }
        if (pobj.area) {
            pobj.area = regCfg.baiduArea[pobj.area]
        }
        pobj.status = 1;
        pobj.action_type = "regOrderStatus";

        var param = {
            requestId: req.requestId || regCfg.getUUID(),
            requestUrl: "/ic/order/notify",
            requestjson: JSON.stringify(pobj),//请求地址
            pushUrl: "/action/intentionapi/springBoard",//调用地址
            pushActionType: "regOrderStatus",//调用参数
            pushtimes: 0,//推送次数
            pushStatus: "wts",//推送状态
        }
        await this.gatewaypushlogSve.create(param);
        return regCfg.getResultSuccess(param.requestId);
    }

    async close(pobj, req) {
        if (!pobj.appInfo || !pobj.appInfo.uapp_key || !pobj.appInfo.uapp_secret) {
            return regCfg.getResultFail("未知应用或应用未启用");
        }
        if (!pobj.orderNo) {
            return regCfg.getResultFail("orderNo不能为空");
        }
        pobj.channelOrderNo = pobj.orderNo;
        pobj.action_type = "regOrderClose";
        var param = {
            requestId: req.requestId || regCfg.getUUID(),
            requestUrl: "/ic/order/close",
            requestjson: JSON.stringify(pobj),//请求地址
            pushUrl: "/action/intentionapi/springBoard",//调用地址
            pushActionType: "regOrderClose",//调用参数
            pushtimes: 0,//推送次数
            pushStatus: "wts",//推送状态
        }
        await this.gatewaypushlogSve.create(param);
        return regCfg.getResultSuccess(param.requestId);
    }

}

module.exports = Order;