var APIBase = require("../../api.base");
var system = require("../../../system");
var settings = require("../../../../config/settings");
class edi extends APIBase {
  constructor() {
    super();
    this.centerorderSve = system.getObject("service.common.centerorderSve");
    this.utilsOrderSve = system.getObject("service.utilsSve.utilsOrderSve");
    this.utilsNeedSve = system.getObject("service.utilsSve.utilsNeedSve");
  }

  /**
    * 接口跳转-POST请求
    * action_process  执行的流程
    * action_type     执行的类型
    * action_body     执行的参数
    */
  async springBoard(pobj, qobj, req) {
    if (!pobj.actionType) {
      return system.getResult(null, "actionType参数不能为空");
    }
    var result = await this.opActionProcess(pobj, pobj.actionType, pobj.actionBody, req);
    return result;
  }
  async opActionProcess(pobj, action_type, action_body, req) {
    var opResult = null;
    switch (action_type) {
      case "submitNeedAliEsp":
        opResult = await this.utilsNeedSve.submitNeedAliEsp(pobj, pobj.actionBody);
        break;
      case "needCloseAliEsp":
        opResult = await this.utilsNeedSve.needCloseAliEsp(pobj, pobj.actionBody);
        break;
      case "produceNoticeAliEsp":
        opResult = await this.utilsNeedSve.ediNotify(pobj, pobj.actionBody);
        if (opResult.status == 0) {
          opResult = await this.utilsNeedSve.produceNoticeAliEsp(req, pobj, pobj.actionBody);
        }
        break;
      case "soulutionFeebackAliEsp":
        // opResult = await this.utilsNeedSve.ediNotify(pobj, pobj.actionBody);
        // opResult = await this.utilsNeedSve.soulutionFeebackAliEsp(pobj,pobj.actionBody);
        pobj.actionType = "receiveFeedback"
        opResult = await this.centerorderSve.reqCenterOrderApi(pobj);
        break;
      default:
        opResult = system.getResult(null, "action_type参数错误");
        break;
    }
    return opResult;
  }

}
module.exports = edi;