const system = require("../../../system");
const ServiceBase = require("../../sve.base");
var settings = require("../../../../config/settings");
const uuidv4 = require('uuid/v4');
const getRawBody = require('raw-body');

class GatewaypushlogService extends ServiceBase {
    constructor() {
        super("common", ServiceBase.getDaoName(GatewaypushlogService));
        this.execClient = system.getObject("util.execClient");
        this.dingClient = system.getObject("util.dingClient");
    }

    async taskAliIcapi() {
        try {
            var sql = "select * from gateway_pushlog where pushStatus='wts' and pushtimes<4"
            var icloginfos = await this.customQuery(sql);
            if (icloginfos.length > 0) {
                var count = 100;
                if (icloginfos.length < count) {
                    count = icloginfos.length;
                }
                var self = this;
                for (var i = 0; i < count; i++) {
                    try {
                        var icloginfo = icloginfos[i];
                        var requestdata = null;
                        if (icloginfo && icloginfo.requestjson) {
                            requestdata = JSON.parse(icloginfo.requestjson);
                        }
                        var url = settings.gatewayUrl() + "action/intentionapi/springBoard";
                        var rtn = await self.execClient.execPost(requestdata, url);
                        var data = rtn
                        data = JSON.parse(rtn.stdout);
                        if (data.success) {
                            icloginfo.pushStatus = "yts";
                        } else {
                            if (data.errorMsg != "状态错误") {//除1 2 4 11其它状态没处理、返回的状态错误
                                data.push_url = url;
                                data.api = "center-channel/taskAliIcapi-for";
                                data.requestdata = requestdata;
                                data.message = "error info";
                                this.dingClient.gatewayPushError(data);
                            }
                            icloginfo.error = JSON.stringify(data);
                            icloginfo.pushtimes += 1;
                        }
                        this.update(icloginfo);
                    } catch (e) {
                        const stackStr = e.stack ? e.stack : JSON.stringify(e);
                        icloginfo.error = stackStr;
                        this.update(icloginfo);
                        this.dingClient.gatewayPushError({
                            message: "Exception info",
                            api: "center-channel/taskAliIcapi-for",
                            e
                        })
                    }
                }
            }
            return system.getResultSuccess();

        } catch (error) {
            this.dingClient.gatewayPushError({message: "Exception", api: "center-channel/taskAliIcapi", error})
            return system.getResultFail(-1, error);
        }
    }


}

module.exports = GatewaypushlogService;
