<a name="menu" href="/doc">返回主目录</a>
1. [尼斯查询（一）](#getNcl)
1. [尼斯查询（二）](#getNclTwo)
1. [尼斯查询（模糊查询）](#getNclByLikeNameAndNcl)
1. [文字转图片](#word2pic)
1. [商标样式转换](#uploadStandardTm)
1. [图片转pdf](#pic2pdf)
1. [调整委托书](#adjustWTSSize)
1. [获取oss配置参数](#getOssConfig)
1. [获取商标订单交付信息](#getTmOrderDeliveryInfo)
1. [获取商标官文列表信息](#getTmOrderDeliveryFlowList)
1. [修改订单联系人](#updateContacts)
1. [商标订单修改-商标信息修改](#updateTmInfo)
1. [商标订单修改-商标尼斯信息修改](#updateNclInfo)
1. [商标订单修改-修改申请人信息](#updateCustomerInfo)
1. [商标订单修改-修改交官材料](#updateOfficial)
1. [商标方案确认](#tmConfirm)
1. [推送委托书模板邮件(阿里云)](#sendAliWtsEmail)
1. [商标智能推荐](#getNclByCode)
1. [全类保护](#getAllNcl)
1. [添加常用联系人、申请人](#addUsuallyContacts)
1. [删除常用联系人、申请人](#delUsuallyContacts)
1. [修改常用联系人、申请人](#updateUsuallyContacts)
1. [获取常用联系人、申请人](#getUsuallyContacts)



## **<a name="getNcl"> 尼斯查询（一）</a>**
[返回到目录](#menu)
##### URL
[/action/tmTools/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 渠道执行的类型 actionType：getNcl
``` javascript
    {
        "nclcode": "01"   //Y string 尼斯编号（尼斯大类类别获取群组类别）
    }
```

#### 返回结果
```javascript
    {
        "status": 0,//操作状态0:操作成功-1:操作失败
        "msg": "操作成功",//操作信息
        "data": {
            "count":16,
            "rows":[
               {
                   "code": "01",//尼斯大类编码
                   "name": "",//大类名称
                   "pcode": "",//父类编码 大类要为父类则为空
                   "type": 1,
                   "children": [//尼斯群组信息
                       {
                           "code": "0106",//群组编码
                           "name": "化学试剂",//群组名称
                           "pcode": "01",//群组父类编码 即其所属大类编码
                           "type": 1,
                           "children": [//尼斯小类
                               {
                                   "code": "010122",//小类编码
                                   "name": "生物化学催化剂",//小类名称
                                   "pcode": "0106"//小类父类编码 即其所属群组编码
                               }
                           ]
                       }
                   ]
               },
               {
                   "code": "42",
                   "name": "",
                   "pcode": "",
                   "type": 1,
                   "children": [
                       {
                           "code": "4211",
                           "name": "提供化学研究服务",
                           "pcode": "42",
                           "type": 1,
                           "children": [
                               {
                                   "code": "",
                                   "name": "生物化学研究和分析",
                                   "pcode": "4211"
                               }
                           ]
                       }
                   ]
               }
           ]    
        },
        "requestId": "8cd7e91ec607453c805da8302f3e068c"
    }
```

## **<a name="getNclTwo"> 尼斯查询（二）</a>**
[返回到目录](#menu)
##### URL
[/action/tmTools/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 渠道执行的类型 actionType：getNcl

``` javascript
    {
        "name": "生物化学",//Y strin 尼斯名称
        "ncls ": ["01"]//N List 尼斯大类编码列表
    }
```

#### 返回结果
```javascript
    {
        "status": 0,//操作状态0:操作成功-1:操作失败
        "msg": "操作成功",//操作信息
        "data": [
            {
                "code": "01",//尼斯大类编码
                "name": "",//大类名称
                "pcode": "",//父类编码 大类要为父类则为空
                "type": 1,
                "children": [//尼斯群组信息
                    {
                        "code": "0106",//群组编码
                        "name": "化学试剂",//群组名称
                        "pcode": "01",//群组父类编码 即其所属大类编码
                        "type": 1,
                        "children": [//尼斯小类
                            {
                                "code": "010122",//小类编码
                                "name": "生物化学催化剂",//小类名称
                                "pcode": "0106"//小类父类编码 即其所属群组编码
                            }
                        ]
                    }
                ]
            },
            {
                "code": "42",
                "name": "",
                "pcode": "",
                "type": 1,
                "children": [
                    {
                        "code": "4211",
                        "name": "提供化学研究服务",
                        "pcode": "42",
                        "type": 1,
                        "children": [
                            {
                                "code": "",
                                "name": "生物化学研究和分析",
                                "pcode": "4211"
                            }
                        ]
                    }
                ]
            }
        ],
        "requestId": "8cd7e91ec607453c805da8302f3e068c"
    }
```

## **<a name="getNclByLikeNameAndNcl"> 尼斯查询（模糊查询）</a>**
[返回到目录](#menu)
##### URL
[/action/tmTools/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 渠道执行的类型 actionType：getNclByLikeNameAndNcl
``` javascript
    {
        "name": "砷",
        "ncls": []
    }
```

#### 返回结果
``` javascript
    {
        "status": 0,
        "msg": "操作成功",
        "data": [
            {
                "code": "01",
                "name": "化学原料",
                "pcode": "",
                "type": 1,
                "children": [
                    {
                        "code": "0101",
                        "name": "工业气体，单质",
                        "pcode": "01",
                        "type": 1,
                        "children": [
                            {
                                "code": "010084",
                                "name": "砷",
                                "pcode": "0101"
                            }
                        ]
                    },
                    {
                        "code": "0102",
                        "name": "用于工业、科学、农业、园艺、林业的工业化工原料",
                        "pcode": "01",
                        "type": 1,
                        "children": [
                            {
                                "code": "010083",
                                "name": "砷酸铅",
                                "pcode": "0102"
                            },
                            {
                                "code": "010085",
                                "name": "亚砷酸",
                                "pcode": "0102"
                            },
                            {
                                "code": "",
                                "name": "有机砷化合物",
                                "pcode": "0102"
                            }
                        ]
                    }
                ]
            },
            {
                "code": "05",
                "name": "医药",
                "pcode": "",
                "type": 1,
                "children": [
                    {
                        "code": "0501",
                        "name": "药品，消毒剂，中药药材，药酒",
                        "pcode": "05",
                        "type": 1,
                        "children": [
                            {
                                "code": "",
                                "name": "医用砷解毒剂",
                                "pcode": "0501"
                            }
                        ]
                    }
                ]
            }
        ],
        "bizmsg": "empty",
        "requestId": "66d5695bccbd4a168e6e4823542b4a65"
    }
```


## **<a name="word2pic"> 文字转图片</a>**
[返回到目录](#menu)
##### URL
[/action/tmTools/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 渠道执行的类型 actionType：word2pic

``` javascript
    {
        "word": "235"
    }
```

#### 返回结果
```javascript
    {
        "status":0,
        "msg":"操作成功",
        "data":{
            "url":"https://gsb-zc.oss-cn-beijing.aliyuncs.com/zc_word2pic0310054131e546c68e572e72845e10ed.jpg"
        },
        "requestId":"289fc8efa0ca4db79affc34dc0b78b9e"
    }

```


## **<a name="uploadStandardTm"> 商标样式转换</a>**
[返回到目录](#menu)
##### URL
[/action/tmTools/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 渠道执行的类型 actionType：uploadStandardTm

``` javascript
    {
        "key": "https://gsb-zc.oss-cn-beijing.aliyuncs.com/zc_picUrl295615693112289552019824.jpg"
    }
```

#### 返回结果
```javascript
    {
        "status":0,
        "msg":"操作成功",
        "data":{
            "url":"https://gsb-zc.oss-cn-beijing.aliyuncs.com/zc_picUrl295652019824.jpg",
            "url2":"https://gsb-zc.oss-cn-beijing.aliyuncs.com/6tkoZLO7vLzvFpzP2sOo.jpg"
        },
        "requestId":"610fa9e864014d9b92bb63bb28eab6df"

    }

```

## **<a name="pic2pdf"> 图片转pdf</a>**
[返回到目录](#menu)
##### URL
[/action/tmTools/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 渠道执行的类型 actionType：pic2pdf

``` javascript
    {
        "key": "https://gsb-zc.oss-cn-beijing.aliyuncs.com/zc_picUrl295615693112289552019824.jpg"
    }
```

#### 返回结果
```javascript
    {
        "status":0,
        "msg":"操作成功",
        "data":{
            "url":"https://gsb-zc.oss-cn-beijing.aliyuncs.com/zc_yyzz23491569102019824.pdf"
        },
        "requestid":"0f6a38044034475eb47e80a78d3bdd6c"

    }

```

## **<a name="adjustWTSSize"> 调整委托书</a>**
[返回到目录](#menu)
##### URL
[/action/tmTools/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 渠道执行的类型 actionType：adjustWTSSize

``` javascript
    {
        "key":"https://gsb-zc.oss-cn-beijing.aliyuncs.com/zc_word2pic0310054131e546c68e572e72845e10ed.jpg"
    }
```

#### 返回结果
```javascript
    {
        "status":0,
        "msg":"操作成功",
        "data":{
            "url":"https://gsb-zc.oss-cn-beijing.aliyuncs.com/zc_wts745215693150065342019824.jpg"
        },
        "bizmsg":"empty",
        "requestid":"10fc80d7084549238ad59a1016a92c5f"
    }

```

## **<a name="getOssConfig"> 获取oss配置数据</a>**
[返回到目录](#menu)
##### URL
[/action/tmTools/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 渠道执行的类型 actionType：getOssConfig

``` javascript
{
    "bucket":"gsb-zc"// N 桶的名称
}

```

#### 返回结果
```javascript
{
    "status":0,
    "msg":"success",
    "data":{
        "OSSAccessKeyId":"LTAIyAUK8AD04P5S",
        "policy":"eyJleHBpcmF0aW9uIjoiMjExOS0xMi0zMVQxNjowMDowMC4wMDBaIiwiY29uZGl0aW9ucyI6W1siY29udGVudC1sZW5ndGgtcmFuZ2UiLDAsMTA0ODU3NjAwMF0sWyJzdGFydHMtd2l0aCIsIiRrZXkiLCJ6YyJdXX0=",
        "Signature":"PIEo2XGkySgyJIEcdEcM0G+0D04=",
        "Bucket":"gsb-zc",
        "success_action_status":201,
        "url":"https://gsb-zc.oss-cn-beijing.aliyuncs.com"
    },
    "requestId":"becb6b6bfa9449129c84d35b13b5e5e7"
}

```

## **<a name="getTmOrderDeliveryInfo"> 获取商标订单交付信息</a>**
[返回到目录](#menu)
##### URL
[/web/opaction/order/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 请求头中需要增加userpin（用户登录后的凭证）的值
#### 渠道执行的类型 actionType：getOrderDeliveryInfo

``` javascript
{
    "orderNo":"TM26202002271337mkgN"// Y 订单号
}

```

#### 返回结果
```javascript
{
    "status": 0,// 0为成功，否则失败
    "msg": "success",
    "data": {
        "deliveryUpdated":"2020-02-19T06:53:09.000Z",//流程状态创建时间
        "deliveryStatus": "dsh",//流程状态编码
        "deliveryStatusName": "待审核",//流程状态名称（dsccl: 待上传材料,dfwsfw: 待服务,dqrfa:待确认方案,fabtg:方案不通过, dsh: 待审核, ddj: 待递交, ydj: 已递交, ywc: 已完成）    
        "deliveryStatusList":[
            {
                "deliveryUpdated":"2020-02-18T06:53:09.000Z",//流程状态创建时间
                "deliveryStatus": "dsccl",//流程状态编码
                "deliveryStatusName": "待上传材料"//流程状态名称（dsccl: 待上传材料,dfwsfw: 待服务,dqrfa:待确认方案,fabtg:方案不通过, dsh: 待审核, ddj: 待递交, ydj: 已递交, ywc: 已完成）
            },
            {
                "deliveryUpdated":"2020-02-19T06:53:09.000Z",
                "deliveryStatus": "dsh",
                "deliveryStatusName": "待审核"
            }
        ],
        "notes":"", //  订单备注                                                                                       
        "opNotes":"", //操作备注  
        "orderContact": {
            "id": 448,
            "contactName": "宋毅",//联系人
            "mobile": "15010929368",//联系人手机号
            "tel": null,//联系人电话
            "email": "songyi@gongsibao.com",//联系人邮箱
            "fax": null//联系人传真
        },    
        "apply": {//申请信息
            "applyAddr": "上海市杨浦区国定路346号三楼0624室",//执照详细地址
            "applyArea": "",//申请区域--暂时没有用到
            "businessLicensePic": "https://gsb-zc.oss-cn-beijing.aliyuncs.com/zc_yyzz120315554031547442019316.jpg",//营业执照jpg地址
			"businessLicensePdf": "https://gsb-zc.oss-cn-beijing.aliyuncs.com/zc_yyzz120315554031547442019316.pdf",//营业执照pdf地址
            "code": "91310110398635929J",//统一社会信用代码
            "customerType": "ent",//申请人类型 person个人，ent企业           
            "identityCardNo": "",//申请人身份证号--（申请类型为个人有此值）
            "identityCardPic": "",//申请人身份证jpg地址--（申请类型为个人有此值）
			"identityCardPdf": "",   //申请人身份证pdf地址  --（申请类型为个人有此值）    
            "name": "上海辰者信息科技有限公司",  //申请人名称          
            "gzwtsUrl": "https://gsb-zc.oss-cn-beijing.aliyuncs.com/zc_wts863215710393842862019914.jpg",//盖章委托书url
            "smwjUrl":"",//说明文件url
            "zipCode": "100000"//邮政编码
        },
        "tm": {
            "colorizedPicUrl": "https://gsb-zc.oss-cn-beijing.aliyuncs.com/zc_word2picb2bc98b9fc564ef2a1f4b3cbe9352f39.jpg",//商标彩色图样
            "tmName": "testbiao",//商标名称
            "picUrl": "https://gsb-zc.oss-cn-beijing.aliyuncs.com/zc_word2picb2bc98b9fc564ef2a1f4b3cbe9352f39.jpg",//商标图样       
            "tmFormType": "3"//商标类型形式： 3: 字, 4: 图, 5: 字图
        },
        "nclones": [
            {
                "tbCode": "TB26202002271337v5y9",//提报号   
                "tmRegistNum": "",//商标申请号   
                "code": "02",//尼斯大类编码
                "name": "颜料油漆",//尼斯大类名称
                "submitTime": "",//提报时间                
                "tmStatus": "dsh",//商标状态编码
                "tmStatusName": "待审核",//商标状态编码名称
				"nclCount": 2,//尼斯小项数量
				"nclPublicExpense": 300,
                "nclThree": [
                    {
                        "code": "020008",//小项编码
                        "disabled": false,
                        "fullname": "020008 绘画用铝粉",//小项编码加名称
                        "name": "绘画用铝粉",//小项名称
                        "pcode": "0202"//小项所属群组编码
                    },
                    {
                        "code": "020005",
                        "name": "食品用着色剂",
                        "pcode": "0203",
                        "disabled": "false",
                        "fullname": "020005 食品用着色剂"
                    }
                ]
            }
        ]
    },
    "requestId": "fe7bb14275d94b48a041c371dfde50aa"
}

```

## **<a name="getTmOrderDeliveryFlowList"> 获取商标官文列表信息</a>**
[返回到目录](#menu)
##### URL
[/web/opaction/order/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 请求头中需要增加userpin（用户登录后的凭证）的值
#### 渠道执行的类型 actionType：getOrderDeliveryFlowList

``` javascript
{
    "sourceOrderNoList":["29471633","29956232"]// Y 商标申请号
}

```

#### 返回结果
```javascript
{
    "status": 0,// 0为成功，否则失败
    "msg": "success",
    "data": [
        {
            "sourceOrderNo": "29471633",
            "flowList": [
                {
                    "updated": "2020-02-19T06:53:09.000Z",// 创建时间
                    "tmStatus": "13",//官文状态编码
                    "uploadFileName": "29471633-注册-PASSED.pdf",//上传文件名称
                    "returnReceiptUrl": "http://gsb-public.oss-cn-beijing.aliyuncs.com/netsharp_Z7wfENwQZDWiWFbMsSchDkFJKfBb3Ah4.jpg",//官文回执Url
                    "tmStatusName": "已下发商标注册证"//官文状态名称
                }
            ]
        },
        {
            "sourceOrderNo": "29956232",
            "flowList": [
                {
                    "updated": "2020-02-20T06:53:09.000Z",
                    "tmStatus": "3",
                    "uploadFileName": "29956232-已受理-RECVED.pdf",
                    "returnReceiptUrl": "http://gsb-public.oss-cn-beijing.aliyuncs.com/netsharp_bj38cY3ZkN4AGj48kQGNSEaSMECJXN5c.pdf",
                    "tmStatusName": "已受理"
                }
            ]
        }
    ],
    "requestId": "97b78e24d2a441dca525d36af9b7c75d"
}

```


## **<a name="updateContacts"> 修改订单联系人</a>**
[返回到目录](#menu)
##### URL
[/web/opaction/opOrder/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 请求头中需要增加userpin（用户登录后的凭证）的值
#### 渠道执行的类型 actionType：updateContacts

``` javascript
{    
    "orderNo":"TM26202002271337mkgN",// Y 订单号
    "notes":"订单备注",// N 订单备注
    "orderContact":{ // Y 订单联系人信息
        "contacts": "宋毅",// Y 联系人
        "mobile": "15010929368",// Y 联系人电话
        "email": "songyi@gongsibao.com",// Y 联系人邮箱
        "fax": ""// N 传真
    }        
}

```

#### 返回结果
```javascript
{
    "status":0,// 0为成功，否则失败
    "msg":"success",
    "data":null,
    "requestId":"ab3dbb7dce5b4b44bc1d1c83e887ffee"
}

```

## **<a name="updateTmInfo"> 商标订单修改-商标信息修改</a>**
[返回到目录](#menu)
##### URL
[/web/opaction/opOrder/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 请求头中需要增加userpin（用户登录后的凭证）的值
#### 渠道执行的类型 actionType：updateTmOrder

``` javascript
{
        "orderNo":"TM26202002271337mkgN",// Y 订单号        
        "tm": {
            "colorizedPicUrl": "https://gsb-zc.oss-cn-beijing.aliyuncs.com/zc_word2picb2bc98b9fc564ef2a1f4b3cbe9352f39.jpg",// Y 商标彩色图样
            "tmName": "testbiao",// Y 商标名称
            "channelItemAppendName":"testbiao",// Y 填写的商标名称  如：AA为例：文字不处理为：AA、文字及图处理成：AA及图、图形处理成：图形
            "picUrl": "https://gsb-zc.oss-cn-beijing.aliyuncs.com/zc_word2picb2bc98b9fc564ef2a1f4b3cbe9352f39.jpg",// Y 商标图样       
            "tmFormType": "3"// Y 商标类型形式：1: 立体, 3: 字, 4: 图, 5: 字图, 6: 颜色, 7: 彩色
        }
}

```

#### 返回结果
```javascript
{
    "status":0,// 0为成功，否则失败
    "msg":"success",
    "data":null,
    "requestId":"ab3dbb7dce5b4b44bc1d1c83e887ffenclonese"
}

```

## **<a name="updateNclInfo"> 商标订单修改-商标尼斯信息修改</a>**
[返回到目录](#menu)
##### URL
[/web/opaction/opOrder/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 请求头中需要增加userpin（用户登录后的凭证）的值
#### 渠道执行的类型 actionType：updateTmOrder

``` javascript
{
    "orderNo":"TM26202002271337mkgN",// Y 订单号
    "additions":{// N 附加购买项目
        "payCode": "zzsbzc-2", // Y 支付价格code
        "quantity":2// Y 购买数量
    },
    tmSelectType:{ // N商标类别选择 没有则填写{}
        "selectType":"自助选择", //Y 商标类别选择  智能选择||自助选择||全类保护
        "recommendPath":"" //N 商标类别选择是只能选择的时候保存行业信息  人工智能/技术研究
    },
    "nclones": [
        {
            "code": "02",//大类编码
            "name": "颜料油漆",//大类名称
            "nclThree": [
                {
                    "code": "020008",//小项编码
                    "disabled": "false",
                    "fullname": "020008 绘画用铝粉",//小项编码加名称
                    "name": "绘画用铝粉",//小项名称
                    "pcode": "0202"//小项所属群组编码
                },
                {
                    "code": "020005",
                    "disabled": "false",
                    "fullname": "020005 食品用着色剂",
                    "name": "食品用着色剂",
                    "pcode": "0203"
                }
            ]
        }
    ]
}

```

#### 返回结果
```javascript
{
    "status":0,// 0为成功，否则失败
    "msg":"success",
    "data":null,
    "requestId":"ab3dbb7dce5b4b44bc1d1c83e887ffee"
}

```

## **<a name="updateCustomerInfo"> 商标订单修改-修改申请人信息</a>**
[返回到目录](#menu)
##### URL
[/web/opaction/opOrder/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 请求头中需要增加userpin（用户登录后的凭证）的值
#### 渠道执行的类型 actionType：updateTmOrder

``` javascript
{
    "orderNo":"TM26202002271337mkgN",// Y 订单号
    "apply": {// Y 申请信息
        "applyAddr": "上海市杨浦区国定路346号三楼0624室",// Y 执照详细地址
        "applyArea": "",//申请区域--暂时没有用到
        "businessLicensePic": "https://gsb-zc.oss-cn-beijing.aliyuncs.com/zc_yyzz120315554031547442019316.jpg",// Y 营业执照jpg地址
        "businessLicensePdf": "https://gsb-zc.oss-cn-beijing.aliyuncs.com/zc_yyzz120315554031547442019316.pdf",// Y 营业执照pdf地址
        "code": "91310110398635929J",// Y 统一社会信用代码
        "customerType": "ent",// Y 申请人类型 person个人，ent企业           
        "identityCardNo": "",// N 申请人身份证号--（申请类型为个人有此值）
        "identityCardPic": "",// N 申请人身份证jpg地址--（申请类型为个人有此值）
        "identityCardPdf": "",   // N 申请人身份证pdf地址  --（申请类型为个人有此值）    
        "name": "上海辰者信息科技有限公司",  // Y 申请人名称          
        "zipCode": "100000"// Y 邮政编码
    }
}

```

#### 返回结果
```javascript
{
    "status":0,// 0为成功，否则失败
    "msg":"success",
    "data":null,
    "requestId":"ab3dbb7dce5b4b44bc1d1c83e887ffee"
}

```

## **<a name="updateOfficial"> 商标订单修改-修改交官材料</a>**
[返回到目录](#menu)
##### URL
[/web/opaction/opOrder/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 请求头中需要增加userpin（用户登录后的凭证）的值
#### 渠道执行的类型 actionType：updateTmOrder

``` javascript
{
        "orderNo":"TM26202002271337mkgN",// Y 订单号
        "apply": {// Y 申请信息
            "identityCardPic": "",// N 申请人身份证jpg地址--（申请类型为个人有此值）
            "identityCardPdf": "",   // N 申请人身份证pdf地址  --（申请类型为个人有此值）   
            "businessLicensePic": "https://gsb-zc.oss-cn-beijing.aliyuncs.com/zc_yyzz120315554031547442019316.jpg",// Y 营业执照jpg地址
            "businessLicensePdf": "https://gsb-zc.oss-cn-beijing.aliyuncs.com/zc_yyzz120315554031547442019316.pdf",// Y 营业执照pdf地址   
            "gzwtsUrl": "https://gsb-zc.oss-cn-beijing.aliyuncs.com/zc_wts863215710393842862019914.jpg",// Y 盖章委托书url
            "smwjUrl":""//  N 说明文件url
        }
}

```

#### 返回结果
```javascript
{
    "status":0,// 0为成功，否则失败
    "msg":"success",
    "data":null,
    "requestId":"ab3dbb7dce5b4b44bc1d1c83e887ffee"
}

```

## **<a name="tmConfirm"> 商标方案确认</a>**
[返回到目录](#menu)
##### URL
[/web/opaction/opOrder/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 请求头中需要增加userpin（用户登录后的凭证）的值
#### 渠道执行的类型 actionType：tmConfirm

``` javascript
{
    "orderNo ":"346c3091684e4e0eef",
    "isConfirm ":"1",
    "notes ":"",

}

```

#### 返回结果
```javascript
{
    "status":0,
    "data":null,
    "msg":"商标方案确认成功",
    "requestId":"0c14f04dc187486b829e392dc87c70c6"
}

```

## **<a name="sendAliWtsEmail"> 推送委托书模板邮件(阿里云)</a>**
[返回到目录](#menu)
##### URL
[/web/opaction/opOrder/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 渠道执行的类型 actionType：sendAliWtsEmail

``` javascript
{
    "email ":"zhuangbing@gongsibao.com",
}

```

#### 返回结果
```javascript
{
    "status":0,
    "msg":"success",
    "data":"250 Data Ok: queued as freedom",
    "requestId":"9f0d22bd7afe402f830a559b2e7a412a"
}

```


## **<a name="getNclByCode"> 尼斯智能推荐及大类保护</a>**
[返回到目录](#menu)
##### URL
[/web/action/tmQuery/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 渠道执行的类型 actionType：getNclByCode

``` javascript
{
    "businessCode": "技术研究"//二级行业名称
}

```

#### 返回结果
```javascript
{
    "status": 0,
    "msg": "操作成功",
    "data": [
        {
            "code": "09",
            "name": "科学仪器",
            "nclThree": [
                {
                    "code": "090306",
                    "name": "数据处理设备",
                    "pcode": "0901",
                    "pname": "电子计算机及其外部设备",
                    "disabled": false,
                    "fullname": "090306 数据处理设备"
                },
                {
                    "code": "090373",
                    "name": "已录制的计算机程序",
                    "pcode": "0901",
                    "pname": "电子计算机及其外部设备",
                    "disabled": false,
                    "fullname": "090373 已录制的计算机程序"
                },
                {
                    "code": "090590",
                    "name": "计算机外围设备",
                    "pcode": "0901",
                    "pname": "电子计算机及其外部设备",
                    "disabled": false,
                    "fullname": "090590 计算机外围设备"
                },
                {
                    "code": "090717",
                    "name": "可下载的计算机应用软件",
                    "pcode": "0901",
                    "pname": "电子计算机及其外部设备",
                    "disabled": false,
                    "fullname": "090717 可下载的计算机应用软件"
                },
                {
                    "code": "090732",
                    "name": "计算机硬件",
                    "pcode": "0901",
                    "pname": "电子计算机及其外部设备",
                    "disabled": false,
                    "fullname": "090732 计算机硬件"
                },
                {
                    "code": "090791",
                    "name": "已录制的或可下载的计算机软件平台",
                    "pcode": "0901",
                    "pname": "电子计算机及其外部设备",
                    "disabled": false,
                    "fullname": "090791 已录制的或可下载的计算机软件平台"
                },
                {
                    "code": "C090142",
                    "name": "可下载的手机应用软件",
                    "pcode": "0901",
                    "pname": "电子计算机及其外部设备",
                    "disabled": false,
                    "fullname": "C090142 可下载的手机应用软件"
                }
            ]
        },
        {
            "code": "35",
            "name": "广告销售",
            "nclThree": [
                {
                    "code": "",
                    "name": "计算机网络和网站的在线推广",
                    "pcode": "3501",
                    "pname": "广告",
                    "disabled": false,
                    "fullname": "计算机网络和网站的在线推广"
                },
                {
                    "code": "350025",
                    "name": "工商管理辅助",
                    "pcode": "3502",
                    "pname": "工商管理辅助业",
                    "disabled": false,
                    "fullname": "350025 工商管理辅助"
                },
                {
                    "code": "",
                    "name": "通过互联网提供商业信息服务",
                    "pcode": "3502",
                    "pname": "工商管理辅助业",
                    "disabled": false,
                    "fullname": "通过互联网提供商业信息服务"
                },
                {
                    "code": "",
                    "name": "通过互联网、有线网络或其他形式的数据传输提供商业信息",
                    "pcode": "3502",
                    "pname": "工商管理辅助业",
                    "disabled": false,
                    "fullname": "通过互联网、有线网络或其他形式的数据传输提供商业信息"
                },
                {
                    "code": "",
                    "name": "商业咨询、顾问和信息服务",
                    "pcode": "3502",
                    "pname": "工商管理辅助业",
                    "disabled": false,
                    "fullname": "商业咨询、顾问和信息服务"
                },
                {
                    "code": "",
                    "name": "专业商业咨询",
                    "pcode": "3502",
                    "pname": "工商管理辅助业",
                    "disabled": false,
                    "fullname": "专业商业咨询"
                },
                {
                    "code": "350071",
                    "name": "替他人推销",
                    "pcode": "35",
                    "pname": "",
                    "disabled": false,
                    "fullname": "350071 替他人推销"
                },
                {
                    "code": "350081",
                    "name": "计算机数据库信息系统化",
                    "pcode": "3506",
                    "pname": "办公事务",
                    "disabled": false,
                    "fullname": "350081 计算机数据库信息系统化"
                },
                {
                    "code": "350117",
                    "name": "在计算机数据库中更新和维护数据",
                    "pcode": "3506",
                    "pname": "办公事务",
                    "disabled": false,
                    "fullname": "350117 在计算机数据库中更新和维护数据"
                },
                {
                    "code": "350102",
                    "name": "寻找赞助",
                    "pcode": "3508",
                    "pname": "单一服务",
                    "disabled": false,
                    "fullname": "350102 寻找赞助"
                }
            ]
        },
        {
            "code": "41",
            "name": "教育娱乐",
            "nclThree": [
                {
                    "code": "410017",
                    "name": "培训",
                    "pcode": "4101",
                    "pname": "教育",
                    "disabled": false,
                    "fullname": "410017 培训"
                },
                {
                    "code": "410017",
                    "name": "教学",
                    "pcode": "4101",
                    "pname": "教育",
                    "disabled": false,
                    "fullname": "410017 教学"
                },
                {
                    "code": "410195",
                    "name": "职业再培训",
                    "pcode": "4101",
                    "pname": "教育",
                    "disabled": false,
                    "fullname": "410195 职业再培训"
                },
                {
                    "code": "410207",
                    "name": "通过模拟装置进行的培训服务",
                    "pcode": "4101",
                    "pname": "教育",
                    "disabled": false,
                    "fullname": "410207 通过模拟装置进行的培训服务"
                },
                {
                    "code": "",
                    "name": "设计方面的培训",
                    "pcode": "4101",
                    "pname": "教育",
                    "disabled": false,
                    "fullname": "设计方面的培训"
                },
                {
                    "code": "410070",
                    "name": "安排和组织专家讨论会",
                    "pcode": "4102",
                    "pname": "组织和安排教育、文化、娱乐等活动",
                    "disabled": false,
                    "fullname": "410070 安排和组织专家讨论会"
                },
                {
                    "code": "410076",
                    "name": "安排和组织培训班",
                    "pcode": "4102",
                    "pname": "组织和安排教育、文化、娱乐等活动",
                    "disabled": false,
                    "fullname": "410076 安排和组织培训班"
                },
                {
                    "code": "410187",
                    "name": "除广告以外的版面设计",
                    "pcode": "4104",
                    "pname": "出版服务",
                    "disabled": false,
                    "fullname": "410187 除广告以外的版面设计"
                },
                {
                    "code": "",
                    "name": "通过互联网方式提供的电子游戏服务",
                    "pcode": "4105",
                    "pname": "文娱、体育活动的服务",
                    "disabled": false,
                    "fullname": "通过互联网方式提供的电子游戏服务"
                },
                {
                    "code": "",
                    "name": "提供在线计算机游戏",
                    "pcode": "4105",
                    "pname": "文娱、体育活动的服务",
                    "disabled": false,
                    "fullname": "提供在线计算机游戏"
                }
            ]
        },
        {
            "code": "42",
            "name": "网站服务",
            "nclThree": [
                {
                    "code": "420040",
                    "name": "技术研究",
                    "pcode": "4209",
                    "pname": "提供科学技术研究服务",
                    "disabled": false,
                    "fullname": "420040 技术研究"
                },
                {
                    "code": "420061",
                    "name": "技术项目研究",
                    "pcode": "4209",
                    "pname": "提供科学技术研究服务",
                    "disabled": false,
                    "fullname": "420061 技术项目研究"
                },
                {
                    "code": "",
                    "name": "替他人开发产品",
                    "pcode": "4209",
                    "pname": "提供科学技术研究服务",
                    "disabled": false,
                    "fullname": "替他人开发产品"
                },
                {
                    "code": "",
                    "name": "技术开发领域的咨询服务",
                    "pcode": "4209",
                    "pname": "提供科学技术研究服务",
                    "disabled": false,
                    "fullname": "技术开发领域的咨询服务"
                },
                {
                    "code": "产品测试420194",
                    "name": "计算机系统设计",
                    "pcode": "4220",
                    "pname": "计算机编程及相关服务",
                    "disabled": false,
                    "fullname": "产品测试420194 计算机系统设计"
                },
                {
                    "code": "420220",
                    "name": "软件即服务（SaaS）",
                    "pcode": "4220",
                    "pname": "计算机编程及相关服务",
                    "disabled": false,
                    "fullname": "420220 软件即服务（SaaS）"
                },
                {
                    "code": "420229",
                    "name": "云计算",
                    "pcode": "4220",
                    "pname": "计算机编程及相关服务",
                    "disabled": false,
                    "fullname": "420229 云计算"
                },
                {
                    "code": "420230",
                    "name": "外包商提供的信息技术服务",
                    "pcode": "4220",
                    "pname": "计算机编程及相关服务",
                    "disabled": false,
                    "fullname": "420230 外包商提供的信息技术服务"
                },
                {
                    "code": "",
                    "name": "为他人提供计算机软件设计",
                    "pcode": "4220",
                    "pname": "计算机编程及相关服务",
                    "disabled": false,
                    "fullname": "为他人提供计算机软件设计"
                }
            ]
        }
    ],
    "bizmsg": "empty",
    "requestId": "25e1f406b03f46ed80cced320a6c52a1"
}

```

## **<a name="getAllNcl"> 全类保护</a>**
[返回到目录](#menu)
##### URL
[/web/action/tmQuery/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 渠道执行的类型 actionType：getAllNcl

``` javascript
{
}

```

#### 返回结果
``` javascript
{
    "status": 0,
    "msg": "操作成功",
    "data": [
        {
            "code": "01",
            "name": "化学制剂、肥料",
            "nclThree": [
                {
                    "code": "010122",
                    "name": "生物化学催化剂",
                    "pcode": "0106",
                    "pname": "化学试剂",
                    "disabled": false,
                    "fullname": "010122 生物化学催化剂"
                },
                {
                    "code": "010077",
                    "name": "纺织工业用上浆料",
                    "pcode": "0104",
                    "pname": "用于工业、科学的化学品、化学制剂，不属于其他类别的产品用的化学制品",
                    "disabled": false,
                    "fullname": "010077 纺织工业用上浆料"
                },
                {
                    "code": "010438",
                    "name": "未加工塑料",
                    "pcode": "0108",
                    "pname": "未加工的人造合成树脂，未加工塑料物质（不包括未加工的天然树脂）",
                    "disabled": false,
                    "fullname": "010438 未加工塑料"
                },
                {
                    "code": "010031",
                    "name": "除杀真菌剂、除草剂、杀虫剂、杀寄生虫剂外的农业化学品",
                    "pcode": "0105",
                    "pname": "用于农业、园艺、林业的化学品、化学制剂",
                    "disabled": false,
                    "fullname": "010031 除杀真菌剂、除草剂、杀虫剂、杀寄生虫剂外的农业化学品"
                },
                {
                    "code": "010040",
                    "name": "酒精",
                    "pcode": "0102",
                    "pname": "用于工业、科学、农业、园艺、林业的工业化工原料",
                    "disabled": false,
                    "fullname": "010040 酒精"
                },
                {
                    "code": "010365",
                    "name": "化学用碘",
                    "pcode": "0101",
                    "pname": "工业气体，单质",
                    "disabled": false,
                    "fullname": "010365 化学用碘"
                },
                {
                    "code": "010315",
                    "name": "刹车液",
                    "pcode": "0104",
                    "pname": "用于工业、科学的化学品、化学制剂，不属于其他类别的产品用的化学制品",
                    "disabled": false,
                    "fullname": "010315 刹车液"
                },
                {
                    "code": "010271",
                    "name": "肥料",
                    "pcode": "01",
                    "pname": "",
                    "disabled": false,
                    "fullname": "010271 肥料"
                },
                {
                    "code": "010037",
                    "name": "碱",
                    "pcode": "0102",
                    "pname": "用于工业、科学、农业、园艺、林业的工业化工原料",
                    "disabled": false,
                    "fullname": "010037 碱"
                },
                {
                    "code": "010211",
                    "name": "摄影用化学制剂",
                    "pcode": "0107",
                    "pname": "摄影用化学用品及材料",
                    "disabled": false,
                    "fullname": "010211 摄影用化学制剂"
                }
            ]
        },
        {
            "code": "02",
            "name": "颜料油漆",
            "nclThree": [
                {
                    "code": "020066",
                    "name": "印刷油墨",
                    "pcode": "0204",
                    "pname": "油墨",
                    "disabled": false,
                    "fullname": "020066 印刷油墨"
                },
                {
                    "code": "020090",
                    "name": "绘画、装饰、印刷和艺术用金属粉",
                    "pcode": "0202",
                    "pname": "颜料（不包括食用、绝缘用），绘画、装饰、印刷和艺术用金属箔及金属粉",
                    "disabled": false,
                    "fullname": "020090 绘画、装饰、印刷和艺术用金属粉"
                },
                {
                    "code": "020121",
                    "name": "打印机和复印机用墨水",
                    "pcode": "0204",
                    "pname": "油墨",
                    "disabled": false,
                    "fullname": "020121 打印机和复印机用墨水"
                },
                {
                    "code": "020057",
                    "name": "皮革染色剂",
                    "pcode": "0201",
                    "pname": "染料，媒染剂（不包括食用）",
                    "disabled": false,
                    "fullname": "020057 皮革染色剂"
                },
                {
                    "code": "020128",
                    "name": "可食用墨",
                    "pcode": "0204",
                    "pname": "油墨",
                    "disabled": false,
                    "fullname": "020128 可食用墨"
                },
                {
                    "code": "020058",
                    "name": "染料",
                    "pcode": "0201",
                    "pname": "染料，媒染剂（不包括食用）",
                    "disabled": false,
                    "fullname": "020058 染料"
                },
                {
                    "code": "020002",
                    "name": "媒染剂",
                    "pcode": "0201",
                    "pname": "染料，媒染剂（不包括食用）",
                    "disabled": false,
                    "fullname": "020002 媒染剂"
                },
                {
                    "code": "020005",
                    "name": "食品用着色剂",
                    "pcode": "0203",
                    "pname": "食品着色剂",
                    "disabled": false,
                    "fullname": "020005 食品用着色剂"
                },
                {
                    "code": "020047",
                    "name": "染色剂",
                    "pcode": "0201",
                    "pname": "染料，媒染剂（不包括食用）",
                    "disabled": false,
                    "fullname": "020047 染色剂"
                },
                {
                    "code": "020059",
                    "name": "颜料",
                    "pcode": "0202",
                    "pname": "颜料（不包括食用、绝缘用），绘画、装饰、印刷和艺术用金属箔及金属粉",
                    "disabled": false,
                    "fullname": "020059 颜料"
                }
            ]
        },
        {
            "code": "03",
            "name": "日化用品",
            "nclThree": [
                {
                    "code": "C030007",
                    "name": "洗面奶",
                    "pcode": "0301",
                    "pname": "肥皂，香皂及其他人用洗洁物品，洗衣用漂白剂及其他物料",
                    "disabled": false,
                    "fullname": "C030007 洗面奶"
                },
                {
                    "code": "030152",
                    "name": "香皂",
                    "pcode": "0301",
                    "pname": "肥皂，香皂及其他人用洗洁物品，洗衣用漂白剂及其他物料",
                    "disabled": false,
                    "fullname": "030152 香皂"
                },
                {
                    "code": "030045",
                    "name": "抛光制剂",
                    "pcode": "0303",
                    "pname": "抛光、擦亮制剂",
                    "disabled": false,
                    "fullname": "030045 抛光制剂"
                },
                {
                    "code": "C030067",
                    "name": "洗衣粉",
                    "pcode": "0301",
                    "pname": "肥皂，香皂及其他人用洗洁物品，洗衣用漂白剂及其他物料",
                    "disabled": false,
                    "fullname": "C030067 洗衣粉"
                },
                {
                    "code": "030020",
                    "name": "美容面膜",
                    "pcode": "0306",
                    "pname": "化妆品（不包括动物用化妆品）",
                    "disabled": false,
                    "fullname": "030020 美容面膜"
                },
                {
                    "code": "030165",
                    "name": "研磨材料",
                    "pcode": "0304",
                    "pname": "研磨用材料及其制剂",
                    "disabled": false,
                    "fullname": "030165 研磨材料"
                },
                {
                    "code": "030141",
                    "name": "香料",
                    "pcode": "0305",
                    "pname": "香料，香精油",
                    "disabled": false,
                    "fullname": "030141 香料"
                },
                {
                    "code": "030100",
                    "name": "香精油",
                    "pcode": "0305",
                    "pname": "香料，香精油",
                    "disabled": false,
                    "fullname": "030100 香精油"
                },
                {
                    "code": "030104",
                    "name": "清洁制剂",
                    "pcode": "0302",
                    "pname": "清洁、去渍用制剂",
                    "disabled": false,
                    "fullname": "030104 清洁制剂"
                },
                {
                    "code": "030065",
                    "name": "化妆品",
                    "pcode": "0306",
                    "pname": "化妆品（不包括动物用化妆品）",
                    "disabled": false,
                    "fullname": "030065 化妆品"
                }
            ]
        },
        {
            "code": "04",
            "name": "燃料油脂",
            "nclThree": [
                {
                    "code": "040007",
                    "name": "引火物",
                    "pcode": "0403",
                    "pname": "固体燃料",
                    "disabled": false,
                    "fullname": "040007 引火物"
                },
                {
                    "code": "040084",
                    "name": "燃料油",
                    "pcode": "0402",
                    "pname": "液体、气体燃料和照明燃料",
                    "disabled": false,
                    "fullname": "040084 燃料油"
                },
                {
                    "code": "040049",
                    "name": "气体燃料",
                    "pcode": "0402",
                    "pname": "液体、气体燃料和照明燃料",
                    "disabled": false,
                    "fullname": "040049 气体燃料"
                },
                {
                    "code": "040014",
                    "name": "木炭（燃料）",
                    "pcode": "0403",
                    "pname": "固体燃料",
                    "disabled": false,
                    "fullname": "040014 木炭（燃料）"
                },
                {
                    "code": "040063",
                    "name": "润滑剂",
                    "pcode": "0401",
                    "pname": "工业用油及油脂，润滑油，润滑剂（不包括燃料用油）",
                    "disabled": false,
                    "fullname": "040063 润滑剂"
                },
                {
                    "code": "040056",
                    "name": "润湿油",
                    "pcode": "0401",
                    "pname": "工业用油及油脂，润滑油，润滑剂（不包括燃料用油）",
                    "disabled": false,
                    "fullname": "040056 润湿油"
                },
                {
                    "code": "040025",
                    "name": "燃料",
                    "pcode": "0403",
                    "pname": "固体燃料",
                    "disabled": false,
                    "fullname": "040025 燃料"
                },
                {
                    "code": "040058",
                    "name": "炊具防粘用豆油制剂",
                    "pcode": "0401",
                    "pname": "工业用油及油脂，润滑油，润滑剂（不包括燃料用油）",
                    "disabled": false,
                    "fullname": "040058 炊具防粘用豆油制剂"
                },
                {
                    "code": "040039",
                    "name": "照明用油",
                    "pcode": "0402",
                    "pname": "液体、气体燃料和照明燃料",
                    "disabled": false,
                    "fullname": "040039 照明用油"
                },
                {
                    "code": "040085",
                    "name": "发动机燃料用非化学添加剂",
                    "pcode": "0402",
                    "pname": "液体、气体燃料和照明燃料",
                    "disabled": false,
                    "fullname": "040085 发动机燃料用非化学添加剂"
                }
            ]
        },
        {
            "code": "05",
            "name": "医药",
            "nclThree": [
                {
                    "code": "050298",
                    "name": "婴儿食品",
                    "pcode": "0502",
                    "pname": "医用营养品，人用膳食补充剂，婴儿食品",
                    "disabled": false,
                    "fullname": "050298 婴儿食品"
                },
                {
                    "code": "C050015",
                    "name": "中药成药",
                    "pcode": "0501",
                    "pname": "药品，消毒剂，中药药材，药酒",
                    "disabled": false,
                    "fullname": "C050015 中药成药"
                },
                {
                    "code": "050117",
                    "name": "净化剂",
                    "pcode": "0503",
                    "pname": "净化制剂",
                    "disabled": false,
                    "fullname": "050117 净化剂"
                },
                {
                    "code": "050005",
                    "name": "空气净化制剂",
                    "pcode": "0503",
                    "pname": "净化制剂",
                    "disabled": false,
                    "fullname": "050005 空气净化制剂"
                },
                {
                    "code": "050329",
                    "name": "兽医用药",
                    "pcode": "0504",
                    "pname": "兽药，动物用膳食补充剂",
                    "disabled": false,
                    "fullname": "050329 兽医用药"
                },
                {
                    "code": "050441",
                    "name": "消毒剂",
                    "pcode": "0501",
                    "pname": "药品，消毒剂，中药药材，药酒",
                    "disabled": false,
                    "fullname": "050441 消毒剂"
                },
                {
                    "code": "050328",
                    "name": "人用药",
                    "pcode": "0501",
                    "pname": "药品，消毒剂，中药药材，药酒",
                    "disabled": false,
                    "fullname": "050328 人用药"
                },
                {
                    "code": "050350",
                    "name": "医用营养品",
                    "pcode": "0502",
                    "pname": "医用营养品，人用膳食补充剂，婴儿食品",
                    "disabled": false,
                    "fullname": "050350 医用营养品"
                },
                {
                    "code": "C050020",
                    "name": "艾卷",
                    "pcode": "0501",
                    "pname": "药品，消毒剂，中药药材，药酒",
                    "disabled": false,
                    "fullname": "C050020 艾卷"
                },
                {
                    "code": "C050025",
                    "name": "药酒",
                    "pcode": "0501",
                    "pname": "药品，消毒剂，中药药材，药酒",
                    "disabled": false,
                    "fullname": "C050025 药酒"
                }
            ]
        },
        {
            "code": "06",
            "name": "金属材料",
            "nclThree": [
                {
                    "code": "060127",
                    "name": "金属管",
                    "pcode": "0602",
                    "pname": "普通金属管及其配件",
                    "disabled": false,
                    "fullname": "060127 金属管"
                },
                {
                    "code": "060034",
                    "name": "保险柜（金属或非金属）",
                    "pcode": "0611",
                    "pname": "保险箱柜",
                    "disabled": false,
                    "fullname": "060034 保险柜（金属或非金属）"
                },
                {
                    "code": "060341",
                    "name": "金属绳索",
                    "pcode": "0605",
                    "pname": "非电气用缆索和金属线、网、带",
                    "disabled": false,
                    "fullname": "060341 金属绳索"
                },
                {
                    "code": "060285",
                    "name": "包装或捆扎用金属带",
                    "pcode": "0605",
                    "pname": "非电气用缆索和金属线、网、带",
                    "disabled": false,
                    "fullname": "060285 包装或捆扎用金属带"
                },
                {
                    "code": "060231",
                    "name": "金属包装容器",
                    "pcode": "0613",
                    "pname": "金属容器",
                    "disabled": false,
                    "fullname": "060231 金属包装容器"
                },
                {
                    "code": "060227",
                    "name": "五金器具",
                    "pcode": "0607",
                    "pname": "钉及标准紧固件",
                    "disabled": false,
                    "fullname": "060227 五金器具"
                },
                {
                    "code": "060144",
                    "name": "金属锁（非电）",
                    "pcode": "0610",
                    "pname": "非电子锁",
                    "disabled": false,
                    "fullname": "060144 金属锁（非电）"
                },
                {
                    "code": "060170",
                    "name": "可移动金属建筑物",
                    "pcode": "0603",
                    "pname": "金属建筑材料，可移动金属建筑物（不包括建筑小五金）",
                    "disabled": false,
                    "fullname": "060170 可移动金属建筑物"
                },
                {
                    "code": "060182",
                    "name": "未加工或半加工普通金属",
                    "pcode": "0601",
                    "pname": "普通金属及其合金、板、各种型材（不包括焊接及铁路用金属材料）",
                    "disabled": false,
                    "fullname": "060182 未加工或半加工普通金属"
                },
                {
                    "code": "060227",
                    "name": "小五金器具",
                    "pcode": "0609",
                    "pname": "日用五金器具",
                    "disabled": false,
                    "fullname": "060227 小五金器具"
                }
            ]
        },
        {
            "code": "07",
            "name": "机械设备",
            "nclThree": [
                {
                    "code": "070218",
                    "name": "印刷机器",
                    "pcode": "0705",
                    "pname": "印刷工业用机械及器具",
                    "disabled": false,
                    "fullname": "070218 印刷机器"
                },
                {
                    "code": "070284",
                    "name": "非手动的手持工具",
                    "pcode": "0743",
                    "pname": "非手动的手持工具",
                    "disabled": false,
                    "fullname": "070284 非手动的手持工具"
                },
                {
                    "code": "070423",
                    "name": "制食品用电动机械",
                    "pcode": "0709",
                    "pname": "食品业用机械及部件",
                    "disabled": false,
                    "fullname": "070423 制食品用电动机械"
                },
                {
                    "code": "C070144",
                    "name": "土特产杂品加工机械",
                    "pcode": "0718",
                    "pname": "日用杂品加工机械",
                    "disabled": false,
                    "fullname": "C070144 土特产杂品加工机械"
                },
                {
                    "code": "070328",
                    "name": "熨衣机",
                    "pcode": "0713",
                    "pname": "缝纫、制鞋工业用机械",
                    "disabled": false,
                    "fullname": "070328 熨衣机"
                },
                {
                    "code": "070018",
                    "name": "交流发电机",
                    "pcode": "0748",
                    "pname": "发电机，非陆地车辆用马达和引擎，马达和引擎零部件",
                    "disabled": false,
                    "fullname": "070018 交流发电机"
                },
                {
                    "code": "070315",
                    "name": "电动制饮料机",
                    "pcode": "0710",
                    "pname": "酿造、饮料工业用机械",
                    "disabled": false,
                    "fullname": "070315 电动制饮料机"
                },
                {
                    "code": "070475",
                    "name": "食品加工机（电动）",
                    "pcode": "0723",
                    "pname": "厨房家用器具（不包括烹调、电气加热设备及厨房手工具）",
                    "disabled": false,
                    "fullname": "070475 食品加工机（电动）"
                },
                {
                    "code": "070008",
                    "name": "农业机械",
                    "pcode": "0701",
                    "pname": "农业用机械及部件（不包括小农具）",
                    "disabled": false,
                    "fullname": "070008 农业机械"
                },
                {
                    "code": "070177",
                    "name": "包装机",
                    "pcode": "0721",
                    "pname": "包装机械（不包括成套设备专用包装机械）",
                    "disabled": false,
                    "fullname": "070177 包装机"
                }
            ]
        },
        {
            "code": "08",
            "name": "手工器械",
            "nclThree": [
                {
                    "code": "080079",
                    "name": "水果采摘用具（手工具）",
                    "pcode": "0803",
                    "pname": "林业、园艺用手工具",
                    "disabled": false,
                    "fullname": "080079 水果采摘用具（手工具）"
                },
                {
                    "code": "080019",
                    "name": "动物剥皮用器具和工具",
                    "pcode": "0804",
                    "pname": "畜牧业用手工具",
                    "disabled": false,
                    "fullname": "080019 动物剥皮用器具和工具"
                },
                {
                    "code": "080145",
                    "name": "园艺工具（手动的）",
                    "pcode": "0803",
                    "pname": "林业、园艺用手工具",
                    "disabled": false,
                    "fullname": "080145 园艺工具（手动的）"
                },
                {
                    "code": "080219",
                    "name": "个人用理发推子（电动和非电动）",
                    "pcode": "0806",
                    "pname": "理发工具，修指甲刀，文身器具",
                    "disabled": false,
                    "fullname": "080219 个人用理发推子（电动和非电动）"
                },
                {
                    "code": "080002",
                    "name": "磨具（手工具）",
                    "pcode": "0801",
                    "pname": "手动研磨器具",
                    "disabled": false,
                    "fullname": "080002 磨具（手工具）"
                },
                {
                    "code": "080110",
                    "name": "铲（手工具）",
                    "pcode": "0802",
                    "pname": "小农具（不包括农业、园艺用刀剪）",
                    "disabled": false,
                    "fullname": "080110 铲（手工具）"
                },
                {
                    "code": "080072",
                    "name": "手动的手工具",
                    "pcode": "0810",
                    "pname": "刀剪（不包括机械刀片，文具刀）",
                    "disabled": false,
                    "fullname": "080072 手动的手工具"
                },
                {
                    "code": "080170",
                    "name": "捕鱼鱼叉",
                    "pcode": "0805",
                    "pname": "渔业用手工具",
                    "disabled": false,
                    "fullname": "080170 捕鱼鱼叉"
                },
                {
                    "code": "080026",
                    "name": "剃须刀",
                    "pcode": "0806",
                    "pname": "理发工具，修指甲刀，文身器具",
                    "disabled": false,
                    "fullname": "080026 剃须刀"
                },
                {
                    "code": "080230",
                    "name": "切割工具（手工具）",
                    "pcode": "0807",
                    "pname": "非动力手工具（不包括刀、剪）",
                    "disabled": false,
                    "fullname": "080230 切割工具（手工具）"
                }
            ]
        },
        {
            "code": "09",
            "name": "科学仪器",
            "nclThree": [
                {
                    "code": "090553",
                    "name": "电源材料（电线、电缆）",
                    "pcode": "0912",
                    "pname": "光电传输材料",
                    "disabled": false,
                    "fullname": "090553 电源材料（电线、电缆）"
                },
                {
                    "code": "C090145",
                    "name": "人脸识别设备",
                    "pcode": "0902",
                    "pname": "记录、记数检测器",
                    "disabled": false,
                    "fullname": "C090145 人脸识别设备"
                },
                {
                    "code": "090270",
                    "name": "无线电设备",
                    "pcode": "0907",
                    "pname": "通信导航设备",
                    "disabled": false,
                    "fullname": "090270 无线电设备"
                },
                {
                    "code": "090150",
                    "name": "电动调节装置",
                    "pcode": "0913",
                    "pname": "电器用晶体及碳素材料，电子、电气通用元件",
                    "disabled": false,
                    "fullname": "090150 电动调节装置"
                },
                {
                    "code": "090311",
                    "name": "非空气、非水处理用电离设备",
                    "pcode": "0915",
                    "pname": "电解装置",
                    "disabled": false,
                    "fullname": "090311 非空气、非水处理用电离设备"
                },
                {
                    "code": "090184",
                    "name": "照相机（摄影）",
                    "pcode": "0909",
                    "pname": "摄影、电影用具及仪器",
                    "disabled": false,
                    "fullname": "090184 照相机（摄影）"
                },
                {
                    "code": "C090143",
                    "name": "行车记录仪",
                    "pcode": "0908",
                    "pname": "音像设备",
                    "disabled": false,
                    "fullname": "C090143 行车记录仪"
                },
                {
                    "code": "090097",
                    "name": "办公室用打卡机",
                    "pcode": "0903",
                    "pname": "其他办公用机械（不包括打字机、誊写机、油印机）",
                    "disabled": false,
                    "fullname": "090097 办公室用打卡机"
                },
                {
                    "code": "090130",
                    "name": "工业遥控操作用电气设备",
                    "pcode": "0914",
                    "pname": "电器成套设备及控制装置",
                    "disabled": false,
                    "fullname": "090130 工业遥控操作用电气设备"
                },
                {
                    "code": "090242",
                    "name": "计量仪器",
                    "pcode": "0910",
                    "pname": "测量仪器仪表，实验室用器具，电测量仪器，科学仪器",
                    "disabled": false,
                    "fullname": "090242 计量仪器"
                }
            ]
        },
        {
            "code": "10",
            "name": "医疗器械",
            "nclThree": [
                {
                    "code": "100114",
                    "name": "医疗器械和仪器",
                    "pcode": "1001",
                    "pname": "外科、医疗和兽医用仪器、器械、设备，不包括电子、核子、电疗、医疗用Ｘ光设备、器械及仪器",
                    "disabled": false,
                    "fullname": "100114 医疗器械和仪器"
                },
                {
                    "code": "100073",
                    "name": "牙科设备和仪器",
                    "pcode": "1002",
                    "pname": "牙科设备及器具",
                    "disabled": false,
                    "fullname": "100073 牙科设备和仪器"
                },
                {
                    "code": "100107",
                    "name": "吸奶器",
                    "pcode": "1005",
                    "pname": "奶嘴，奶瓶",
                    "disabled": false,
                    "fullname": "100107 吸奶器"
                },
                {
                    "code": "100108",
                    "name": "医用灯",
                    "pcode": "1001",
                    "pname": "外科、医疗和兽医用仪器、器械、设备，不包括电子、核子、电疗、医疗用Ｘ光设备、器械及仪器",
                    "disabled": false,
                    "fullname": "100108 医用灯"
                },
                {
                    "code": "100064",
                    "name": "医用垫",
                    "pcode": "1004",
                    "pname": "医疗用辅助器具、设备和用品",
                    "disabled": false,
                    "fullname": "100064 医用垫"
                },
                {
                    "code": "100086",
                    "name": "医用泵",
                    "pcode": "1001",
                    "pname": "外科、医疗和兽医用仪器、器械、设备，不包括电子、核子、电疗、医疗用Ｘ光设备、器械及仪器",
                    "disabled": false,
                    "fullname": "100086 医用泵"
                },
                {
                    "code": "100028",
                    "name": "奶瓶",
                    "pcode": "1005",
                    "pname": "奶嘴，奶瓶",
                    "disabled": false,
                    "fullname": "100028 奶瓶"
                },
                {
                    "code": "100037",
                    "name": "救护车用担架",
                    "pcode": "1004",
                    "pname": "医疗用辅助器具、设备和用品",
                    "disabled": false,
                    "fullname": "100037 救护车用担架"
                },
                {
                    "code": "100196",
                    "name": "理疗设备",
                    "pcode": "1003",
                    "pname": "医疗用电子、核子、电疗和Ｘ光设备",
                    "disabled": false,
                    "fullname": "100196 理疗设备"
                },
                {
                    "code": "C100010",
                    "name": "口罩",
                    "pcode": "1004",
                    "pname": "医疗用辅助器具、设备和用品",
                    "disabled": false,
                    "fullname": "C100010 口罩"
                }
            ]
        },
        {
            "code": "11",
            "name": "灯具空调",
            "nclThree": [
                {
                    "code": "110040",
                    "name": "灯",
                    "pcode": "1101",
                    "pname": "照明用设备、器具（不包括汽灯、油灯）",
                    "disabled": false,
                    "fullname": "110040 灯"
                },
                {
                    "code": "110027",
                    "name": "运载工具用灯",
                    "pcode": "1101",
                    "pname": "照明用设备、器具（不包括汽灯、油灯）",
                    "disabled": false,
                    "fullname": "110027 运载工具用灯"
                },
                {
                    "code": "110109",
                    "name": "烹调用装置和设备",
                    "pcode": "1104",
                    "pname": "烹调及民用电气加热设备（不包括厨房用手工用具，食品加工机器）",
                    "disabled": false,
                    "fullname": "110109 烹调用装置和设备"
                },
                {
                    "code": "110016",
                    "name": "热气装置",
                    "pcode": "1107",
                    "pname": "加温、蒸汽设备（包括工业用炉、锅炉，不包括机车锅炉、锅驼机锅炉、蒸汽机锅炉）",
                    "disabled": false,
                    "fullname": "110016 热气装置"
                },
                {
                    "code": "110073",
                    "name": "供暖装置",
                    "pcode": "1108",
                    "pname": "供暖装置及水暖管件",
                    "disabled": false,
                    "fullname": "110073 供暖装置"
                },
                {
                    "code": "110014",
                    "name": "空气调节设备",
                    "pcode": "1106",
                    "pname": "干燥、通风、空调设备（包括冷暖房设备），气体净化设备",
                    "disabled": false,
                    "fullname": "110014 空气调节设备"
                },
                {
                    "code": "110096",
                    "name": "水分配设备",
                    "pcode": "1108",
                    "pname": "供暖装置及水暖管件",
                    "disabled": false,
                    "fullname": "110096 水分配设备"
                },
                {
                    "code": "110155",
                    "name": "冷冻设备和机器",
                    "pcode": "1105",
                    "pname": "制冷、冷藏设备（不包括冷藏车）",
                    "disabled": false,
                    "fullname": "110155 冷冻设备和机器"
                },
                {
                    "code": "110138",
                    "name": "气体净化装置",
                    "pcode": "1106",
                    "pname": "干燥、通风、空调设备（包括冷暖房设备），气体净化设备",
                    "disabled": false,
                    "fullname": "110138 气体净化装置"
                },
                {
                    "code": "110047",
                    "name": "锅炉（非机器部件）",
                    "pcode": "1107",
                    "pname": "加温、蒸汽设备（包括工业用炉、锅炉，不包括机车锅炉、锅驼机锅炉、蒸汽机锅炉）",
                    "disabled": false,
                    "fullname": "110047 锅炉（非机器部件）"
                }
            ]
        },
        {
            "code": "12",
            "name": "运输工具",
            "nclThree": [
                {
                    "code": "120130",
                    "name": "陆地车辆引擎",
                    "pcode": "1202",
                    "pname": "汽车、电车、摩托车及其零部件（不包括轮胎）",
                    "disabled": false,
                    "fullname": "120130 陆地车辆引擎"
                },
                {
                    "code": "120297",
                    "name": "电动自行车",
                    "pcode": "1204",
                    "pname": "自行车、三轮车及其零部件（不包括轮胎）",
                    "disabled": false,
                    "fullname": "120297 电动自行车"
                },
                {
                    "code": "120110",
                    "name": "电动运载工具",
                    "pcode": "1205",
                    "pname": "缆车，架空运输设备",
                    "disabled": false,
                    "fullname": "120110 电动运载工具"
                },
                {
                    "code": "120004",
                    "name": "架空运输设备",
                    "pcode": "1205",
                    "pname": "缆车，架空运输设备",
                    "disabled": false,
                    "fullname": "120004 架空运输设备"
                },
                {
                    "code": "120044",
                    "name": "自行车",
                    "pcode": "1204",
                    "pname": "自行车、三轮车及其零部件（不包括轮胎）",
                    "disabled": false,
                    "fullname": "120044 自行车"
                },
                {
                    "code": "120110",
                    "name": "电动运载工具",
                    "pcode": "1205",
                    "pname": "缆车，架空运输设备",
                    "disabled": false,
                    "fullname": "120110 电动运载工具"
                },
                {
                    "code": "120193",
                    "name": "陆、空、水或铁路用机动运载工具",
                    "pcode": "1204",
                    "pname": "自行车、三轮车及其零部件（不包括轮胎）",
                    "disabled": false,
                    "fullname": "120193 陆、空、水或铁路用机动运载工具"
                },
                {
                    "code": "120219",
                    "name": "马车",
                    "pcode": "1207",
                    "pname": "畜力车辆，雪橇",
                    "disabled": false,
                    "fullname": "120219 马车"
                },
                {
                    "code": "120317",
                    "name": "自平衡车",
                    "pcode": "1204",
                    "pname": "自行车、三轮车及其零部件（不包括轮胎）",
                    "disabled": false,
                    "fullname": "120317 自平衡车"
                },
                {
                    "code": "120163",
                    "name": "婴儿车",
                    "pcode": "1206",
                    "pname": "轮椅，手推车，儿童推车",
                    "disabled": false,
                    "fullname": "120163 婴儿车"
                }
            ]
        },
        {
            "code": "13",
            "name": "军火烟火",
            "nclThree": [
                {
                    "code": "",
                    "name": "130009",
                    "pcode": "",
                    "pname": "",
                    "disabled": false,
                    "fullname": "130009 火器130010 火器清洁刷130029 角状火药容器130042 火器弹药130077 随身武器（火器）130005 硝酸铵炸药130006 雷管130018 起爆栓130034 炸药130060 炸药导火线"
                },
                null,
                null,
                null,
                null,
                null,
                null,
                null,
                null,
                null
            ]
        },
        {
            "code": "14",
            "name": "珠宝钟表",
            "nclThree": [
                {
                    "code": "140055",
                    "name": "未加工或半加工贵金属",
                    "pcode": "1401",
                    "pname": "贵金属及其合金",
                    "disabled": false,
                    "fullname": "140055 未加工或半加工贵金属"
                },
                {
                    "code": "140109",
                    "name": "贵金属制艺术品",
                    "pcode": "1403",
                    "pname": "珠宝，首饰，宝石及贵金属制纪念品",
                    "disabled": false,
                    "fullname": "140109 贵金属制艺术品"
                },
                {
                    "code": "140113",
                    "name": "贵金属制盒",
                    "pcode": "1402",
                    "pname": "贵金属盒",
                    "disabled": false,
                    "fullname": "140113 贵金属制盒"
                },
                {
                    "code": "140166",
                    "name": "首饰盒",
                    "pcode": "1402",
                    "pname": "贵金属盒",
                    "disabled": false,
                    "fullname": "140166 首饰盒"
                },
                {
                    "code": "140097",
                    "name": "人造珠宝",
                    "pcode": "1403",
                    "pname": "珠宝，首饰，宝石及贵金属制纪念品",
                    "disabled": false,
                    "fullname": "140097 人造珠宝"
                },
                {
                    "code": "C140003",
                    "name": "翡翠",
                    "pcode": "1403",
                    "pname": "珠宝，首饰，宝石及贵金属制纪念品",
                    "disabled": false,
                    "fullname": "C140003 翡翠"
                },
                {
                    "code": "140018",
                    "name": "首饰用小饰物",
                    "pcode": "1403",
                    "pname": "珠宝，首饰，宝石及贵金属制纪念品",
                    "disabled": false,
                    "fullname": "140018 首饰用小饰物"
                },
                {
                    "code": "140050",
                    "name": "珠宝首饰",
                    "pcode": "1403",
                    "pname": "珠宝，首饰，宝石及贵金属制纪念品",
                    "disabled": false,
                    "fullname": "140050 珠宝首饰"
                },
                {
                    "code": "140003",
                    "name": "贵金属锭",
                    "pcode": "1401",
                    "pname": "贵金属及其合金",
                    "disabled": false,
                    "fullname": "140003 贵金属锭"
                },
                {
                    "code": "140169",
                    "name": "首饰配件",
                    "pcode": "1403",
                    "pname": "珠宝，首饰，宝石及贵金属制纪念品",
                    "disabled": false,
                    "fullname": "140169 首饰配件"
                }
            ]
        },
        {
            "code": "15",
            "name": "乐器",
            "nclThree": [
                {
                    "code": "C150009",
                    "name": "箫",
                    "pcode": "1501",
                    "pname": "乐器",
                    "disabled": false,
                    "fullname": "C150009 箫"
                },
                {
                    "code": "150008",
                    "name": "钢琴",
                    "pcode": "1501",
                    "pname": "乐器",
                    "disabled": false,
                    "fullname": "150008 钢琴"
                },
                {
                    "code": "C150003",
                    "name": "打击乐器",
                    "pcode": "1501",
                    "pname": "乐器",
                    "disabled": false,
                    "fullname": "C150003 打击乐器"
                },
                {
                    "code": "150039",
                    "name": "吉他",
                    "pcode": "1501",
                    "pname": "乐器",
                    "disabled": false,
                    "fullname": "150039 吉他"
                },
                {
                    "code": "C150002",
                    "name": "弹拨乐器",
                    "pcode": "1501",
                    "pname": "乐器",
                    "disabled": false,
                    "fullname": "C150002 弹拨乐器"
                },
                {
                    "code": "C150001",
                    "name": "电子琴",
                    "pcode": "1501",
                    "pname": "乐器",
                    "disabled": false,
                    "fullname": "C150001 电子琴"
                },
                {
                    "code": "150025",
                    "name": "乐器",
                    "pcode": "0",
                    "pname": "",
                    "disabled": false,
                    "fullname": "150025 乐器"
                },
                {
                    "code": "150072",
                    "name": "喇叭",
                    "pcode": "1501",
                    "pname": "乐器",
                    "disabled": false,
                    "fullname": "150072 喇叭"
                },
                {
                    "code": "150087",
                    "name": "音乐合成器",
                    "pcode": "1501",
                    "pname": "乐器",
                    "disabled": false,
                    "fullname": "150087 音乐合成器"
                },
                {
                    "code": "150075",
                    "name": "小提琴",
                    "pcode": "1501",
                    "pname": "乐器",
                    "disabled": false,
                    "fullname": "150075 小提琴"
                }
            ]
        },
        {
            "code": "16",
            "name": "办公用品",
            "nclThree": [
                {
                    "code": "160179",
                    "name": "印刷出版物",
                    "pcode": "16",
                    "pname": "",
                    "disabled": false,
                    "fullname": "160179 印刷出版物"
                },
                {
                    "code": "160094",
                    "name": "卫生纸",
                    "pcode": "1603",
                    "pname": "生活用纸",
                    "disabled": false,
                    "fullname": "160094 卫生纸"
                },
                {
                    "code": "160068",
                    "name": "笔记本",
                    "pcode": "1605",
                    "pname": "办公、日用纸制品",
                    "disabled": false,
                    "fullname": "160068 笔记本"
                },
                {
                    "code": "160330",
                    "name": "书籍装订装置和机器（办公设备）",
                    "pcode": "1610",
                    "pname": "办公装订、切削用具",
                    "disabled": false,
                    "fullname": "160330 书籍装订装置和机器（办公设备）"
                },
                {
                    "code": "160209",
                    "name": "文具",
                    "pcode": "1611",
                    "pname": "办公文具（不包括笔，墨，印，胶水）",
                    "disabled": false,
                    "fullname": "160209 文具"
                },
                {
                    "code": "160052",
                    "name": "印章（印）",
                    "pcode": "1613",
                    "pname": "印章，印油",
                    "disabled": false,
                    "fullname": "160052 印章（印）"
                },
                {
                    "code": "160006",
                    "name": "纸",
                    "pcode": "1601",
                    "pname": "工业用纸",
                    "disabled": false,
                    "fullname": "160006 纸"
                },
                {
                    "code": "160130",
                    "name": "包装纸",
                    "pcode": "1609",
                    "pname": "纸及不属别类的塑料包装物品",
                    "disabled": false,
                    "fullname": "160130 包装纸"
                },
                {
                    "code": "160014",
                    "name": "图画",
                    "pcode": "1607",
                    "pname": "照片，图片，图画",
                    "disabled": false,
                    "fullname": "160014 图画"
                },
                {
                    "code": "160142",
                    "name": "墨水",
                    "pcode": "1612",
                    "pname": "墨，砚",
                    "disabled": false,
                    "fullname": "160142 墨水"
                }
            ]
        },
        {
            "code": "17",
            "name": "橡胶制品",
            "nclThree": [
                {
                    "code": "170023",
                    "name": "绝缘、隔热、隔音用材料",
                    "pcode": "1705",
                    "pname": "保温、隔热、隔音材料",
                    "disabled": false,
                    "fullname": "170023 绝缘、隔热、隔音用材料"
                },
                {
                    "code": "170020",
                    "name": "合成橡胶",
                    "pcode": "1701",
                    "pname": "不属别类的橡胶，古塔胶，树胶",
                    "disabled": false,
                    "fullname": "170020 合成橡胶"
                },
                {
                    "code": "170036",
                    "name": "硬橡胶",
                    "pcode": "1703",
                    "pname": "橡胶，树脂，纤维制品",
                    "disabled": false,
                    "fullname": "170036 硬橡胶"
                },
                {
                    "code": "170039",
                    "name": "离合器垫",
                    "pcode": "1702",
                    "pname": "非金属密封减震制品",
                    "disabled": false,
                    "fullname": "170039 离合器垫"
                },
                {
                    "code": "170006",
                    "name": "浇水软管",
                    "pcode": "1704",
                    "pname": "软管",
                    "disabled": false,
                    "fullname": "170006 浇水软管"
                },
                {
                    "code": "170008",
                    "name": "隔音材料",
                    "pcode": "1705",
                    "pname": "保温、隔热、隔音材料",
                    "disabled": false,
                    "fullname": "170008 隔音材料"
                },
                {
                    "code": "C170024",
                    "name": "塑料板",
                    "pcode": "1703",
                    "pname": "橡胶，树脂，纤维制品",
                    "disabled": false,
                    "fullname": "C170024 塑料板"
                },
                {
                    "code": "170022",
                    "name": "非金属软管",
                    "pcode": "1704",
                    "pname": "软管",
                    "disabled": false,
                    "fullname": "170022 非金属软管"
                },
                {
                    "code": "170031",
                    "name": "橡胶绳",
                    "pcode": "1703",
                    "pname": "橡胶，树脂，纤维制品",
                    "disabled": false,
                    "fullname": "170031 橡胶绳"
                },
                {
                    "code": "C170007",
                    "name": "胶壳",
                    "pcode": "1702",
                    "pname": "非金属密封减震制品",
                    "disabled": false,
                    "fullname": "C170007 胶壳"
                }
            ]
        },
        {
            "code": "18",
            "name": "皮革皮具",
            "nclThree": [
                {
                    "code": "180069",
                    "name": "钱包（钱夹）",
                    "pcode": "1802",
                    "pname": "不属别类的皮革、人造皮革制品，箱子及旅行袋，日用革制品",
                    "disabled": false,
                    "fullname": "180069 钱包（钱夹）"
                },
                {
                    "code": "180039",
                    "name": "半加工或未加工皮革",
                    "pcode": "1801",
                    "pname": "皮革和人造皮革，裘皮",
                    "disabled": false,
                    "fullname": "180039 半加工或未加工皮革"
                },
                {
                    "code": "180077",
                    "name": "手提包",
                    "pcode": "1802",
                    "pname": "不属别类的皮革、人造皮革制品，箱子及旅行袋，日用革制品",
                    "disabled": false,
                    "fullname": "180077 手提包"
                },
                {
                    "code": "180058",
                    "name": "背包",
                    "pcode": "1802",
                    "pname": "不属别类的皮革、人造皮革制品，箱子及旅行袋，日用革制品",
                    "disabled": false,
                    "fullname": "180058 背包"
                },
                {
                    "code": "180092",
                    "name": "行李箱",
                    "pcode": "1802",
                    "pname": "不属别类的皮革、人造皮革制品，箱子及旅行袋，日用革制品",
                    "disabled": false,
                    "fullname": "180092 行李箱"
                },
                {
                    "code": "180041",
                    "name": "家具用皮装饰",
                    "pcode": "1802",
                    "pname": "不属别类的皮革、人造皮革制品，箱子及旅行袋，日用革制品",
                    "disabled": false,
                    "fullname": "180041 家具用皮装饰"
                },
                {
                    "code": "180042",
                    "name": "仿皮革",
                    "pcode": "1801",
                    "pname": "皮革和人造皮革，裘皮",
                    "disabled": false,
                    "fullname": "180042 仿皮革"
                },
                {
                    "code": "180123",
                    "name": "婴儿背袋",
                    "pcode": "1802",
                    "pname": "不属别类的皮革、人造皮革制品，箱子及旅行袋，日用革制品",
                    "disabled": false,
                    "fullname": "180123 婴儿背袋"
                },
                {
                    "code": "180002",
                    "name": "动物皮",
                    "pcode": "1801",
                    "pname": "皮革和人造皮革，裘皮",
                    "disabled": false,
                    "fullname": "180002 动物皮"
                },
                {
                    "code": "180063",
                    "name": "软毛皮（仿皮制品）",
                    "pcode": "1801",
                    "pname": "皮革和人造皮革，裘皮",
                    "disabled": false,
                    "fullname": "180063 软毛皮（仿皮制品）"
                }
            ]
        },
        {
            "code": "19",
            "name": "建筑材料",
            "nclThree": [
                {
                    "code": "190061",
                    "name": "非金属建筑物",
                    "pcode": "19",
                    "pname": "",
                    "disabled": false,
                    "fullname": "190061 非金属建筑物"
                },
                {
                    "code": "190069",
                    "name": "非金属门",
                    "pcode": "1909",
                    "pname": "非金属建筑材料及构件（不包括水泥预制构件）",
                    "disabled": false,
                    "fullname": "190069 非金属门"
                },
                {
                    "code": "190024",
                    "name": "混凝土建筑构件",
                    "pcode": "1905",
                    "pname": "水泥预制构件",
                    "disabled": false,
                    "fullname": "190024 混凝土建筑构件"
                },
                {
                    "code": "190086",
                    "name": "非金属支架",
                    "pcode": "1909",
                    "pname": "非金属建筑材料及构件（不包括水泥预制构件）",
                    "disabled": false,
                    "fullname": "190086 非金属支架"
                },
                {
                    "code": "190023",
                    "name": "混凝土",
                    "pcode": "1902",
                    "pname": "土，沙，石，石料，灰泥，炉渣等建筑用料",
                    "disabled": false,
                    "fullname": "190023 混凝土"
                },
                {
                    "code": "190038",
                    "name": "砖",
                    "pcode": "1906",
                    "pname": "建筑砖瓦",
                    "disabled": false,
                    "fullname": "190038 砖"
                },
                {
                    "code": "190017",
                    "name": "沥青",
                    "pcode": "1908",
                    "pname": "柏油，沥青及制品",
                    "disabled": false,
                    "fullname": "190017 沥青"
                },
                {
                    "code": "190102",
                    "name": "石膏（建筑材料）",
                    "pcode": "1903",
                    "pname": "石膏",
                    "disabled": false,
                    "fullname": "190102 石膏（建筑材料）"
                },
                {
                    "code": "190242",
                    "name": "非金属耐火建筑材料",
                    "pcode": "1907",
                    "pname": "非金属耐火材料及制品",
                    "disabled": false,
                    "fullname": "190242 非金属耐火建筑材料"
                },
                {
                    "code": "190027",
                    "name": "木材",
                    "pcode": "1901",
                    "pname": "半成品木材",
                    "disabled": false,
                    "fullname": "190027 木材"
                }
            ]
        },
        {
            "code": "20",
            "name": "家具",
            "nclThree": [
                {
                    "code": "C200022",
                    "name": "未加工或半加工角、牙、介制品",
                    "pcode": "2006",
                    "pname": "未加工或半加工的骨、角、牙、介及不属别类的工艺品",
                    "disabled": false,
                    "fullname": "C200022 未加工或半加工角、牙、介制品"
                },
                {
                    "code": "C200029",
                    "name": "泥塑工艺品",
                    "pcode": "2006",
                    "pname": "未加工或半加工的骨、角、牙、介及不属别类的工艺品",
                    "disabled": false,
                    "fullname": "C200029 泥塑工艺品"
                },
                {
                    "code": "C200014",
                    "name": "竹编制品（不包括帽、席、垫）",
                    "pcode": "2005",
                    "pname": "不属别类的竹、藤、棕、草制品",
                    "disabled": false,
                    "fullname": "C200014 竹编制品（不包括帽、席、垫）"
                },
                {
                    "code": "200003",
                    "name": "食品用塑料装饰品",
                    "pcode": "2008",
                    "pname": "食品用塑料装饰品",
                    "disabled": false,
                    "fullname": "200003 食品用塑料装饰品"
                },
                {
                    "code": "200041",
                    "name": "家具",
                    "pcode": "0",
                    "pname": "",
                    "disabled": false,
                    "fullname": "200041 家具"
                },
                {
                    "code": "200193",
                    "name": "镜子（玻璃镜）",
                    "pcode": "2004",
                    "pname": "镜子、画框及部件",
                    "disabled": false,
                    "fullname": "200193 镜子（玻璃镜）"
                },
                {
                    "code": "200106",
                    "name": "工作台",
                    "pcode": "2003",
                    "pname": "不属别类的工业、建筑配件",
                    "disabled": false,
                    "fullname": "200106 工作台"
                },
                {
                    "code": "C200031",
                    "name": "树脂工艺品",
                    "pcode": "2006",
                    "pname": "未加工或半加工的骨、角、牙、介及不属别类的工艺品",
                    "disabled": false,
                    "fullname": "C200031 树脂工艺品"
                },
                {
                    "code": "200154",
                    "name": "非金属标示牌",
                    "pcode": "2007",
                    "pname": "非金属牌照",
                    "disabled": false,
                    "fullname": "200154 非金属标示牌"
                },
                {
                    "code": "200068",
                    "name": "存储和运输用非金属容器",
                    "pcode": "2002",
                    "pname": "非金属容器及附件",
                    "disabled": false,
                    "fullname": "200068 存储和运输用非金属容器"
                }
            ]
        },
        {
            "code": "21",
            "name": "厨房洁具",
            "nclThree": [
                {
                    "code": "210062",
                    "name": "隔热容器",
                    "pcode": "2111",
                    "pname": "隔热用具",
                    "disabled": false,
                    "fullname": "210062 隔热容器"
                },
                {
                    "code": "210225",
                    "name": "盥洗室器具",
                    "pcode": "2106",
                    "pname": "家庭日用及卫生器具",
                    "disabled": false,
                    "fullname": "210225 盥洗室器具"
                },
                {
                    "code": "C210024",
                    "name": "日用瓷器（包括盆、碗、盘、壶、餐具、缸、坛、罐）",
                    "pcode": "2103",
                    "pname": "瓷器，陶器（茶具，酒具除外）",
                    "disabled": false,
                    "fullname": "C210024 日用瓷器（包括盆、碗、盘、壶、餐具、缸、坛、罐）"
                },
                {
                    "code": "210087",
                    "name": "化妆用具",
                    "pcode": "21",
                    "pname": "",
                    "disabled": false,
                    "fullname": "210087 化妆用具"
                },
                {
                    "code": "210034",
                    "name": "饮用器皿",
                    "pcode": "2105",
                    "pname": "茶具、酒具、咖啡具及饮水用具",
                    "disabled": false,
                    "fullname": "210034 饮用器皿"
                },
                {
                    "code": "210085",
                    "name": "玻璃杯（容器）",
                    "pcode": "2102",
                    "pname": "不属别类的玻璃器皿",
                    "disabled": false,
                    "fullname": "210085 玻璃杯（容器）"
                },
                {
                    "code": "210014",
                    "name": "刷子",
                    "pcode": "2107",
                    "pname": "梳子，刷子（不包括牙刷），制刷原料",
                    "disabled": false,
                    "fullname": "210014 刷子"
                },
                {
                    "code": "210227",
                    "name": "餐具（刀、叉、匙除外）",
                    "pcode": "2101",
                    "pname": "厨房炊事用具及容器（包括不属别类的餐具）",
                    "disabled": false,
                    "fullname": "210227 餐具（刀、叉、匙除外）"
                },
                {
                    "code": "210105",
                    "name": "牙签",
                    "pcode": "2109",
                    "pname": "牙签",
                    "disabled": false,
                    "fullname": "210105 牙签"
                },
                {
                    "code": "210250",
                    "name": "牙刷",
                    "pcode": "2108",
                    "pname": "刷牙用具",
                    "disabled": false,
                    "fullname": "210250 牙刷"
                }
            ]
        },
        {
            "code": "22",
            "name": "绳网袋蓬",
            "nclThree": [
                {
                    "code": "220020",
                    "name": "非金属绳索",
                    "pcode": "2201",
                    "pname": "缆，绳，线，带",
                    "disabled": false,
                    "fullname": "220020 非金属绳索"
                },
                {
                    "code": "220021",
                    "name": "绳索",
                    "pcode": "2201",
                    "pname": "缆，绳，线，带",
                    "disabled": false,
                    "fullname": "220021 绳索"
                },
                {
                    "code": "220075",
                    "name": "运载工具非专用盖罩",
                    "pcode": "2202",
                    "pname": "网，遮篷，帐篷，防水帆布，帆",
                    "disabled": false,
                    "fullname": "220075 运载工具非专用盖罩"
                },
                {
                    "code": "220068",
                    "name": "运输和贮存散装物用麻袋",
                    "pcode": "2203",
                    "pname": "袋子，装卸、包装用物品",
                    "disabled": false,
                    "fullname": "220068 运输和贮存散装物用麻袋"
                },
                {
                    "code": "220049",
                    "name": "网织物",
                    "pcode": "2202",
                    "pname": "网，遮篷，帐篷，防水帆布，帆",
                    "disabled": false,
                    "fullname": "220049 网织物"
                },
                {
                    "code": "220069",
                    "name": "包装用纺织品袋（信封、小袋）",
                    "pcode": "2203",
                    "pname": "袋子，装卸、包装用物品",
                    "disabled": false,
                    "fullname": "220069 包装用纺织品袋（信封、小袋）"
                },
                {
                    "code": "220015",
                    "name": "麻带",
                    "pcode": "2201",
                    "pname": "缆，绳，线，带",
                    "disabled": false,
                    "fullname": "220015 麻带"
                },
                {
                    "code": "220094",
                    "name": "网",
                    "pcode": "2202",
                    "pname": "网，遮篷，帐篷，防水帆布，帆",
                    "disabled": false,
                    "fullname": "220094 网"
                },
                {
                    "code": "220115",
                    "name": "防尘罩布",
                    "pcode": "2202",
                    "pname": "网，遮篷，帐篷，防水帆布，帆",
                    "disabled": false,
                    "fullname": "220115 防尘罩布"
                },
                {
                    "code": "220071",
                    "name": "帐篷",
                    "pcode": "2202",
                    "pname": "网，遮篷，帐篷，防水帆布，帆",
                    "disabled": false,
                    "fullname": "220071 帐篷"
                }
            ]
        },
        {
            "code": "23",
            "name": "纱线丝",
            "nclThree": [
                {
                    "code": "230001",
                    "name": "线",
                    "pcode": "23",
                    "pname": "",
                    "disabled": false,
                    "fullname": "230001 线"
                },
                {
                    "code": "230002",
                    "name": "棉线和棉纱",
                    "pcode": "2302",
                    "pname": "线",
                    "disabled": false,
                    "fullname": "230002 棉线和棉纱"
                },
                {
                    "code": "C230010",
                    "name": "尼龙线",
                    "pcode": "2302",
                    "pname": "线",
                    "disabled": false,
                    "fullname": "C230010 尼龙线"
                },
                {
                    "code": "230013",
                    "name": "亚麻线和纱",
                    "pcode": "2302",
                    "pname": "线",
                    "disabled": false,
                    "fullname": "230013 亚麻线和纱"
                },
                {
                    "code": "230001",
                    "name": "纱",
                    "pcode": "2301",
                    "pname": "纺织用纱、丝",
                    "disabled": false,
                    "fullname": "230001 纱"
                },
                {
                    "code": "C230004",
                    "name": "聚乙烯单丝（纺织用）",
                    "pcode": "2301",
                    "pname": "纺织用纱、丝",
                    "disabled": false,
                    "fullname": "C230004 聚乙烯单丝（纺织用）"
                },
                {
                    "code": "230007",
                    "name": "丝线和纱",
                    "pcode": "2301",
                    "pname": "纺织用纱、丝",
                    "disabled": false,
                    "fullname": "230007 丝线和纱"
                },
                {
                    "code": "C230007",
                    "name": "人造丝",
                    "pcode": "2301",
                    "pname": "纺织用纱、丝",
                    "disabled": false,
                    "fullname": "C230007 人造丝"
                },
                {
                    "code": "230009",
                    "name": "缝纫线和纱",
                    "pcode": "2301",
                    "pname": "纺织用纱、丝",
                    "disabled": false,
                    "fullname": "230009 缝纫线和纱"
                },
                {
                    "code": "230014",
                    "name": "人造线和纱",
                    "pcode": "2301",
                    "pname": "纺织用纱、丝",
                    "disabled": false,
                    "fullname": "230014 人造线和纱"
                }
            ]
        },
        {
            "code": "24",
            "name": "布料床单",
            "nclThree": [
                {
                    "code": "240048",
                    "name": "玻璃布",
                    "pcode": "2402",
                    "pname": "特殊用织物",
                    "disabled": false,
                    "fullname": "240048 玻璃布"
                },
                {
                    "code": "240071",
                    "name": "家庭日用纺织品",
                    "pcode": "2406",
                    "pname": "床上用品",
                    "disabled": false,
                    "fullname": "240071 家庭日用纺织品"
                },
                {
                    "code": "240059",
                    "name": "家具遮盖物",
                    "pcode": "2407",
                    "pname": "室内遮盖物",
                    "disabled": false,
                    "fullname": "240059 家具遮盖物"
                },
                {
                    "code": "240027",
                    "name": "毡",
                    "pcode": "2404",
                    "pname": "毡及毡制品",
                    "disabled": false,
                    "fullname": "240027 毡"
                },
                {
                    "code": "240103",
                    "name": "纺织品制壁挂",
                    "pcode": "2403",
                    "pname": "纺织品壁挂",
                    "disabled": false,
                    "fullname": "240103 纺织品制壁挂"
                },
                {
                    "code": "240079",
                    "name": "蚊帐",
                    "pcode": "2406",
                    "pname": "床上用品",
                    "disabled": false,
                    "fullname": "240079 蚊帐"
                },
                {
                    "code": "240072",
                    "name": "纺织品毛巾",
                    "pcode": "2405",
                    "pname": "毛巾，浴巾，手帕",
                    "disabled": false,
                    "fullname": "240072 纺织品毛巾"
                },
                {
                    "code": "C240025",
                    "name": "手绣、机绣图画",
                    "pcode": "2403",
                    "pname": "纺织品壁挂",
                    "disabled": false,
                    "fullname": "C240025 手绣、机绣图画"
                },
                {
                    "code": "240068",
                    "name": "床单和枕套",
                    "pcode": "2406",
                    "pname": "床上用品",
                    "disabled": false,
                    "fullname": "240068 床单和枕套"
                },
                {
                    "code": "240008",
                    "name": "织物",
                    "pcode": "2401",
                    "pname": "纺织品，布料",
                    "disabled": false,
                    "fullname": "240008 织物"
                }
            ]
        },
        {
            "code": "25",
            "name": "服装鞋帽",
            "nclThree": [
                {
                    "code": "250067",
                    "name": "手套（服装）",
                    "pcode": "2510",
                    "pname": "手套（不包括特种手套）",
                    "disabled": false,
                    "fullname": "250067 手套（服装）"
                },
                {
                    "code": "250126",
                    "name": "游泳衣",
                    "pcode": "2503",
                    "pname": "特种运动服装",
                    "disabled": false,
                    "fullname": "250126 游泳衣"
                },
                {
                    "code": "C250011",
                    "name": "雨衣",
                    "pcode": "2504",
                    "pname": "不透水服装",
                    "disabled": false,
                    "fullname": "C250011 雨衣"
                },
                {
                    "code": "250013",
                    "name": "袜",
                    "pcode": "25",
                    "pname": "",
                    "disabled": false,
                    "fullname": "250013 袜"
                },
                {
                    "code": "C250012",
                    "name": "戏装",
                    "pcode": "25",
                    "pname": "",
                    "disabled": false,
                    "fullname": "C250012 戏装"
                },
                {
                    "code": "250092",
                    "name": "婴儿全套衣",
                    "pcode": "2502",
                    "pname": "婴儿纺织用品",
                    "disabled": false,
                    "fullname": "250092 婴儿全套衣"
                },
                {
                    "code": "250045",
                    "name": "服装",
                    "pcode": "2504",
                    "pname": "不透水服装",
                    "disabled": false,
                    "fullname": "250045 服装"
                },
                {
                    "code": "250003",
                    "name": "鞋（脚上的穿着物）",
                    "pcode": "2507",
                    "pname": "鞋",
                    "disabled": false,
                    "fullname": "250003 鞋（脚上的穿着物）"
                },
                {
                    "code": "250046",
                    "name": "帽",
                    "pcode": "25",
                    "pname": "",
                    "disabled": false,
                    "fullname": "250046 帽"
                },
                {
                    "code": "250149",
                    "name": "体操服",
                    "pcode": "2503",
                    "pname": "特种运动服装",
                    "disabled": false,
                    "fullname": "250149 体操服"
                }
            ]
        },
        {
            "code": "26",
            "name": "纽扣拉链",
            "nclThree": [
                {
                    "code": "260043",
                    "name": "假发",
                    "pcode": "2604",
                    "pname": "假发，假胡须",
                    "disabled": false,
                    "fullname": "260043 假发"
                },
                {
                    "code": "260002",
                    "name": "针",
                    "pcode": "2605",
                    "pname": "缝纫用具（线除外）",
                    "disabled": false,
                    "fullname": "260002 针"
                },
                {
                    "code": "260018",
                    "name": "衣服饰边",
                    "pcode": "2601",
                    "pname": "花边，饰品及编带",
                    "disabled": false,
                    "fullname": "260018 衣服饰边"
                },
                {
                    "code": "260028",
                    "name": "花哨的小商品（绣制品）",
                    "pcode": "2601",
                    "pname": "花边，饰品及编带",
                    "disabled": false,
                    "fullname": "260028 花哨的小商品（绣制品）"
                },
                {
                    "code": "260053",
                    "name": "拉链",
                    "pcode": "2603",
                    "pname": "纽扣，领钩扣，拉链",
                    "disabled": false,
                    "fullname": "260053 拉链"
                },
                {
                    "code": "260064",
                    "name": "衣服装饰品",
                    "pcode": "2602",
                    "pname": "不属别类的服饰品，饰针",
                    "disabled": false,
                    "fullname": "260064 衣服装饰品"
                },
                {
                    "code": "260038",
                    "name": "头发装饰品",
                    "pcode": "2602",
                    "pname": "不属别类的服饰品，饰针",
                    "disabled": false,
                    "fullname": "260038 头发装饰品"
                },
                {
                    "code": "260087",
                    "name": "包用拉链",
                    "pcode": "2603",
                    "pname": "纽扣，领钩扣，拉链",
                    "disabled": false,
                    "fullname": "260087 包用拉链"
                },
                {
                    "code": "260125",
                    "name": "接发片",
                    "pcode": "2604",
                    "pname": "假发，假胡须",
                    "disabled": false,
                    "fullname": "260125 接发片"
                },
                {
                    "code": "260021",
                    "name": "纽扣",
                    "pcode": "2603",
                    "pname": "纽扣，领钩扣，拉链",
                    "disabled": false,
                    "fullname": "260021 纽扣"
                }
            ]
        },
        {
            "code": "27",
            "name": "地毯席垫",
            "nclThree": [
                {
                    "code": "270011",
                    "name": "地毯",
                    "pcode": "2701",
                    "pname": "地毯",
                    "disabled": false,
                    "fullname": "270011 地毯"
                },
                {
                    "code": "270004",
                    "name": "健身用垫",
                    "pcode": "2703",
                    "pname": "垫及其他可移动铺地板用品",
                    "disabled": false,
                    "fullname": "270004 健身用垫"
                },
                {
                    "code": "270021",
                    "name": "榻榻米垫",
                    "pcode": "2703",
                    "pname": "垫及其他可移动铺地板用品",
                    "disabled": false,
                    "fullname": "270021 榻榻米垫"
                },
                {
                    "code": "270006",
                    "name": "垫席",
                    "pcode": "2702",
                    "pname": "席类",
                    "disabled": false,
                    "fullname": "270006 垫席"
                },
                {
                    "code": "270003",
                    "name": "人工草皮",
                    "pcode": "2703",
                    "pname": "垫及其他可移动铺地板用品",
                    "disabled": false,
                    "fullname": "270003 人工草皮"
                },
                {
                    "code": "270016",
                    "name": "乙烯地板覆盖物",
                    "pcode": "2703",
                    "pname": "垫及其他可移动铺地板用品",
                    "disabled": false,
                    "fullname": "270016 乙烯地板覆盖物"
                },
                {
                    "code": "270002",
                    "name": "地板覆盖物",
                    "pcode": "2703",
                    "pname": "垫及其他可移动铺地板用品",
                    "disabled": false,
                    "fullname": "270002 地板覆盖物"
                },
                {
                    "code": "270001",
                    "name": "浴室防滑垫",
                    "pcode": "2703",
                    "pname": "垫及其他可移动铺地板用品",
                    "disabled": false,
                    "fullname": "270001 浴室防滑垫"
                },
                {
                    "code": "C270001",
                    "name": "席",
                    "pcode": "2702",
                    "pname": "席类",
                    "disabled": false,
                    "fullname": "C270001 席"
                },
                {
                    "code": "270010",
                    "name": "汽车用脚垫",
                    "pcode": "2703",
                    "pname": "垫及其他可移动铺地板用品",
                    "disabled": false,
                    "fullname": "270010 汽车用脚垫"
                }
            ]
        },
        {
            "code": "28",
            "name": "健身器材",
            "nclThree": [
                {
                    "code": "C280024",
                    "name": "棋",
                    "pcode": "2803",
                    "pname": "棋，牌及辅助器材",
                    "disabled": false,
                    "fullname": "C280024 棋"
                },
                {
                    "code": "280217",
                    "name": "游戏机控制器",
                    "pcode": "2801",
                    "pname": "娱乐器械，娱乐物品",
                    "disabled": false,
                    "fullname": "280217 游戏机控制器"
                },
                {
                    "code": "C280084",
                    "name": "塑胶跑道",
                    "pcode": "2808",
                    "pname": "游泳池及跑道",
                    "disabled": false,
                    "fullname": "C280084 塑胶跑道"
                },
                {
                    "code": "280044",
                    "name": "锻炼身体器械",
                    "pcode": "2805",
                    "pname": "健身器材",
                    "disabled": false,
                    "fullname": "280044 锻炼身体器械"
                },
                {
                    "code": "280043",
                    "name": "体育活动器械",
                    "pcode": "2807",
                    "pname": "体操、举重、田径、冰雪及属于本类的其他运动器材",
                    "disabled": false,
                    "fullname": "280043 体育活动器械"
                },
                {
                    "code": "280030",
                    "name": "运动用球",
                    "pcode": "2804",
                    "pname": "球类及器材",
                    "disabled": false,
                    "fullname": "280030 运动用球"
                },
                {
                    "code": "280079",
                    "name": "游戏器具",
                    "pcode": "2801",
                    "pname": "娱乐器械，娱乐物品",
                    "disabled": false,
                    "fullname": "280079 游戏器具"
                },
                {
                    "code": "280008",
                    "name": "射箭用器具",
                    "pcode": "2806",
                    "pname": "射箭运动器材",
                    "disabled": false,
                    "fullname": "280008 射箭用器具"
                },
                {
                    "code": "280095",
                    "name": "游泳池（娱乐用品）",
                    "pcode": "2808",
                    "pname": "游泳池及跑道",
                    "disabled": false,
                    "fullname": "280095 游泳池（娱乐用品）"
                },
                {
                    "code": "280024",
                    "name": "玩具",
                    "pcode": "28",
                    "pname": "",
                    "disabled": false,
                    "fullname": "280024 玩具"
                }
            ]
        },
        {
            "code": "29",
            "name": "食品",
            "nclThree": [
                {
                    "code": "290029",
                    "name": "腌制蔬菜",
                    "pcode": "2905",
                    "pname": "腌制、干制蔬菜",
                    "disabled": false,
                    "fullname": "290029 腌制蔬菜"
                },
                {
                    "code": "290086",
                    "name": "蛋",
                    "pcode": "2906",
                    "pname": "蛋品",
                    "disabled": false,
                    "fullname": "290086 蛋"
                },
                {
                    "code": "290047",
                    "name": "鱼（非活）",
                    "pcode": "2902",
                    "pname": "非活水产品",
                    "disabled": false,
                    "fullname": "290047 鱼（非活）"
                },
                {
                    "code": "290160",
                    "name": "以水果为主的零食小吃",
                    "pcode": "2904",
                    "pname": "腌渍、干制水果及制品",
                    "disabled": false,
                    "fullname": "290160 以水果为主的零食小吃"
                },
                {
                    "code": "290147",
                    "name": "肉罐头",
                    "pcode": "2903",
                    "pname": "罐头食品（软包装食品不包括在内，随原料制成品归组）",
                    "disabled": false,
                    "fullname": "290147 肉罐头"
                },
                {
                    "code": "290017",
                    "name": "腌制水果",
                    "pcode": "2904",
                    "pname": "腌渍、干制水果及制品",
                    "disabled": false,
                    "fullname": "290017 腌制水果"
                },
                {
                    "code": "290146",
                    "name": "水果罐头",
                    "pcode": "2903",
                    "pname": "罐头食品（软包装食品不包括在内，随原料制成品归组）",
                    "disabled": false,
                    "fullname": "290146 水果罐头"
                },
                {
                    "code": "290031",
                    "name": "干蔬菜",
                    "pcode": "2905",
                    "pname": "腌制、干制蔬菜",
                    "disabled": false,
                    "fullname": "290031 干蔬菜"
                },
                {
                    "code": "290074",
                    "name": "牛奶制品",
                    "pcode": "2907",
                    "pname": "奶及乳制品",
                    "disabled": false,
                    "fullname": "290074 牛奶制品"
                },
                {
                    "code": "290046",
                    "name": "肉",
                    "pcode": "2901",
                    "pname": "肉，非活的家禽，野味，肉汁",
                    "disabled": false,
                    "fullname": "290046 肉"
                }
            ]
        },
        {
            "code": "30",
            "name": "方便食品",
            "nclThree": [
                {
                    "code": "300069",
                    "name": "糖",
                    "pcode": "3004",
                    "pname": "糖果，南糖，糖",
                    "disabled": false,
                    "fullname": "300069 糖"
                },
                {
                    "code": "300133",
                    "name": "肉馅饼",
                    "pcode": "3007",
                    "pname": "方便食品",
                    "disabled": false,
                    "fullname": "300133 肉馅饼"
                },
                {
                    "code": "300195",
                    "name": "以谷物为主的零食小吃",
                    "pcode": "3010",
                    "pname": "谷物膨化食品",
                    "disabled": false,
                    "fullname": "300195 以谷物为主的零食小吃"
                },
                {
                    "code": "300026",
                    "name": "咖啡",
                    "pcode": "3001",
                    "pname": "咖啡，咖啡代用品，可可",
                    "disabled": false,
                    "fullname": "300026 咖啡"
                },
                {
                    "code": "300034",
                    "name": "谷类制品",
                    "pcode": "3008",
                    "pname": "米，面粉（包括五谷杂粮）",
                    "disabled": false,
                    "fullname": "300034 谷类制品"
                },
                {
                    "code": "300037",
                    "name": "茶",
                    "pcode": "3002",
                    "pname": "茶、茶饮料",
                    "disabled": false,
                    "fullname": "300037 茶"
                },
                {
                    "code": "300196",
                    "name": "以米为主的零食小吃",
                    "pcode": "3006",
                    "pname": "面包，糕点",
                    "disabled": false,
                    "fullname": "300196 以米为主的零食小吃"
                },
                {
                    "code": "300098",
                    "name": "蜂蜜",
                    "pcode": "3005",
                    "pname": "蜂蜜，蜂王浆等营养食品",
                    "disabled": false,
                    "fullname": "300098 蜂蜜"
                },
                {
                    "code": "300103",
                    "name": "面条",
                    "pcode": "3009",
                    "pname": "面条及米面制品",
                    "disabled": false,
                    "fullname": "300103 面条"
                },
                {
                    "code": "300187",
                    "name": "茶饮料",
                    "pcode": "3002",
                    "pname": "茶、茶饮料",
                    "disabled": false,
                    "fullname": "300187 茶饮料"
                }
            ]
        },
        {
            "code": "31",
            "name": "饲料种籽",
            "nclThree": [
                {
                    "code": "310062",
                    "name": "新鲜水果",
                    "pcode": "3105",
                    "pname": "未加工的水果及干果",
                    "disabled": false,
                    "fullname": "310062 新鲜水果"
                },
                {
                    "code": "310004",
                    "name": "未加工的坚果",
                    "pcode": "3105",
                    "pname": "未加工的水果及干果",
                    "disabled": false,
                    "fullname": "310004 未加工的坚果"
                },
                {
                    "code": "310071",
                    "name": "植物",
                    "pcode": "3103",
                    "pname": "花卉，草本植物",
                    "disabled": false,
                    "fullname": "310071 植物"
                },
                {
                    "code": "310008",
                    "name": "树木",
                    "pcode": "3101",
                    "pname": "未加工的林业产品",
                    "disabled": false,
                    "fullname": "310008 树木"
                },
                {
                    "code": "310066",
                    "name": "谷（谷类）",
                    "pcode": "3102",
                    "pname": "未加工的谷物及农产品（不包括蔬菜，种子）",
                    "disabled": false,
                    "fullname": "310066 谷（谷类）"
                },
                {
                    "code": "310005",
                    "name": "供展览用动物",
                    "pcode": "3104",
                    "pname": "活动物",
                    "disabled": false,
                    "fullname": "310005 供展览用动物"
                },
                {
                    "code": "310056",
                    "name": "装饰用干花",
                    "pcode": "3103",
                    "pname": "花卉，草本植物",
                    "disabled": false,
                    "fullname": "310056 装饰用干花"
                },
                {
                    "code": "",
                    "name": "未加工的谷物",
                    "pcode": "3102",
                    "pname": "未加工的谷物及农产品（不包括蔬菜，种子）",
                    "disabled": false,
                    "fullname": "未加工的谷物"
                },
                {
                    "code": "310006",
                    "name": "活动物",
                    "pcode": "31",
                    "pname": "",
                    "disabled": false,
                    "fullname": "310006 活动物"
                },
                {
                    "code": "310017",
                    "name": "未切锯木材",
                    "pcode": "3101",
                    "pname": "未加工的林业产品",
                    "disabled": false,
                    "fullname": "310017 未切锯木材"
                }
            ]
        },
        {
            "code": "32",
            "name": "啤酒饮料",
            "nclThree": [
                {
                    "code": "320006",
                    "name": "无酒精果汁饮料",
                    "pcode": "3202",
                    "pname": "不含酒精饮料",
                    "disabled": false,
                    "fullname": "320006 无酒精果汁饮料"
                },
                {
                    "code": "320022",
                    "name": "蔬菜汁（饮料）",
                    "pcode": "3202",
                    "pname": "不含酒精饮料",
                    "disabled": false,
                    "fullname": "320022 蔬菜汁（饮料）"
                },
                {
                    "code": "320002",
                    "name": "啤酒",
                    "pcode": "32",
                    "pname": "",
                    "disabled": false,
                    "fullname": "320002 啤酒"
                },
                {
                    "code": "320003",
                    "name": "姜汁啤酒",
                    "pcode": "3201",
                    "pname": "啤酒",
                    "disabled": false,
                    "fullname": "320003 姜汁啤酒"
                },
                {
                    "code": "320012",
                    "name": "水（饮料）",
                    "pcode": "3202",
                    "pname": "不含酒精饮料",
                    "disabled": false,
                    "fullname": "320012 水（饮料）"
                },
                {
                    "code": "320043",
                    "name": "无酒精鸡尾酒",
                    "pcode": "3202",
                    "pname": "不含酒精饮料",
                    "disabled": false,
                    "fullname": "320043 无酒精鸡尾酒"
                },
                {
                    "code": "320010",
                    "name": "果汁",
                    "pcode": "3202",
                    "pname": "不含酒精饮料",
                    "disabled": false,
                    "fullname": "320010 果汁"
                },
                {
                    "code": "320052",
                    "name": "以啤酒为主的鸡尾酒",
                    "pcode": "3201",
                    "pname": "啤酒",
                    "disabled": false,
                    "fullname": "320052 以啤酒为主的鸡尾酒"
                },
                {
                    "code": "320058",
                    "name": "软饮料",
                    "pcode": "3202",
                    "pname": "不含酒精饮料",
                    "disabled": false,
                    "fullname": "320058 软饮料"
                },
                {
                    "code": "320031",
                    "name": "无酒精饮料",
                    "pcode": "3202",
                    "pname": "不含酒精饮料",
                    "disabled": false,
                    "fullname": "320031 无酒精饮料"
                }
            ]
        },
        {
            "code": "33",
            "name": "酒",
            "nclThree": [
                {
                    "code": "330018",
                    "name": "烈酒（饮料）",
                    "pcode": "3301",
                    "pname": "含酒精的饮料（啤酒除外）",
                    "disabled": false,
                    "fullname": "330018 烈酒（饮料）"
                },
                {
                    "code": "330019",
                    "name": "白兰地",
                    "pcode": "3301",
                    "pname": "含酒精的饮料（啤酒除外）",
                    "disabled": false,
                    "fullname": "330019 白兰地"
                },
                {
                    "code": "330023",
                    "name": "威士忌",
                    "pcode": "3301",
                    "pname": "含酒精的饮料（啤酒除外）",
                    "disabled": false,
                    "fullname": "330023 威士忌"
                },
                {
                    "code": "330002",
                    "name": "果酒（含酒精）",
                    "pcode": "3301",
                    "pname": "含酒精的饮料（啤酒除外）",
                    "disabled": false,
                    "fullname": "330002 果酒（含酒精）"
                },
                {
                    "code": "330024",
                    "name": "酒精饮料原汁",
                    "pcode": "3301",
                    "pname": "含酒精的饮料（啤酒除外）",
                    "disabled": false,
                    "fullname": "330024 酒精饮料原汁"
                },
                {
                    "code": "330016",
                    "name": "蜂蜜酒",
                    "pcode": "3301",
                    "pname": "含酒精的饮料（啤酒除外）",
                    "disabled": false,
                    "fullname": "330016 蜂蜜酒"
                },
                {
                    "code": "330010",
                    "name": "鸡尾酒",
                    "pcode": "3301",
                    "pname": "含酒精的饮料（啤酒除外）",
                    "disabled": false,
                    "fullname": "330010 鸡尾酒"
                },
                {
                    "code": "330013",
                    "name": "葡萄酒",
                    "pcode": "3301",
                    "pname": "含酒精的饮料（啤酒除外）",
                    "disabled": false,
                    "fullname": "330013 葡萄酒"
                },
                {
                    "code": "330026",
                    "name": "酒精饮料（啤酒除外）",
                    "pcode": "3301",
                    "pname": "含酒精的饮料（啤酒除外）",
                    "disabled": false,
                    "fullname": "330026 酒精饮料（啤酒除外）"
                },
                {
                    "code": "330001",
                    "name": "薄荷酒",
                    "pcode": "3301",
                    "pname": "含酒精的饮料（啤酒除外）",
                    "disabled": false,
                    "fullname": "330001 薄荷酒"
                }
            ]
        },
        {
            "code": "34",
            "name": "烟草烟具",
            "nclThree": [
                {
                    "code": "340036",
                    "name": "烟灰缸",
                    "pcode": "3402",
                    "pname": "烟具",
                    "disabled": false,
                    "fullname": "340036 烟灰缸"
                },
                {
                    "code": "340013",
                    "name": "雪茄",
                    "pcode": "3401",
                    "pname": "烟草及其制品",
                    "disabled": false,
                    "fullname": "340013 雪茄"
                },
                {
                    "code": "C340001",
                    "name": "烟丝",
                    "pcode": "3401",
                    "pname": "烟草及其制品",
                    "disabled": false,
                    "fullname": "C340001 烟丝"
                },
                {
                    "code": "340009",
                    "name": "烟斗",
                    "pcode": "3402",
                    "pname": "烟具",
                    "disabled": false,
                    "fullname": "340009 烟斗"
                },
                {
                    "code": "340014",
                    "name": "雪茄切刀",
                    "pcode": "3402",
                    "pname": "烟具",
                    "disabled": false,
                    "fullname": "340014 雪茄切刀"
                },
                {
                    "code": "340016",
                    "name": "香烟盒",
                    "pcode": "3402",
                    "pname": "烟具",
                    "disabled": false,
                    "fullname": "340016 香烟盒"
                },
                {
                    "code": "340020",
                    "name": "香烟",
                    "pcode": "3401",
                    "pname": "烟草及其制品",
                    "disabled": false,
                    "fullname": "340020 香烟"
                },
                {
                    "code": "340004",
                    "name": "烟袋",
                    "pcode": "3402",
                    "pname": "烟具",
                    "disabled": false,
                    "fullname": "340004 烟袋"
                },
                {
                    "code": "340033",
                    "name": "鼻烟",
                    "pcode": "3401",
                    "pname": "烟草及其制品",
                    "disabled": false,
                    "fullname": "340033 鼻烟"
                },
                {
                    "code": "340041",
                    "name": "吸烟者用口腔雾化器",
                    "pcode": "3402",
                    "pname": "烟具",
                    "disabled": false,
                    "fullname": "340041 吸烟者用口腔雾化器"
                }
            ]
        },
        {
            "code": "35",
            "name": "广告销售",
            "nclThree": [
                {
                    "code": "350096",
                    "name": "特许经营的商业管理",
                    "pcode": "3502",
                    "pname": "工商管理辅助业",
                    "disabled": false,
                    "fullname": "350096 特许经营的商业管理"
                },
                {
                    "code": "350001",
                    "name": "商业管理辅助",
                    "pcode": "3502",
                    "pname": "工商管理辅助业",
                    "disabled": false,
                    "fullname": "350001 商业管理辅助"
                },
                {
                    "code": "350092",
                    "name": "为零售目的在通信媒体上展示商品",
                    "pcode": "3501",
                    "pname": "广告",
                    "disabled": false,
                    "fullname": "350092 为零售目的在通信媒体上展示商品"
                },
                {
                    "code": "350106",
                    "name": "市场营销",
                    "pcode": "3503",
                    "pname": "替他人推销",
                    "disabled": false,
                    "fullname": "350106 市场营销"
                },
                {
                    "code": "350005",
                    "name": "进出口代理",
                    "pcode": "3503",
                    "pname": "替他人推销",
                    "disabled": false,
                    "fullname": "350005 进出口代理"
                },
                {
                    "code": "350071",
                    "name": "替他人推销",
                    "pcode": "35",
                    "pname": "",
                    "disabled": false,
                    "fullname": "350071 替他人推销"
                },
                {
                    "code": "350032",
                    "name": "商业评估",
                    "pcode": "3502",
                    "pname": "工商管理辅助业",
                    "disabled": false,
                    "fullname": "350032 商业评估"
                },
                {
                    "code": "350039",
                    "name": "广告",
                    "pcode": "35",
                    "pname": "",
                    "disabled": false,
                    "fullname": "350039 广告"
                },
                {
                    "code": "350033",
                    "name": "商业调查",
                    "pcode": "3502",
                    "pname": "工商管理辅助业",
                    "disabled": false,
                    "fullname": "350033 商业调查"
                },
                {
                    "code": "350120",
                    "name": "为商品和服务的买卖双方提供在线市场",
                    "pcode": "3503",
                    "pname": "替他人推销",
                    "disabled": false,
                    "fullname": "350120 为商品和服务的买卖双方提供在线市场"
                }
            ]
        },
        {
            "code": "36",
            "name": "金融物管",
            "nclThree": [
                {
                    "code": "360032",
                    "name": "不动产管理",
                    "pcode": "3604",
                    "pname": "不动产事务",
                    "disabled": false,
                    "fullname": "360032 不动产管理"
                },
                {
                    "code": "360052",
                    "name": "艺术品估价",
                    "pcode": "3603",
                    "pname": "珍品估价",
                    "disabled": false,
                    "fullname": "360052 艺术品估价"
                },
                {
                    "code": "C360007",
                    "name": "商品房销售",
                    "pcode": "3604",
                    "pname": "不动产事务",
                    "disabled": false,
                    "fullname": "C360007 商品房销售"
                },
                {
                    "code": "360004",
                    "name": "不动产出租",
                    "pcode": "3604",
                    "pname": "不动产事务",
                    "disabled": false,
                    "fullname": "360004 不动产出租"
                },
                {
                    "code": "360010",
                    "name": "保险经纪",
                    "pcode": "3601",
                    "pname": "保险",
                    "disabled": false,
                    "fullname": "360010 保险经纪"
                },
                {
                    "code": "360024",
                    "name": "金融贷款",
                    "pcode": "3602",
                    "pname": "金融事务",
                    "disabled": false,
                    "fullname": "360024 金融贷款"
                },
                {
                    "code": "360061",
                    "name": "珠宝估价",
                    "pcode": "3603",
                    "pname": "珍品估价",
                    "disabled": false,
                    "fullname": "360061 珠宝估价"
                },
                {
                    "code": "360072",
                    "name": "网上银行",
                    "pcode": "3602",
                    "pname": "金融事务",
                    "disabled": false,
                    "fullname": "360072 网上银行"
                },
                {
                    "code": "360030",
                    "name": "金融管理",
                    "pcode": "3602",
                    "pname": "金融事务",
                    "disabled": false,
                    "fullname": "360030 金融管理"
                },
                {
                    "code": "C360005",
                    "name": "税审服务",
                    "pcode": "3602",
                    "pname": "金融事务",
                    "disabled": false,
                    "fullname": "C360005 税审服务"
                }
            ]
        },
        {
            "code": "37",
            "name": "建筑修理",
            "nclThree": [
                {
                    "code": "370024",
                    "name": "加热设备安装和修理",
                    "pcode": "3705",
                    "pname": "供暖设备的安装与修理",
                    "disabled": false,
                    "fullname": "370024 加热设备安装和修理"
                },
                {
                    "code": "370037",
                    "name": "防锈",
                    "pcode": "3713",
                    "pname": "特殊处理服务",
                    "disabled": false,
                    "fullname": "370037 防锈"
                },
                {
                    "code": "370017",
                    "name": "室内装潢修理",
                    "pcode": "3704",
                    "pname": "建筑物装饰修理服务",
                    "disabled": false,
                    "fullname": "370017 室内装潢修理"
                },
                {
                    "code": "370137",
                    "name": "运载工具电池充电服务",
                    "pcode": "3708",
                    "pname": "飞机维修",
                    "disabled": false,
                    "fullname": "370137 运载工具电池充电服务"
                },
                {
                    "code": "370029",
                    "name": "建筑",
                    "pcode": "3702",
                    "pname": "建筑工程服务",
                    "disabled": false,
                    "fullname": "370029 建筑"
                },
                {
                    "code": "370089",
                    "name": "运载工具故障修理服务",
                    "pcode": "3708",
                    "pname": "飞机维修",
                    "disabled": false,
                    "fullname": "370089 运载工具故障修理服务"
                },
                {
                    "code": "370006",
                    "name": "汽车保养和修理",
                    "pcode": "3707",
                    "pname": "陆地机械车辆维修",
                    "disabled": false,
                    "fullname": "370006 汽车保养和修理"
                },
                {
                    "code": "370051",
                    "name": "钟表修理",
                    "pcode": "37",
                    "pname": "",
                    "disabled": false,
                    "fullname": "370051 钟表修理"
                },
                {
                    "code": "370104",
                    "name": "建筑信息",
                    "pcode": "3701",
                    "pname": "建设、维修信息服务",
                    "disabled": false,
                    "fullname": "370104 建筑信息"
                },
                {
                    "code": "370058",
                    "name": "机械安装、保养和修理",
                    "pcode": "3706",
                    "pname": "机械、电器设备的安装与修理",
                    "disabled": false,
                    "fullname": "370058 机械安装、保养和修理"
                }
            ]
        },
        {
            "code": "38",
            "name": "通讯服务",
            "nclThree": [
                {
                    "code": "380009",
                    "name": "电话业务",
                    "pcode": "3802",
                    "pname": "通信服务",
                    "disabled": false,
                    "fullname": "380009 电话业务"
                },
                {
                    "code": "380044",
                    "name": "提供数据库接入服务",
                    "pcode": "3802",
                    "pname": "通信服务",
                    "disabled": false,
                    "fullname": "380044 提供数据库接入服务"
                },
                {
                    "code": "380003",
                    "name": "无线电广播",
                    "pcode": "3801",
                    "pname": "进行播放无线电或电视节目的服务",
                    "disabled": false,
                    "fullname": "380003 无线电广播"
                },
                {
                    "code": "380005",
                    "name": "电视播放",
                    "pcode": "3801",
                    "pname": "进行播放无线电或电视节目的服务",
                    "disabled": false,
                    "fullname": "380005 电视播放"
                },
                {
                    "code": "380004",
                    "name": "信息传送",
                    "pcode": "3802",
                    "pname": "通信服务",
                    "disabled": false,
                    "fullname": "380004 信息传送"
                },
                {
                    "code": "380012",
                    "name": "新闻社服务",
                    "pcode": "3801",
                    "pname": "进行播放无线电或电视节目的服务",
                    "disabled": false,
                    "fullname": "380012 新闻社服务"
                },
                {
                    "code": "380033",
                    "name": "电信设备出租",
                    "pcode": "3802",
                    "pname": "通信服务",
                    "disabled": false,
                    "fullname": "380033 电信设备出租"
                },
                {
                    "code": "380040",
                    "name": "提供全球计算机网络用户接入服务",
                    "pcode": "3802",
                    "pname": "通信服务",
                    "disabled": false,
                    "fullname": "380040 提供全球计算机网络用户接入服务"
                },
                {
                    "code": "380043",
                    "name": "提供互联网聊天室",
                    "pcode": "3802",
                    "pname": "通信服务",
                    "disabled": false,
                    "fullname": "380043 提供互联网聊天室"
                },
                {
                    "code": "380029",
                    "name": "信息传输设备出租",
                    "pcode": "3802",
                    "pname": "通信服务",
                    "disabled": false,
                    "fullname": "380029 信息传输设备出租"
                }
            ]
        },
        {
            "code": "39",
            "name": "运输贮藏",
            "nclThree": [
                {
                    "code": "390008",
                    "name": "汽车出租",
                    "pcode": "3905",
                    "pname": "其他运输及相关服务",
                    "disabled": false,
                    "fullname": "390008 汽车出租"
                },
                {
                    "code": "390004",
                    "name": "空中运输",
                    "pcode": "39",
                    "pname": "",
                    "disabled": false,
                    "fullname": "390004 空中运输"
                },
                {
                    "code": "390079",
                    "name": "潜水服出租",
                    "pcode": "3907",
                    "pname": "潜水工具出租",
                    "disabled": false,
                    "fullname": "390079 潜水服出租"
                },
                {
                    "code": "390035",
                    "name": "仓库出租",
                    "pcode": "3906",
                    "pname": "货物的贮藏",
                    "disabled": false,
                    "fullname": "390035 仓库出租"
                },
                {
                    "code": "390106",
                    "name": "贵重物品的保护运输",
                    "pcode": "3903",
                    "pname": "陆地运输",
                    "disabled": false,
                    "fullname": "390106 贵重物品的保护运输"
                },
                {
                    "code": "390038",
                    "name": "船运货物",
                    "pcode": "3902",
                    "pname": "水上运输及相关服务",
                    "disabled": false,
                    "fullname": "390038 船运货物"
                },
                {
                    "code": "390048",
                    "name": "运输",
                    "pcode": "3901",
                    "pname": "运输及运输前的包装服务",
                    "disabled": false,
                    "fullname": "390048 运输"
                },
                {
                    "code": "390090",
                    "name": "能源分配",
                    "pcode": "3908",
                    "pname": "供水电气服务",
                    "disabled": false,
                    "fullname": "390090 能源分配"
                },
                {
                    "code": "390028",
                    "name": "货物贮存",
                    "pcode": "3906",
                    "pname": "货物的贮藏",
                    "disabled": false,
                    "fullname": "390028 货物贮存"
                },
                {
                    "code": "390031",
                    "name": "配电",
                    "pcode": "3908",
                    "pname": "供水电气服务",
                    "disabled": false,
                    "fullname": "390031 配电"
                }
            ]
        },
        {
            "code": "40",
            "name": "材料加工",
            "nclThree": [
                {
                    "code": "400109",
                    "name": "净化有害材料",
                    "pcode": "4012",
                    "pname": "污物处理服务",
                    "disabled": false,
                    "fullname": "400109 净化有害材料"
                },
                {
                    "code": "400005",
                    "name": "纺织品精加工",
                    "pcode": "4003",
                    "pname": "纺织品化学处理或加工服务",
                    "disabled": false,
                    "fullname": "400005 纺织品精加工"
                },
                {
                    "code": "400009",
                    "name": "木器制作",
                    "pcode": "4004",
                    "pname": "木材加工服务",
                    "disabled": false,
                    "fullname": "400009 木器制作"
                },
                {
                    "code": "400006",
                    "name": "纸张加工",
                    "pcode": "4005",
                    "pname": "纸张加工服务",
                    "disabled": false,
                    "fullname": "400006 纸张加工"
                },
                {
                    "code": "400111",
                    "name": "印刷",
                    "pcode": "4011",
                    "pname": "影像加工处理服务",
                    "disabled": false,
                    "fullname": "400111 印刷"
                },
                {
                    "code": "400089",
                    "name": "照片冲印",
                    "pcode": "4011",
                    "pname": "影像加工处理服务",
                    "disabled": false,
                    "fullname": "400089 照片冲印"
                },
                {
                    "code": "400091",
                    "name": "油料加工",
                    "pcode": "4008",
                    "pname": "食物、饮料加工服务",
                    "disabled": false,
                    "fullname": "400091 油料加工"
                },
                {
                    "code": "400083",
                    "name": "定做材料装配（替他人）",
                    "pcode": "4001",
                    "pname": "综合加工及提供信息服务",
                    "disabled": false,
                    "fullname": "400083 定做材料装配（替他人）"
                },
                {
                    "code": "400029",
                    "name": "铁器加工",
                    "pcode": "4002",
                    "pname": "金属材料处理或加工服务",
                    "disabled": false,
                    "fullname": "400029 铁器加工"
                },
                {
                    "code": "400012",
                    "name": "服装制作",
                    "pcode": "4010",
                    "pname": "皮革、服装加工服务",
                    "disabled": false,
                    "fullname": "400012 服装制作"
                }
            ]
        },
        {
            "code": "41",
            "name": "教育娱乐",
            "nclThree": [
                {
                    "code": "410035",
                    "name": "提供体育设施",
                    "pcode": "4105",
                    "pname": "文娱、体育活动的服务",
                    "disabled": false,
                    "fullname": "410035 提供体育设施"
                },
                {
                    "code": "410045",
                    "name": "安排和组织会议",
                    "pcode": "4102",
                    "pname": "组织和安排教育、文化、娱乐等活动",
                    "disabled": false,
                    "fullname": "410045 安排和组织会议"
                },
                {
                    "code": "410099",
                    "name": "提供不可下载的在线电子出版物",
                    "pcode": "4104",
                    "pname": "出版服务",
                    "disabled": false,
                    "fullname": "410099 提供不可下载的在线电子出版物"
                },
                {
                    "code": "410076",
                    "name": "安排和组织培训班",
                    "pcode": "4102",
                    "pname": "组织和安排教育、文化、娱乐等活动",
                    "disabled": false,
                    "fullname": "410076 安排和组织培训班"
                },
                {
                    "code": "410010",
                    "name": "组织教育或娱乐竞赛",
                    "pcode": "4102",
                    "pname": "组织和安排教育、文化、娱乐等活动",
                    "disabled": false,
                    "fullname": "410010 组织教育或娱乐竞赛"
                },
                {
                    "code": "410023",
                    "name": "出借书籍的图书馆",
                    "pcode": "4103",
                    "pname": "图书馆服务",
                    "disabled": false,
                    "fullname": "410023 出借书籍的图书馆"
                },
                {
                    "code": "410004",
                    "name": "娱乐服务",
                    "pcode": "4105",
                    "pname": "文娱、体育活动的服务",
                    "disabled": false,
                    "fullname": "410004 娱乐服务"
                },
                {
                    "code": "410017",
                    "name": "教育",
                    "pcode": "41",
                    "pname": "",
                    "disabled": false,
                    "fullname": "410017 教育"
                },
                {
                    "code": "410207",
                    "name": "通过模拟装置进行的培训服务",
                    "pcode": "4101",
                    "pname": "教育",
                    "disabled": false,
                    "fullname": "410207 通过模拟装置进行的培训服务"
                },
                {
                    "code": "410026",
                    "name": "广播和电视节目制作",
                    "pcode": "4105",
                    "pname": "文娱、体育活动的服务",
                    "disabled": false,
                    "fullname": "410026 广播和电视节目制作"
                }
            ]
        },
        {
            "code": "42",
            "name": "网站服务",
            "nclThree": [
                {
                    "code": "420040",
                    "name": "技术研究",
                    "pcode": "4209",
                    "pname": "提供科学技术研究服务",
                    "disabled": false,
                    "fullname": "420040 技术研究"
                },
                {
                    "code": "420007",
                    "name": "化学分析",
                    "pcode": "4211",
                    "pname": "提供化学研究服务",
                    "disabled": false,
                    "fullname": "420007 化学分析"
                },
                {
                    "code": "420237",
                    "name": "室内设计",
                    "pcode": "4217",
                    "pname": "建筑物的设计、咨询服务",
                    "disabled": false,
                    "fullname": "420237 室内设计"
                },
                {
                    "code": "420050",
                    "name": "包装设计",
                    "pcode": "4216",
                    "pname": "外观设计服务",
                    "disabled": false,
                    "fullname": "420050 包装设计"
                },
                {
                    "code": "420076",
                    "name": "气象信息",
                    "pcode": "4213",
                    "pname": "提供气象情报服务",
                    "disabled": false,
                    "fullname": "420076 气象信息"
                },
                {
                    "code": "420193",
                    "name": "测量",
                    "pcode": "4210",
                    "pname": "提供地质调查、研究、开发服务",
                    "disabled": false,
                    "fullname": "420193 测量"
                },
                {
                    "code": "420049",
                    "name": "工业品外观设计",
                    "pcode": "4216",
                    "pname": "外观设计服务",
                    "disabled": false,
                    "fullname": "420049 工业品外观设计"
                },
                {
                    "code": "420195",
                    "name": "车辆性能检测",
                    "pcode": "4214",
                    "pname": "提供测试服务",
                    "disabled": false,
                    "fullname": "420195 车辆性能检测"
                },
                {
                    "code": "420161",
                    "name": "替他人研究和开发新产品",
                    "pcode": "4209",
                    "pname": "提供科学技术研究服务",
                    "disabled": false,
                    "fullname": "420161 替他人研究和开发新产品"
                },
                {
                    "code": "420142",
                    "name": "服装设计",
                    "pcode": "4218",
                    "pname": "服装设计服务",
                    "disabled": false,
                    "fullname": "420142 服装设计"
                }
            ]
        },
        {
            "code": "43",
            "name": "餐饮住宿",
            "nclThree": [
                {
                    "code": "C430003",
                    "name": "茶馆",
                    "pcode": "4301",
                    "pname": "提供餐饮，住宿服务",
                    "disabled": false,
                    "fullname": "C430003 茶馆"
                },
                {
                    "code": "430024",
                    "name": "咖啡馆",
                    "pcode": "4301",
                    "pname": "提供餐饮，住宿服务",
                    "disabled": false,
                    "fullname": "430024 咖啡馆"
                },
                {
                    "code": "430027",
                    "name": "餐厅",
                    "pcode": "4301",
                    "pname": "提供餐饮，住宿服务",
                    "disabled": false,
                    "fullname": "430027 餐厅"
                },
                {
                    "code": "430187",
                    "name": "会议室出租",
                    "pcode": "4302",
                    "pname": "提供房屋设施的服务",
                    "disabled": false,
                    "fullname": "430187 会议室出租"
                },
                {
                    "code": "430073",
                    "name": "饭店",
                    "pcode": "4301",
                    "pname": "提供餐饮，住宿服务",
                    "disabled": false,
                    "fullname": "430073 饭店"
                },
                {
                    "code": "430071",
                    "name": "旅游房屋出租",
                    "pcode": "4302",
                    "pname": "提供房屋设施的服务",
                    "disabled": false,
                    "fullname": "430071 旅游房屋出租"
                },
                {
                    "code": "430138",
                    "name": "酒吧服务",
                    "pcode": "4301",
                    "pname": "提供餐饮，住宿服务",
                    "disabled": false,
                    "fullname": "430138 酒吧服务"
                },
                {
                    "code": "430026",
                    "name": "提供野营场地设施",
                    "pcode": "4302",
                    "pname": "提供房屋设施的服务",
                    "disabled": false,
                    "fullname": "430026 提供野营场地设施"
                },
                {
                    "code": "430200",
                    "name": "私人厨师服务",
                    "pcode": "4301",
                    "pname": "提供餐饮，住宿服务",
                    "disabled": false,
                    "fullname": "430200 私人厨师服务"
                },
                {
                    "code": "430004",
                    "name": "住所代理（旅馆、供膳寄宿处）",
                    "pcode": "4301",
                    "pname": "提供餐饮，住宿服务",
                    "disabled": false,
                    "fullname": "430004 住所代理（旅馆、供膳寄宿处）"
                }
            ]
        },
        {
            "code": "44",
            "name": "医疗园艺",
            "nclThree": [
                {
                    "code": "440009",
                    "name": "动物养殖",
                    "pcode": "4403",
                    "pname": "为动物提供服务",
                    "disabled": false,
                    "fullname": "440009 动物养殖"
                },
                {
                    "code": "440021",
                    "name": "医疗诊所服务",
                    "pcode": "4401",
                    "pname": "医疗服务",
                    "disabled": false,
                    "fullname": "440021 医疗诊所服务"
                },
                {
                    "code": "440032",
                    "name": "医疗按摩",
                    "pcode": "4401",
                    "pname": "医疗服务",
                    "disabled": false,
                    "fullname": "440032 医疗按摩"
                },
                {
                    "code": "440020",
                    "name": "美容服务理发服务",
                    "pcode": "",
                    "pname": "",
                    "disabled": false,
                    "fullname": "440020 美容服务理发服务"
                },
                {
                    "code": "C440001",
                    "name": "饮食营养指导",
                    "pcode": "4401",
                    "pname": "医疗服务",
                    "disabled": false,
                    "fullname": "C440001 饮食营养指导"
                },
                {
                    "code": "440043",
                    "name": "康复中心",
                    "pcode": "4401",
                    "pname": "医疗服务",
                    "disabled": false,
                    "fullname": "440043 康复中心"
                },
                {
                    "code": "440113",
                    "name": "牙科",
                    "pcode": "4401",
                    "pname": "医疗服务",
                    "disabled": false,
                    "fullname": "440113 牙科"
                },
                {
                    "code": "440114",
                    "name": "护理院",
                    "pcode": "4401",
                    "pname": "医疗服务",
                    "disabled": false,
                    "fullname": "440114 护理院"
                },
                {
                    "code": "440147",
                    "name": "老年人护理中心",
                    "pcode": "4401",
                    "pname": "医疗服务",
                    "disabled": false,
                    "fullname": "440147 老年人护理中心"
                },
                null
            ]
        },
        {
            "code": "45",
            "name": "社会服务",
            "nclThree": [
                {
                    "code": "450057",
                    "name": "殡仪",
                    "pcode": "4504",
                    "pname": "殡仪服务",
                    "disabled": false,
                    "fullname": "450057 殡仪"
                },
                {
                    "code": "C450001",
                    "name": "家务服务",
                    "pcode": "4502",
                    "pname": "提供人员服务",
                    "disabled": false,
                    "fullname": "C450001 家务服务"
                },
                {
                    "code": "450218",
                    "name": "在线社交网络服务",
                    "pcode": "4505",
                    "pname": "单一服务",
                    "disabled": false,
                    "fullname": "450218 在线社交网络服务"
                },
                {
                    "code": "450081",
                    "name": "服装出租",
                    "pcode": "4503",
                    "pname": "提供服饰服务",
                    "disabled": false,
                    "fullname": "450081 服装出租"
                },
                {
                    "code": "450227",
                    "name": "个人服装搭配咨询",
                    "pcode": "4503",
                    "pname": "提供服饰服务",
                    "disabled": false,
                    "fullname": "450227 个人服装搭配咨询"
                },
                {
                    "code": "450195",
                    "name": "临时照看婴孩",
                    "pcode": "4502",
                    "pname": "提供人员服务",
                    "disabled": false,
                    "fullname": "450195 临时照看婴孩"
                },
                {
                    "code": "450003",
                    "name": "侦探服务",
                    "pcode": "4501",
                    "pname": "安全服务",
                    "disabled": false,
                    "fullname": "450003 侦探服务"
                },
                {
                    "code": "450001",
                    "name": "私人保镖",
                    "pcode": "4501",
                    "pname": "安全服务",
                    "disabled": false,
                    "fullname": "450001 私人保镖"
                },
                {
                    "code": "450002",
                    "name": "社交陪伴",
                    "pcode": "4502",
                    "pname": "提供人员服务",
                    "disabled": false,
                    "fullname": "450002 社交陪伴"
                },
                {
                    "code": "450099",
                    "name": "警卫服务",
                    "pcode": "4501",
                    "pname": "安全服务",
                    "disabled": false,
                    "fullname": "450099 警卫服务"
                }
            ]
        }
    ],
    "bizmsg": "empty",
    "requestId": "23830ec10c5b49fd8afb974401e86429"
}

```

## **<a name="addUsuallyContacts"> 添加常用联系人、申请人</a>**
[返回到目录](#menu)
##### URL
[/web/opaction/order/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 渠道执行的类型 actionType：addUsuallyContacts

``` javascript
{
    "actionType":"addUsuallyContacts",
    "actionBody":{
        "channel_user_id":"",//Y ic 用户id
        "type":"contact", //Y 联系人 contact  
        "contacts":{
            "contacts": "张三",// Y 联系人
            "mobile": "15010929368",// Y 联系人电话
            "tel":"010-11111",// N 固定电话
            "email": "saa@gongsibao.com",// N 联系人邮箱
            "fax": ""// N 传真
        }
    }
 }

{
     	"actionType":"addUsuallyContacts",
     	"actionBody":{
     		"channel_user_id":"",//Y ic 用户id
     		"type":"applicant",//Y 申请人 applicant
     		"contacts":{
	     		"code": "91310110398635929J",//统一社会信用代码
	            "customerType": "ent",//申请人类型 person个人，ent企业           
	            "identityCardNo": "",//申请人身份证号--（申请类型为个人有此值）    
	            "name": "上海辰者信息科技有限公司",  //申请人名称   
	            "zipCode": "100000"//邮政编码
	            "applyAddr": "上海市杨浦区国定路346号三楼0624室"//执照详细地址 
     		}
     	}
     }

```

####  返回结果
``` javascript
{
    "status": 0,
    "msg": "success",
    "data": null,
    "requestId": "2a3eada5bd6a4e30807bbb2af8c0b4a8"
}

```

## **<a name="delUsuallyContacts"> 删除常用联系人、申请人</a>**
[返回到目录](#menu)
##### URL
[/web/opaction/order/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 渠道执行的类型 actionType：delUsuallyContacts

``` javascript
{
    "actionType":"delUsuallyContacts",
    "actionBody":{
        "id":2
    }
 }
```

####  返回结果
``` javascript
{
    "status": 0,
    "msg": "success",
    "data": null,
    "requestId": "2a3eada5bd6a4e30807bbb2af8c0b4a8"
}

```

## **<a name="updateUsuallyContacts"> 添加常用联系人、申请人</a>**
[返回到目录](#menu)
##### URL
[/web/opaction/order/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 渠道执行的类型 actionType：updateUsuallyContacts

``` javascript
{
    "actionType":"updateUsuallyContacts",
    "actionBody":{
         "id":7,
        "channel_user_id":"19219084323984",
        "contacts":{
            "contacts": "张三23",
            "mobile": "15010929368",
            "tel":"010-222",
            "email": "saa@gongsibao.com",
            "fax": ""
        }
    }
 }

```

####  返回结果
``` javascript
{
    "status": 0,
    "msg": "success",
    "data": null,
    "requestId": "2a3eada5bd6a4e30807bbb2af8c0b4a8"
}

```

## **<a name="getUsuallyContacts"> 获取常用联系人、申请人</a>**
[返回到目录](#menu)
##### URL
[/web/opaction/order/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 渠道执行的类型 actionType：getUsuallyContacts

``` javascript
{
    "actionType":"getUsuallyContacts",
    "actionBody":{
        "channel_user_id":"19219084323984",
        "type":"contact",
        "contact_name":""
    }
}

```

####  返回结果
``` javascript
{
    "status": 0,
    "msg": "操作成功",
    "data": [
        {
            "id": 18,
            "channel_user_id": "5e38f8ef56badb0009165fd1",
            "contact_name": "张三",
            "contacts_content": {
                "fax": "",
                "tel": "010-11111",
                "email": "saa@gongsibao.com",
                "mobile": "15010929368",
                "contacts": "张三"
            },
            "type": "applicant"
        },
        {
            "id": 19,
            "channel_user_id": "5e38f8ef56badb0009165fd1",
            "contact_name": "张三ggg",
            "contacts_content": {
                "fax": "",
                "tel": "010-11111",
                "email": "saa@gongsibao.com",
                "mobile": "15010929368",
                "contacts": "张三ggg"
            },
            "type": "applicant"
        },
        {
            "id": 20,
            "channel_user_id": "5e38f8ef56badb0009165fd1",
            "contact_name": "张三ggg4",
            "contacts_content": {
                "fax": "",
                "tel": "010-11111",
                "email": "saa@gongsibao.com",
                "mobile": "15010929368",
                "contacts": "张三ggg4"
            },
            "type": "applicant"
        },
        {
            "id": 40,
            "channel_user_id": "5e38f8ef56badb0009165fd1",
            "contact_name": "李啥啊",
            "contacts_content": {
                "code": "91310110398635929J",
                "name": "李啥啊",
                "zipCode": "100000",
                "applyAddr": "上海市杨浦区国定路346号三楼0624室003",
                "customerType": "person",
                "identityCardNo": "140311111111111111"
            },
            "type": "applicant"
        },
        {
            "id": 50,
            "channel_user_id": "5e38f8ef56badb0009165fd1",
            "contact_name": "起个名字吧",
            "contacts_content": {
                "code": "91310110398635929J",
                "name": "起个名字吧",
                "zipCode": "100000",
                "applyAddr": "上海市杨浦区国定路346号三楼0624室003",
                "customerType": "person",
                "identityCardNo": "13013399999999999"
            },
            "type": "applicant"
        }
    ],
    "bizmsg": "empty",
    "requestId": "9770a5c5a6da4305b8fc83e296716cf5"
}

```

