let system = require("../../../system")
const http = require("http")
const querystring = require('querystring');
let settings = require("../../../../config/settings");
const CtlBase = require("../../ctl.base");
const logCtl = system.getObject("web.common.oplogCtl");
const tmtransactionPath = "/api/action/tmQuery/springBoard";
let tmurl = settings.channelApiUrl();
//标源检索
class searchCtl extends CtlBase {
    constructor() {
        super("trademark", "trademarkSve");
        this.execClient = system.getObject("util.execClient");
    }

    /**
     * @api {post} /web/trademark/searchCtl/findAndCountAll 检索列表
     * @apiGroup 标源检索
     * @apiParamExample {json} 请求参数
     * {"pageInfo": {"pageNo":1,"pageSize":10}}
     * @apiSuccessExample {json} 成功示例:
     * {"success": ""}
     * @apiErrorExample {json} 失败示例:
     * {"error": ""}
     */
    async findAndCountAll(p, q, req) {
        let query = {
            "actionType": "",
            "actionBody": {
                pageSize: p.pageInfo.pageSize,
                currentPage: p.pageInfo.pageNo,
                "tmName": "",//商标名称
                "regMan": "",
                "regNum": "",
                "sqlbtabkey": "",//商标类别
                "flzttabkey": "",//法律状态
                "sqnftabkey": "",//申请年份
                "ncl": [],//尼斯大类
                "xcl": [],//尼斯群组
                "nclNum": [],//尼斯大类
            }
        };
        let requrl;
        if (Object.keys(p.search).length > 0) {
            if (p.search.sbzch) {//注册号查询
                query.actionType = "findTrademarkzchAccurate";
                requrl = buildtmqueyUrl("/api/trademark/tmqueryApi/findTrademarkzchAccurate");
                query.actionBody.regNum = p.search.sbzch
            } else if (p.search.zcr) {//申请人查询
                query.actionType = "findTrademarkzcr";
                requrl = buildtmqueyUrl(tmurl + "/api/trademark/tmqueryApi/findTrademarkzcr");
                query.actionBody.regMan = p.search.zcr
            } else if (p.search.sbmc) {//商标名称查询
                query.actionType = "findTrademarkNameAccurate";
                requrl = buildtmqueyUrl("/api/trademark/tmqueryApi/findTrademarkNameAccurate");
                query.actionBody.tmName = p.search.sbmc
            }
        } else {
            return system.getResultFail(-1,"query params is empty");
        }
        let token = "";
        if (settings.env == "dev"){
        let tokenInfo = await this.service.getToken();
            token = tokenInfo.data.token
        } else {
           query = query.actionBody
        }
        try {
            let rtn = await this.execClient.execPostTK(query, requrl, token);
            let data = rtn.data;
            let published = await this.service.findAll({ company_id: p.company_id });
            data.rows.forEach(item => {
                for (let t of published) {
                    if (t.tm_code == item.sbzch)
                        item._disabled = true;
                }
            });
            return system.getResultList(data.count, data.rows)
        } catch (e) {
            return system.getResultFail(-1,e);
        }

    }
}
function buildtmqueyUrl(path){
    if (settings.env == "dev") {
       return tmurl + tmtransactionPath
    }else {
       return tmurl + path
    }
}
module.exports = searchCtl;

