let system = require("../../../system")
let settings = require("../../../../config/settings");
const trademarkCtl = require("./trademarkCtl.js");
const tmtransactionPath = "/tmtransaction/action/trademarktransaction/springBoard";
const tmurl = settings.tmtransactionurl() + tmtransactionPath;

//全部标源管理
class UploadinfoCtl extends trademarkCtl {
    constructor() {
        super();
    }

    /**
     * @api {post} /web/trademark/uploadinfoCtl/findAndCountAll 获取上传的列表
     * @apiGroup 标源管理
     * @apiParamExample {json} 请求参数
     * {"pageInfo": {"pageNo":1,"pageSize":10}}
     * @apiSuccessExample {json} 成功示例:
     * {"status":0,"msg":""data":{"results":{"rows":[]}}}
     * @apiErrorExample {json} 失败示例:
     * {"error": ""}
     */
    async findAndCountAll(p, q, req) {
        let query = {
            "actionType": "tmInfo",
            "actionBody": {}
        };
        p.search.trademark_id ={$and:[{$not:null},{$not:""}]};
        let list = await  this.service.findAndCountAll(p);
        query.actionBody.tmList = list.results.rows.map(d => {
            if (d.trademark_id) {
                return d.trademark_id
            }
        });
        let rtn = await this.execClient.execPost(query, tmurl);
        let data = JSON.parse(rtn.stdout);
        return system.getResultList(list.results.count, data.data || [])
    }
}

module.exports = UploadinfoCtl;

