var system = require("../../../system");
const http = require("http");
const querystring = require('querystring');
var settings = require("../../../../config/settings");
const CtlBase = require("../../ctl.base");
const moment = require('moment');
const appconfig = system.getSysConfig();
class SchemeCtl extends CtlBase {
  constructor() {
    super("bizchance", CtlBase.getServiceName(SchemeCtl));
    this.bizoptService = system.getObject("service.bizchance.bizoptSve");
    this.logService = system.getObject("service.bizchance.statuslogSve");
    this.receiveUrl = settings.receiveUrl();
    //this.queueUrl = settings.queueUrl();
    //this.wdyUrl = settings.wdyUrl();
  }

  /*根据id获取方案信息详情*/
  async findById(mobj, qobj, req) {
    var pobj = mobj.d;
    if (pobj.id && pobj.id != 'undefined'){
        try{
            var rs = await this.service.findById(pobj);
            var rarr = {}
            if (rs){
                rarr.businessMode = rs.demand_code;//商机编号
                rarr.schemeNumber = rs.scheme_number;//方案编号
                rarr.businessType = "";//商机类型
                rarr.businessName = "";//商机名称
                var bizoptInfo = await this.bizoptService.findInfoByDemandCode({"businessMode":rarr.businessMode});
                if (bizoptInfo){
                    rarr.businessType = bizoptInfo.business_type;
                    rarr.businessName = appconfig.pdict.businessType[rarr.businessType];//商机类型名称
                }
               // rarr.planInfo = rs.scheme_info;//方案详情
                rarr.memoInfo = rs.remark_info;//备注信息
                rarr.currentStatus = rs.scheme_status;//当前状态
                rarr.statusReason = rs.reject_reason;//状态原因
                rarr.businessId = rs.bizopt_id;//商机id
                rarr.servicerCode = rs.facilitator_id;//服务商id
                rarr.servicerName = rs.facilitator_name;//服务商名称
                rarr.clerkName = rs.salesman_name;//业务员名称
                rarr.clerkPhone = rs.salesman_phone;//业务员联系方式
                rarr.createdTime =  this.timeFormat(rs.created_at);//创建方案的日期
                rarr.statusTime = this.timeFormat(rs.updated_at);//当前状态的日期
                var baseInfo = {};
                if (rs.scheme_info.companyName && rs.scheme_info.companyName != 'undefined'){//公司名称
                    rarr.companyName = rs.scheme_info.companyName;
                }
                if (rarr.businessName == "公司注册" || rarr.businessName == "园区注册" 
                    || rarr.businessName == "税控申请" || rarr.businessName == "代理记账"){
                    baseInfo.taxpayerType = rs.scheme_info.taxpayerType;
                }
                if (rarr.businessName == "园区注册"){
                    baseInfo.registeredType = rs.scheme_info.registeredType;
                }
                if (rarr.businessName == "公司注册" || rarr.businessName == "园区注册"){
                    baseInfo.companyProperties  = rs.scheme_info.companyProperties;
                    baseInfo.engagedIndustry = rs.scheme_info.engagedIndustry;
                    baseInfo.addressType = rs.scheme_info.addressType;
                    baseInfo.fullAddress = rs.scheme_info.fullAddress;
                    baseInfo.businessScope = rs.scheme_info.businessScope;
                    baseInfo.isWhether = rs.scheme_info.isWhether;
                }
                if (rarr.businessName == "刻章服务"){
                    baseInfo.whetherType = rs.scheme_info.whetherType;
                }
                if (rarr.businessName == "代理记账"){
                    baseInfo.subjectType = rs.scheme_info.subjectType;
                }
                if (rarr.businessName == "注册地址" || rarr.businessName == "代理记账"){
                    baseInfo.buyTime = rs.scheme_info.buyTime;
                    baseInfo.buyDuration = rs.scheme_info.buyDuration;
                    baseInfo.isRenew = rs.scheme_info.isRenew;
                }
                rarr.baseInfo = baseInfo;
                if (rarr.businessName != "公司注册" && rarr.businessName != "园区注册"){
                    var companyInfo = {};
                    companyInfo.creditCode = rs.scheme_info.creditCode;
                    companyInfo.companyType = rs.scheme_info.companyType;
                    companyInfo.establishedTime = rs.scheme_info.establishedTime;
                    companyInfo.registeredCapital =rs.scheme_info.registeredCapital;
                    companyInfo.shareholderName = rs.scheme_info.shareholderName;
                    companyInfo.businessTerm = rs.scheme_info.businessTerm;
                    companyInfo.businessScope = rs.scheme_info.businessScope;
                    companyInfo.residenceAddress = rs.scheme_info.residenceAddress;
                    rarr.companyInfo = companyInfo;
                }
            }
            return system.getResult(rarr);
        }
        catch(error){
            return system.getResultError(error);
        }
    }
    else{
        return system.getResultError("参数错误！");
    }
  }

  /*根据商机编号获取方案详情*/
  async findInfoByDemandCode(mobj, qobj, req){
    var pobj = mobj.d;
    if (pobj.businessMode && pobj.businessMode != 'undefined'){
        try{
            var rs = await this.service.findInfoByDemandCode(pobj);
            var rarr = {}
            if (rs){
                rarr.businessMode = rs.demand_code;//商机编号
                rarr.schemeNumber = rs.scheme_number;//方案编号
                rarr.businessType = "";//商机类型
                rarr.businessName = "";//商机名称
                var bizoptInfo = await this.bizoptService.findInfoByDemandCode({"businessMode":rarr.businessMode});
                if (bizoptInfo){
                    rarr.businessType = bizoptInfo.business_type;
                    rarr.businessName = appconfig.pdict.businessType[rarr.businessType];//商机类型名称
                }
                //rarr.planInfo = rs.scheme_info;//方案详情
                rarr.memoInfo = rs.remark_info;//备注信息
                rarr.currentStatus = rs.scheme_status;//当前状态
                rarr.statusReason = rs.reject_reason;//状态原因
                rarr.businessId = rs.bizopt_id;//商机id
                rarr.servicerCode = rs.facilitator_id;//服务商id
                rarr.servicerName = rs.facilitator_name;//服务商名称
                rarr.clerkId = rs.salesman_id;//业务员id;
                rarr.clerkName = rs.salesman_name;//业务员名称
                rarr.clerkPhone = rs.salesman_phone;//业务员联系方式
                rarr.createdTime =  this.timeFormat(rs.created_at);//创建方案的日期
                rarr.statusTime = this.timeFormat(rs.updated_at);//当前状态的日期
                rarr.baseInfo = rs.scheme_info;
            }
            return system.getResult(rarr);
        }
        catch(error){
            return system.getResultError(error);
        }
    }
    else{
        return system.getResultError("参数错误！");
    }
  }

  /* 根据商机编号更新方案状态及原因 */
  async updateStatusByDemandCode(mobj, qobj, req){
    var pobj = mobj.d;
    if (pobj.businessMode && pobj.businessMode != 'undefined' && pobj.currentStatus && pobj.currentStatus != 'undefined'){
        try{
            await this.service.updateStatusByDemandCode(pobj);
            var res= await this.service.findInfoByDemandCode(pobj);
            if (res){
                var logInfo = {
                    "flowType":"SCHEME",
                    "flowId":res.id,
                    "statusCode":res.scheme_status,
                    "statusReason":res.reject_reason,
                    "clerkName":res.salesman_name,
                    "clerkId":res.salesman_id
                  }
                  await this.logService.insertInfo(logInfo);//插入状态日至表
        
            }
            if (pobj.currentStatus == "isReject"){
                var parms ={
                    "businessMode": pobj.businessMode,
                    "currentStatus": "beforeSubmission"
                }
                await this.bizoptService.updateStatusByDemandCode(parms);//把商机状态修改为待提交方案

            }
            return system.getResult("更新成功！");
        }
        catch(error){
            return system.getResultError(error);
        }
    }
    else{
        return system.getResultError("参数错误！");
    }
  }

  /*根据商机编号更新方案详情*/
  async updateInfoByDemandCode(mobj, qobj, req){
    var pobj = mobj.d;
    console.log("------------------------------修改方案------------------------------------");
    console.log(JSON.stringify(pobj));
    console.log("------------------------------修改方案------------------------------------");
    if (pobj.businessMode && pobj.businessMode != 'undefined' && pobj.schemeNumber && pobj.schemeNumber != 'undefined' && pobj.baseInfo && pobj.baseInfo != 'undefined'){
        try{
            pobj.currentStatus = "beforeConfirmation";//同时把方案的状态也更新为待确认
            pobj.statusReason = "   ";
            var businessInfo = await this.bizoptService.findInfoByDemandCode(pobj);//得到商机的信息，插入方案表时要用到
            if (businessInfo){
                pobj.businessId = businessInfo.id;//商机id
                pobj.businessType = businessInfo.business_type;//商机类型
                pobj.servicerCode = businessInfo.facilitator_id;//服务商id
                pobj.servicerName = businessInfo.facilitator_name;//服务商的名称
                pobj.clerkOpcode = businessInfo.salesman_opcode;//这个信息需要确认
                pobj.clerkId = businessInfo.salesman_id;//业务员id
                pobj.clerkName = businessInfo.salesman_name;//业务员名称
                pobj.clerkPhone = businessInfo.salesman_phone;//业务员联系电话
                //pobj.currentStatus = appconfig.pdict.businessStatus[businessInfo.business_status];//商机状态即为方案状态
                //pobj.statusReason = businessInfo.close_reason;//状态原因
            }

            if (pobj.baseInfo.caseRemarks && pobj.baseInfo.caseRemarks != 'undefined'){
                pobj.baseInfo.memoInfo = pobj.baseInfo.caseRemarks;//备注信息
            }
            if (pobj.baseInfo.cmpName && pobj.baseInfo.cmpName != 'undefined'){
                pobj.baseInfo.companyName = pobj.baseInfo.cmpName;//公司名称
            }
            //是否刻章
            if (pobj.baseInfo.cmpSealSevCase && pobj.baseInfo.cmpSealSevCase != 'undefined'){
                pobj.baseInfo.isWhether = pobj.baseInfo.cmpSealSevCase;
            }
            if (pobj.baseInfo.psSealSevCase && pobj.baseInfo.psSealSevCase != 'undefined'){
                pobj.baseInfo.isWhether = pobj.baseInfo.psSealSevCase
            }


            //纳税人类型
            if (pobj.baseInfo.psTaxpayerType && pobj.baseInfo.psTaxpayerType != 'undefined'){
                pobj.baseInfo.taxpayerType = pobj.baseInfo.psTaxpayerType;
            }
            if (pobj.baseInfo.cmpTaxPayerType && pobj.baseInfo.cmpTaxPayerType != 'undefined'){
                pobj.baseInfo.taxpayerType = pobj.baseInfo.cmpTaxPayerType;
            }
            if (pobj.baseInfo.agentTaxpayerType && pobj.baseInfo.agentTaxpayerType != 'undefined'){
                pobj.baseInfo.taxpayerType = pobj.baseInfo.agentTaxpayerType;
            }
            //详细地址
            if (pobj.baseInfo.addressTypeInput && pobj.baseInfo.addressTypeInput != 'undefined'){
                pobj.baseInfo.residenceAddress = pobj.baseInfo.addressTypeInput;
            }           

            if (pobj.baseInfo.addressType && pobj.baseInfo.addressType != 'undefined'){//地址类型
                pobj.baseInfo.addressTypeName = appconfig.pdict.addressTypeDict[pobj.baseInfo.addressType];//地址类型名称
            }
            if (pobj.baseInfo.taxpayerType && pobj.baseInfo.taxpayerType != 'undefined'){
                pobj.baseInfo.taxpayerName = appconfig.pdict.TaxpayerTypeDict[pobj.baseInfo.taxpayerType];//纳税人名称
            }
            if (pobj.baseInfo.registeredType && pobj.baseInfo.registeredType != 'undefined'){
                pobj.baseInfo.registeredName = appconfig.pdict.registeredTypeDict[pobj.baseInfo.registeredType];//云上园区名称
            }
            if (pobj.baseInfo.agentType && pobj.baseInfo.agentType != 'undefined'){
                pobj.baseInfo.agentName = appconfig.pdict.agentTypeDict[pobj.baseInfo.agentType];//代理记账主体名称
                if (pobj.baseInfo.serviceArea && pobj.baseInfo.serviceArea != 'undefined'){
                    if (pobj.baseInfo.agentType == "company"){
                        pobj.baseInfo.serviceAreaName = appconfig.pdict.registeredAreaDict[pobj.baseInfo.serviceArea];//注册地区
                    }
                    else{
                        pobj.baseInfo.serviceAreaName = appconfig.pdict.registeredParkDict[pobj.baseInfo.serviceArea];//注册地区
                    }
                }

            }
            if (pobj.businessType == "companyCase"){
                if (pobj.baseInfo.companynature && pobj.baseInfo.companynature != 'undefined'){
                    pobj.baseInfo.companyType = appconfig.pdict.companyNatureDict[pobj.baseInfo.companynature];//公司类型的名称
                }
                //注册地区
                if (pobj.baseInfo.serviceArea && pobj.baseInfo.serviceArea != 'undefined'){
                    pobj.baseInfo.serviceAreaName = appconfig.pdict.registeredAreaDict[pobj.baseInfo.serviceArea];//注册地区
                }
            }
            else if (pobj.businessType == "psCase"){
                //注册地区
                if (pobj.baseInfo.serviceArea && pobj.baseInfo.serviceArea != 'undefined'){
                    pobj.baseInfo.serviceAreaName = appconfig.pdict.registeredParkDict[pobj.baseInfo.serviceArea];//注册地区
                }
            }
            else{
                 //注册地区
                if (pobj.baseInfo.serviceArea && pobj.baseInfo.serviceArea != 'undefined'){
                    pobj.baseInfo.serviceAreaName = appconfig.pdict.registeredAreaDict[pobj.baseInfo.serviceArea];//注册地区
                }
            }

            //goumaisichang
            // if (pobj.baseInfo.buyDuration && pobj.baseInfo.buyDuration != 'undefined'){
            //     pobj.baseInfo.buyDuration = appconfig.pdict.buyDurationDict[pobj.baseInfo.buyDuration];
            // }

            if (pobj.baseInfo.hasOwnProperty("isRenew")){
                pobj.baseInfo.isRenew = appconfig.pdict.isRenewDict[pobj.baseInfo.isRenew];
            }
            else{
                pobj.baseInfo.isRenew = "不开启"
            }
            if (pobj.baseInfo.engagedIndustry && pobj.baseInfo.engagedIndustry != 'undefined'){
                pobj.baseInfo.engagedIndName = appconfig.pdict.engagedIndustryDict[pobj.baseInfo.engagedIndustry];//从事行业名称
            }
            if (pobj.baseInfo.sealSevType && pobj.baseInfo.sealSevType != 'undefined'){
                pobj.baseInfo.sealSevName = appconfig.pdict.sealSevTypeDict[pobj.baseInfo.sealSevType];//刻章类型名称名称
                if (pobj.baseInfo.serviceArea && pobj.baseInfo.serviceArea != 'undefined'){
                    if (pobj.baseInfo.sealSevType == "company"){
                        pobj.baseInfo.serviceAreaName = appconfig.pdict.registeredAreaDict[pobj.baseInfo.serviceArea];//注册地区
                    }
                    else{
                        pobj.baseInfo.serviceAreaName = appconfig.pdict.registeredParkDict[pobj.baseInfo.serviceArea];//注册地区
                    }
                }
            }
            
            //修改方案的时候，需要把修改的方案传给商城
            var ttype  = pobj.businessType;
            console.log("ttype:" + ttype);
            pobj.businessType = appconfig.pdict.fdyDict[pobj.businessType];
            console.log("businessType:" + pobj.businessType);
            var rc = system.getObject("util.execClient");
            var requrl = this.receiveUrl;
            var params =  {
                "actionType":"submitSolution",
                "actionBody":{
                    "needNum": pobj.businessMode,
                    "solutionNum":pobj.schemeNumber,
                    "solutionContent": pobj
                }
            }  
            console.log(JSON.stringify(params) + "HHHHHHHHHHHHHHHHHHHHHH"); 
            var rtn = await rc.execPost(params, requrl);
            var j = JSON.parse(rtn.stdout);
            console.log(JSON.stringify(j) + "IIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIII"); 
            if (j.status == 1){
                pobj.businessType = ttype;
                //pobj.schemeNumber = j.data;
                await this.service.updateInfoByDemandCode(pobj);//更新方案详情,同时更新新的方案编号
                var bobj = {"businessMode":pobj.businessMode,"currentStatus":"beforeConfirmation"};//同时把商机状态更新回待确认
                await this.bizoptService.updateStatusByDemandCode(bobj);
                return system.getResult("更新成功！");     
            }
            else{
                return system.getResultError("更新方案出错！");
            }
        }
        catch(error){
            console.log("EEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEE" + error);
            return system.getResultError(error);
        }
    }
    else{
        console.log("CCCCCCCCCCCCCCCCCCCCCCC参数错误！");
        return system.getResultError("参数错误！");
    }
  }

  /*根据商机编号更新方案编号*/
  async updateSchemeNumberByDemandCode(mobj, qobj, req){
    var pobj = mobj.d;
    if (pobj.schemeNumber && pobj.schemeNumber != 'undefined' && pobj.businessMode && pobj.businessMode != 'undefined'){
        try{
            await this.service.updateSchemeNumberByDemandCode(pobj);
            return system.getResult("更新成功！");
        }
        catch(error){
            return system.getResultError(error);
        }
    }
    else{
        return system.getResultError("参数错误！");
    }
  }

  /*插入方案信息*/
  async insertInfo(mobj, qobj, req){
    var pobj = mobj.d;
    console.log("22222222222222222" + JSON.stringify(pobj));
    if (pobj.businessMode && pobj.businessMode != 'undefined' && pobj.baseInfo && pobj.baseInfo != 'undefined'){//商机编号必须存在
        try{
            pobj.currentStatus = "beforeConfirmation";//商机状态为待用户确认
            var businessInfo = await this.bizoptService.findInfoByDemandCode(pobj);//得到商机的信息，插入方案表时要用到
            if (businessInfo){
                pobj.businessId = businessInfo.id;//商机id
                pobj.businessType = businessInfo.business_type;//商机类型
                pobj.servicerCode = businessInfo.facilitator_id;//服务商id
                pobj.servicerName = businessInfo.facilitator_name;//服务商的名称
                pobj.clerkOpcode = businessInfo.salesman_opcode;//这个信息需要确认
                pobj.clerkId = businessInfo.salesman_id;//业务员id
                pobj.clerkName = businessInfo.salesman_name;//业务员名称
                pobj.clerkPhone = businessInfo.salesman_phone;//业务员联系电话
                //pobj.baseInfo.userName = businessInfo.business_info.userName;//
                //pobj.currentStatus = appconfig.pdict.businessStatus[businessInfo.business_status];//商机状态即为方案状态
                //pobj.statusReason = businessInfo.close_reason;//状态原因
            }

            if (pobj.baseInfo.caseRemarks && pobj.baseInfo.caseRemarks != 'undefined'){
                pobj.baseInfo.memoInfo = pobj.baseInfo.caseRemarks;//备注信息
            }
            if (pobj.baseInfo.cmpName && pobj.baseInfo.cmpName != 'undefined'){
                pobj.baseInfo.companyName = pobj.baseInfo.cmpName;//公司名称
            }
            //是否刻章
            if (pobj.baseInfo.cmpSealSevCase && pobj.baseInfo.cmpSealSevCase != 'undefined'){
                pobj.baseInfo.isWhether = pobj.baseInfo.cmpSealSevCase;
            }
            if (pobj.baseInfo.psSealSevCase && pobj.baseInfo.psSealSevCase != 'undefined'){
                pobj.baseInfo.isWhether = pobj.baseInfo.psSealSevCase
            }
            //纳税人类型
            if (pobj.baseInfo.psTaxpayerType && pobj.baseInfo.psTaxpayerType != 'undefined'){
                pobj.baseInfo.taxpayerType = pobj.baseInfo.psTaxpayerType;
            }
            if (pobj.baseInfo.cmpTaxPayerType && pobj.baseInfo.cmpTaxPayerType != 'undefined'){
                pobj.baseInfo.taxpayerType = pobj.baseInfo.cmpTaxPayerType;
            }
            if (pobj.baseInfo.agentTaxpayerType && pobj.baseInfo.agentTaxpayerType != 'undefined'){
                pobj.baseInfo.taxpayerType = pobj.baseInfo.agentTaxpayerType;
            }
            //详细地址
            if (pobj.baseInfo.addressTypeInput && pobj.baseInfo.addressTypeInput != 'undefined'){
                pobj.baseInfo.residenceAddress = pobj.baseInfo.addressTypeInput;
            }           

            if (pobj.baseInfo.addressType && pobj.baseInfo.addressType != 'undefined'){//地址类型
                pobj.baseInfo.addressTypeName = appconfig.pdict.addressTypeDict[pobj.baseInfo.addressType];//地址类型名称
            }
            if (pobj.baseInfo.taxpayerType && pobj.baseInfo.taxpayerType != 'undefined'){
                pobj.baseInfo.taxpayerName = appconfig.pdict.TaxpayerTypeDict[pobj.baseInfo.taxpayerType];//纳税人名称
            }
            if (pobj.baseInfo.registeredType && pobj.baseInfo.registeredType != 'undefined'){
                pobj.baseInfo.registeredName = appconfig.pdict.registeredTypeDict[pobj.baseInfo.registeredType];//云上园区名称
            }
            if (pobj.baseInfo.agentType && pobj.baseInfo.agentType != 'undefined'){
                pobj.baseInfo.agentName = appconfig.pdict.agentTypeDict[pobj.baseInfo.agentType];//代理记账主体名称
                if (pobj.baseInfo.serviceArea && pobj.baseInfo.serviceArea != 'undefined'){
                    if (pobj.baseInfo.agentType == "company"){
                        pobj.baseInfo.serviceAreaName = appconfig.pdict.registeredAreaDict[pobj.baseInfo.serviceArea];//注册地区
                    }
                    else{
                        pobj.baseInfo.serviceAreaName = appconfig.pdict.registeredParkDict[pobj.baseInfo.serviceArea];//注册地区
                    }
                }

            }
            if (pobj.businessType == "companyCase"){
                if (pobj.baseInfo.companynature && pobj.baseInfo.companynature != 'undefined'){
                    pobj.baseInfo.companyType = appconfig.pdict.companyNatureDict[pobj.baseInfo.companynature];//公司类型的名称
                }
                //注册地区
                if (pobj.baseInfo.serviceArea && pobj.baseInfo.serviceArea != 'undefined'){
                    pobj.baseInfo.serviceAreaName = appconfig.pdict.registeredAreaDict[pobj.baseInfo.serviceArea];//注册地区
                }
            }
            else if (pobj.businessType == "psCase"){
                //注册地区
                if (pobj.baseInfo.serviceArea && pobj.baseInfo.serviceArea != 'undefined'){
                    pobj.baseInfo.serviceAreaName = appconfig.pdict.registeredParkDict[pobj.baseInfo.serviceArea];//注册地区
                }
            }
            else{
                 //注册地区
                if (pobj.baseInfo.serviceArea && pobj.baseInfo.serviceArea != 'undefined'){
                    pobj.baseInfo.serviceAreaName = appconfig.pdict.registeredAreaDict[pobj.baseInfo.serviceArea];//注册地区
                }
            }

            //goumaisichang
            if (pobj.baseInfo.buyDuration && pobj.baseInfo.buyDuration != 'undefined'){
                pobj.baseInfo.buyDuration = appconfig.pdict.buyDurationDict[pobj.baseInfo.buyDuration];
            }
            if (pobj.baseInfo.isRenew && pobj.baseInfo.isRenew != 'undefined' ){
                pobj.baseInfo.isRenew = appconfig.pdict.isRenewDict[pobj.baseInfo.isRenew];
            }

            if (pobj.baseInfo.engagedIndustry && pobj.baseInfo.engagedIndustry != 'undefined'){
                pobj.baseInfo.engagedIndName = appconfig.pdict.engagedIndustryDict[pobj.baseInfo.engagedIndustry];//从事行业名称
            }
            if (pobj.baseInfo.sealSevType && pobj.baseInfo.sealSevType != 'undefined'){
                pobj.baseInfo.sealSevName = appconfig.pdict.sealSevTypeDict[pobj.baseInfo.sealSevType];//刻章类型名称名称
                if (pobj.baseInfo.serviceArea && pobj.baseInfo.serviceArea != 'undefined'){
                    if (pobj.baseInfo.sealSevType == "company"){
                        pobj.baseInfo.serviceAreaName = appconfig.pdict.registeredAreaDict[pobj.baseInfo.serviceArea];//注册地区
                    }
                    else{
                        pobj.baseInfo.serviceAreaName = appconfig.pdict.registeredParkDict[pobj.baseInfo.serviceArea];//注册地区
                    }
                }
            }

            //调商城的接口，把商机详情返回给商城
            var btype =  pobj.businessType;
            pobj.businessType = appconfig.pdict.fdyDict[pobj.businessType];
            
            var rc = system.getObject("util.execClient");
            var requrl = this.receiveUrl;
            var params =  {
                "actionType":"submitSolution",
                "actionBody":{
                    "needNum": pobj.businessMode,
                    "solutionNum":"",
                    "solutionContent": pobj
                }
            }   
            var rtn = await rc.execPost(params, requrl);
            var j = JSON.parse(rtn.stdout);
            console.log("------------------------------------------" + rtn.stdout);
            if (j.status == 1){
                pobj.schemeNumber = j.data;
                pobj.businessType = btype;
                await this.service.insertInfo(pobj);
                await this.bizoptService.updateStatusByDemandCode(pobj);//先修改商机状态
                return system.getResult("操作成功！");
            }
            else{
                return j;
            }
            
        }
        catch(error){
            return system.getResultError(error);
        }
    }
    else{
        return system.getResultError("参数错误！");
    }
  }

  /*插入或更新方案*/ 
  async createInfo(datajson,qobj, req){
    console.log("datejson:" + JSON.stringify(datajson));
    try{
        var rs = await this.service.findInfoByDemandCode(datajson.d);
        if (rs && rs != 'undefined'){
            datajson.d.schemeNumber = rs.scheme_number;
            return await this.updateInfoByDemandCode(datajson);
        }
        else{
            return await this.insertInfo(datajson);
        }
    }
    catch(error){
        return system.getResultError(error);
    }

  }

  timeFormat(date) {
    let localTime = moment.utc(date).toDate();
    localTime = moment(localTime).format("YYYY-MM-DD");
    return localTime;
  }
}
module.exports = SchemeCtl;

// var task = new SchemeCtl();
// var obj={"businessMode":"202006100002","baseInfo":{"memoInfo":"sfdsff","whetherType":"individual","creditCode":"1223345455","companyType":"有限公司","companyName":"三个五","establishedTime":"2010-5-6","registeredCapital":"5万元","shareholderName":"2B","businessTerm":"500","businessScope":"sgrgdrgghhh","residenceAddress":"北京市"}};
// task.insertInfo(obj,{},{}).then(d=>{
//   console.log(d);
//   //console.log(d[0].analyse)
// })
