const system = require("../../system");
const settings = require("../../../config/settings");
const appconfig = system.getSysConfig();
function exp(db, DataTypes) {
  var base = {
    //继承的表引用用户信息user_id
    code: DataTypes.STRING(100),
    name: DataTypes.STRING(500),
    creator: DataTypes.STRING(100),//创建者
    updator: DataTypes.STRING(100),//更新者
    auditor: DataTypes.STRING(100),//审核者
    opNotes: DataTypes.STRING(500),//操作备注
    auditStatusName: {
      type:DataTypes.STRING(50),
      defaultValue:"待审核",
    },
    auditStatus: {//审核状态"dsh": "待审核", "btg": "不通过", "tg": "通过"
      type: DataTypes.ENUM,
      values: Object.keys(appconfig.pdict.audit_status),
      set: function (val) {
        this.setDataValue("auditStatus", val);
        this.setDataValue("auditStatusName", appconfig.pdict.audit_status[val]);
      },
      defaultValue:"dsh",
    },
    sourceTypeName: DataTypes.STRING(50),
    sourceType: {//来源类型 "order": "订单","expensevoucher": "费用单","receiptvoucher": "收款单", "trademark": "商标单"
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.source_type),
      set: function (val) {
        this.setDataValue("sourceType", val);
        this.setDataValue("sourceTypeName", appconfig.pdict.source_type[val]);
      }
    },
    sourceOrderNo: DataTypes.STRING(100),//来源单号
  };
  return base;
}

module.exports = exp;
