const system = require("../../../system");
const Dao = require("../../dao.base");
class BizoptDao extends Dao {
  constructor() {
    super(Dao.getModelName(BizoptDao));
  }

  extraWhere(qobj, qw, qc) {//根据业务员id获取商机信息的组装条件
    qc.raw = true;
    //检查查询的用户所属公司是否是平台运营公司-1,如果是则不添加公司查询条件, 不添加路径条件,返回所有数据
    if (qobj.company_id == 1) {
      return qw
    } else {
      //需要添加公司查询条件
      qw["facilitator_id"] = Number(qobj.company_id)
      // 为空说明是管理员,不需设置组织结构过滤
      if (qobj.opath && qobj.opath != "") {
        qw["salesman_opcode"] = { [this.db.Op.like]: `%${qobj.opath}%` }
      }
      //不是来自平台前端查询
      if (qobj.bizpath && qobj.bizpath.indexOf("pmx") < 0) {
        qc.where.business_type = qc.where.business_type || {
          [this.db.Op.notIn]: ["ICP", "EDI"]
        }
        if (qobj.bizpath && qobj.bizpath != "") {
          if (qobj.bizpath.indexOf("myChance") > 0) {//说明是从商机列表过来的
            qw["salesman_id"] = qobj.userid;
          }
        }

      }
    }
    return qw;
  }

  /*根据商机编号获取商机详情*/
  async findInfoByDemandCode(qobj) {
    var qcwhere = { "demand_code": qobj.businessMode };
    return await this.findOne(qcwhere);
  }

  /*更新商机状态*/
  async updateStatusByDemandCode(qobj, t) {
    var setobj = { "business_status": qobj.currentStatus };
    if (qobj.statusReason && qobj.statusReason != 'undefined') {
      setobj["close_reason"] = qobj.statusReason;
    }
    else {
      setobj["close_reason"] = "";
    }
    var whereobj = { "demand_code": qobj.businessMode };
    return await this.updateByWhere(setobj, whereobj, t);
  }

  /*更新业务员信息*/
  async updateSalesmanInfoByDemandCode(qobj,t){
    var setobj = {};
    if (qobj.salesmanId && qobj.salesmanId != 'undefined') {
      setobj.salesman_id = qobj.salesmanId;
    };
    if (qobj.salesmanName && qobj.salesmanName != 'undefined') {
      setobj.salesman_name = qobj.salesmanName;
    };
    if (qobj.salesmanOpcode && qobj.salesmanOpcode != 'undefined') {
      setobj.salesman_opcode = qobj.salesmanOpcode;
    };
    if (qobj.salesmanPhone && qobj.salesmanPhone != 'undefined') {
      setobj.salesman_phone = qobj.salesmanPhone;
    };
    if (qobj.facilitatorId && qobj.facilitatorId != 'undefined') {
      setobj.facilitator_id = qobj.facilitatorId;
    };
    if (qobj.facilitatorName && qobj.facilitatorName != 'undefined') {
      setobj.facilitator_name = qobj.facilitatorName;
    };
    var whereobj = { "demand_code": qobj.businessMode };
    return await this.updateByWhere(setobj, whereobj, t);
  }

  /*插入商机信息*/
  async insertInfo(qobj, t) {
    var obj = {
      "demand_code": qobj.businessMode,
      "business_type": qobj.businessType,
      "business_status": qobj.currentStatus,
      "business_info": {}
    };
    if (qobj.channelSource && qobj.channelSource != 'undefined') {
      obj.source_name = qobj.channelSource;
    }
    if (qobj.sourceNumber && qobj.sourceNumber != 'undefined') {
      obj.source_number = qobj.sourceNumber;
    }
    if (qobj.serviceCode && qobj.serviceCode != 'undefined') {
      obj.service_address = qobj.serviceCode;
    }
    if (qobj.memoInfo && qobj.memoInfo != 'undefined') {
      obj.business_info.memoInfo = qobj.memoInfo;
    }
    if (qobj.statusReason && qobj.statusReason != 'undefined') {
      obj.close_reason = qobj.statusReason;
    }
    if (qobj.contactsName && qobj.contactsName != 'undefined') {
      obj.business_info.contactsName = qobj.contactsName;
    }
    if (qobj.contactsPhone && qobj.contactsPhone != 'undefined') {
      obj.business_info.contactsPhone = qobj.contactsPhone;//已经加密
    }
    if (qobj.serviceName && qobj.serviceName != 'undefined') {
      obj.business_info.serviceName = qobj.serviceName;
    }
    if (qobj.businessName && qobj.businessName != 'undefined') {
      obj.business_info.businessName = qobj.businessName;
    }
    if (qobj.UserName && qobj.UserName != 'undefined') {
      obj.business_info.userName = qobj.UserNames;
    }
    if (qobj.companyName && qobj.companyName != 'undefined') {
      obj.business_info.companyName = qobj.companyName;
    }
    if (qobj.servicerCode && qobj.servicerCode != 'undefined') {
      obj.facilitator_id = qobj.servicerCode;
    }
    if (qobj.servicerName && qobj.servicerName != 'undefined') {
      obj.facilitator_name = qobj.servicerName;
    }
    if (qobj.salesmanOpcode && qobj.salesmanOpcode != 'undefined') {
      obj.salesman_opcode = qobj.salesmanOpcode;
    }
    if (qobj.salesmanId && qobj.salesmanId != 'undefined') {
      obj.salesman_id = qobj.salesmanId;
    }
    if (qobj.clerkName && qobj.clerkName != 'undefined') {
      obj.salesman_name = qobj.clerkName;
    }
    if (qobj.clerkPhone && qobj.clerkPhone != 'undefined') {
      obj.salesman_phone = qobj.clerkPhone;
    }
    return await this.create(obj, t);
  }


}
module.exports = BizoptDao;
