var system = require("../../system");
const apiBase = require("../api.base");
class XbgApi extends apiBase{

    constructor() {
        super();
        this.utilesignbaoSve = system.getObject("service.utilesignbaoSve");
        this.etemplateSve = system.getObject("service.etemplateSve");
        this.ecompanySve = system.getObject("service.ecompanySve");
        this.econtractSve = system.getObject("service.econtractSve");
        this.esettleSve = system.getObject("service.esettleSve");
        this.etemplatebusiSve = system.getObject("service.etemplatebusiSve");
        this.etemplatebusiSve = system.getObject("service.etemplatebusiSve");
        this.excelClient = system.getObject("util.excelClient");

        this.dkcontractSve = system.getObject("service.dkcontractSve");

    }

    //合同模板
    async etemplateList(qobj) {
        try {
            var params = qobj || {};
            var ecompanyIds = params.ecompany_id;
            if (ecompanyIds) {
                params.ecompanyIds = ecompanyIds;
                delete params.ecompany_id;
            }
            var page = await this.etemplateSve.signPage(params);
            return system.getResult2(page);
        } catch (e) {
            console.log(e);
            return system.getErrResult2("接口异常");
        }
    }

    //已签合同
    async acontractList(qobj) {
        try {
            var params = qobj || {};
            var ecompanyIds = params.ecompany_id;
            if (ecompanyIds) {
                params.ecompanyIds = ecompanyIds;
                delete params.ecompany_id;
            }
            params.eflowstatusList = ['2'];
            this.doTimeCondition(params, ["signBegin", "signEnd"]);
            var page = await this.econtractSve.pageByCondition(params);
            return system.getResult2(page);
        } catch (e) {
            console.log(e);
            return system.getErrResult2("接口异常");
        }
    }


    async acontracttoMtchIdList_old(qobj) {
        try {
            var params = qobj || {};
            var eteids = await this.etemplatebusiSve.geteteIds(params.mtchId);
            if(eteids.length > 0){
                params.etemplateIds = eteids;
            }else {
                return system.getResult2({count:0,rows:[]});
            }
            params.eflowstatusList = ['2'];
            this.doTimeCondition(params, ["signBegin", "signEnd"]);
            var page = await this.econtractSve.pageByCondition(params);
            return system.getResult2(page);
        } catch (e) {
            console.log(e);
            return system.getErrResult2("接口异常");
        }
    }

    async acontracttoMtchIdList(qobj) {
        try {
            let params = qobj || {};
            let bList = await this.etemplatebusiSve.byBusiId(params.mtchId);
            if (!bList || bList.length == 0) {
                return system.getResult2({count: 0, rows: []});
            }

            let zIds = [];  // 专票末班id
            let pIds = [];  // 普票模板id
            for (let busi of bList) {
                if (busi.template_type == 1) {
                    zIds.push(busi.template_id);
                } else {
                    pIds.push(busi.template_id);
                }
            }

            if(zIds.length > 0){
                params.etemplateIds = zIds;
                params.eflowstatusList = ['2'];
                this.doTimeCondition(params, ["signBegin", "signEnd"]);
                let page = await this.econtractSve.pageByCondition(params);
                return system.getResult2(page);
            }

            if (pIds.length > 0) {
                params.dktemplateIds = pIds;
                params.eflowstatusList = ['2'];
                this.doTimeCondition(params, ["signBegin", "signEnd"]);
                let page = await this.dkcontractSve.pageByCondition(params);
                // 处理一下狗屎
                if (page && page.rows) {
                    for (let row of page.rows) {
                        row.template_type = 2;
                        row.etemplate_id = row.dktemplate_id;
                        row.ecompany_id = row.dkcompany_id;
                        row.ecompany = row.dkcompany;
                        row.template = {
                            id: 10233,
                        }
                    }
                }
                return system.getResult2(page);
            }
        } catch (e) {
            console.log(e);
            return system.getErrResult2("接口异常");
        }
    }


    //已签合同导出
    async allExport(qobj) {
        var params = qobj || {};
        params.currentPage = 1;
        params.pageSize = 60000;
        let res = await this.acontracttoMtchIdList(params);
        return res.data;
    }

    //纳税人人员
    async ratepayingListToPe(qobj) {
        try {
            var params = qobj || {};
            if (!params.busiIds) {
                return system.getResult2({count:0, rows:[]})
            }
            var params = this.getSettleParams(params);
            var page = await this.esettleSve.ratepayingToPe(params);
            return system.getResult2(page);
        } catch (e) {
            console.log(e);
            return system.getErrResult2("接口异常");
        }
    }

    //纳税人按月
    async ratepayingListToMonth(qobj) {
        try {
            var params = qobj || {};
            if (!params.busiIds) {
                return system.getResult2({count:0, rows:[]})
            }
            var params = this.getSettleParams(params);
            var page = await this.esettleSve.ratepayingToMonth(params);
            return system.getResult2(page);
        } catch (e) {
            console.log(e);
            return system.getErrResult2("接口异常");
        }
    }

    //纳税人个人详情
    async ratepayingListToOne(qobj) {
        try {
            var params = qobj || {};
            if (!params.busiIds) {
                return system.getResult2({count:0, rows:[]})
            }
            var params = this.getSettleParams(params);
            var page = await this.esettleSve.ratepayingToOne(params);
            return system.getResult2(page);
        } catch (e) {
            console.log(e);
            return system.getErrResult2("接口异常");
        }
    }

    //数据概览
    async dataOverview(qobj){
        try {
            var params = qobj || {};
            var ecompanyId = params.ecompany_id;
            if (ecompanyId.length > 1) {
                params.ecompanyIds = [ecompanyId];
                delete params.ecompany_id;
            } else {
                params.ecompanyIds = ecompanyId;
                delete params.ecompany_id;
            }
            var result = {};
            result.contractCount = await this.econtractSve.getCount(params);
            var list = await this.esettleSve.getPays(params);
            result.actual_amt = list.actual_amt;
            result.income_tax = list.income_tax;
            return system.getResult2(result);
        }catch (e) {
            console.log(e);
            return system.getErrResult2("接口异常");
        }
    }

    async validLwbSign(obj, req) {
        let idNo = this.trim(obj.idNo);
        let ecid = Number(obj.ecid || 0);
        try {
            let rs = await this.econtractSve.validLwbSign(idNo, ecid);
            return system.getResult2(rs);
        }catch (e) {
            console.log(e);
            return system.getErrResult2("接口异常");
        }
    }

    async lwbContractUrl(obj, req) {
        let idNo = this.trim(obj.idNo);
        let ecid = Number(obj.ecid || 0);
        try {
            let rs = await this.econtractSve.lwbContractUrl(idNo, ecid);
            if (rs == -1) {
                return system.getErrResult2("用户未签约");
            }
            return system.getResult2(rs);
        }catch (e) {
            console.log(e);
            return system.getErrResult2("接口异常");
        }
    }

}

module.exports = XbgApi;
