const system=require("../../system");
const Dao=require("../dao.base");
const moment = require("moment");
class CcashinfoDao extends Dao{
  constructor(){
    super(Dao.getModelName(CcashinfoDao));
  }

  async findUnNotifyIds() {
    let date = moment().add(-485, 'minutes').format("YYYY-MM-DD HH:mm:ss");
    let sql = "SELECT id FROM `c_cash_info` WHERE trade_status IN ('00', '02') AND notify_rs = '' AND updated_at <= :date ORDER BY id DESC ";
    let list = await this.customQuery(sql, {date: date});
    return list;
  }

  async moreIds(id, mchtId, limit) {
    let sql = "SELECT id FROM `c_cash_info` WHERE id >= :id AND deduct_amt = 0  AND mchtId = :mchtId AND trade_status = '00' ORDER BY id ASC LIMIT :limit ";
    let list = await this.customQuery(sql, {id: id, mchtId: mchtId, limit: limit});
    return list;
  }

}
module.exports=CcashinfoDao;
