const system = require("../../system");
const Dao = require("../dao.base");
class regionareaDao extends Dao {
  constructor() {
    super(Dao.getModelName(regionareaDao));
  }

  async findNameByCode(code) {
    if (!code) {
      return "";
    }
    var map = await this.findNameMapByCodes([code]);
    return map[code] || "";
  }

  async findNameMapByCodes(codeList) {
    var result = [];
    try {
      var codes = [];
      if (!codeList || codeList.length == 0) {
        return result;
      }

      for (var code of codeList) {
        if (!code) {
          continue;
        }
        var arr = code.split("_");
        for (var v of arr) {
          if (!v) {
            continue;
          }
          codes.push("'" + v + "'");
        }
      }

      if (codes.length == 0) {
        return result;
      }

      var sql = "SELECT REGION_CODE, REGION_NAME FROM bs_areainfo WHERE REGION_CODE IN (" + codes.join(",") + ") ";
      var list = await this.customQuery(sql);
      var map = {};
      for (var item of list) {
        map[item.REGION_CODE] = item.REGION_NAME;
      }

      for (var code of codeList) {
        if (!code) {
          continue;
        }
        var nameArr = [];
        var arr = code.split("_");
        for (var v of arr) {
          if (!v) {
            continue;
          }
          var name = map[v];
          if (name) {
            nameArr.push(name);
          }
        }
        if (nameArr.length > 0) {
          result[code] = nameArr.join("-");
        }
      }
    } catch (error) {
      console.error(err.stack)
    }

    return result;
  }

}
module.exports = regionareaDao;