const system = require("../../system");
const settings = require("../../../config/settings");
const uiconfig = system.getUiConfig2(settings.wxconfig.appId);
module.exports = (db, DataTypes) => {
  return db.define("eintentionfollow", {

    eintention_id: DataTypes.INTEGER,
    followUserId: DataTypes.INTEGER,
    followUserName: DataTypes.STRING(100),
    content: DataTypes.STRING(100),

    followStatusName: {
      // 客户等级名称
      type: DataTypes.STRING(20),
      defaultValue: "普通",
    },
    followStatus: {
      // 客户等级  0待跟进 1有意向 2无意向
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.efollowStatus),
      set: function (val) {
        this.setDataValue("followStatus", val);
        this.setDataValue("followStatusName", uiconfig.config.pdict.efollowStatus[val]);
      },
      defaultValue: "0",
    },
  }, {
    paranoid: true, //假的删除
    underscored: true,
    version: true,
    freezeTableName: true,
    //freezeTableName: true,
    // define the table's name
    tableName: 'c_eintention_follow',
    validate: {},
    indexes: [
      // Create a unique index on email
      //  {
      //    unique: true,
      //    fields: ['email']
      //  },
      //
      //  // Creates a gin index on data with the jsonb_path_ops operator
      //  {
      //    fields: ['data'],
      //    using: 'gin',
      //    operator: 'jsonb_path_ops'
      //  },
      //
      //  // By default index name will be [table]_[fields]
      //  // Creates a multi column partial index
      //  {
      //    name: 'public_by_author',
      //    fields: ['author', 'status'],
      //    where: {
      //      status: 'public'
      //    }
      //  },
      //
      //  // A BTREE index with a ordered field
      //  {
      //    name: 'title_index',
      //    method: 'BTREE',
      //    fields: ['author', {attribute: 'title', collate: 'en_US', order: 'DESC', length: 5}]
      //  }
    ]
  });
}