const ServiceBase = require("../sve.base");

class EtemplatebusiService extends ServiceBase {
    constructor() {
        super(ServiceBase.getDaoName(EtemplatebusiService));
    }

    async getlist(id) {
        var sql = "SELECT * FROM c_etemplate_busi WHERE template_id = :template_id";
        var page = await this.customQuery(sql,{template_id:id});
        return page;
    }
    async busiIdsByTemplateId(template_id) {
        var sql = "SELECT busi_id FROM c_etemplate_busi WHERE template_id = :template_id";
        var list = await this.customQuery(sql, {template_id: template_id});
        let rs = [];
        if (!list || list.length == 0) {
            return rs;
        }
        for (let item of list) {
            rs.push(item.busi_id);
        }

        return rs;
    }

    async geteteIds(busi_id) {
        var sql = "SELECT template_id FROM c_etemplate_busi WHERE template_type = 1 AND busi_id = :busi_id";
        var list = await this.customQuery(sql, {busi_id: busi_id});
        let ids = [];
        if (!list || list.length == 0) {
            return ids;
        }
        for (let item of list) {
            ids.push(item.template_id);
        }
        return ids;
    }

    async byBusiId(busi_id) {
        var sql = "SELECT template_type, template_id FROM c_etemplate_busi WHERE busi_id = :busi_id";
        return await this.customQuery(sql, {busi_id: busi_id});
    }

    async busiByTemplate(template_id) {
        var sql = "SELECT * FROM c_etemplate_busi WHERE template_type = 2 AND template_id = :template_id";
        return await this.customQuery(sql, {template_id: template_id});
    }

    async busiByTemplate2(app_id, template_id, template_type) {
        var sql = "SELECT * FROM c_etemplate_busi WHERE template_type = :template_type AND template_id = :template_id AND app_id = :app_id";
        return await this.customQuery(sql, {template_id: template_id, app_id: app_id, template_type: template_type});
    }

    async getinfo(qobj) {
        var sql = "SELECT * FROM c_etemplate_busi WHERE template_id = " + qobj.template_id + " AND busi_id = " + qobj.company_id;
        var page = await this.customQuery(sql);
        return page;
    }

    async deleteTetId(qobj) {
        let sql = "DELETE FROM c_etemplate_busi WHERE id = " + qobj.id;
        await this.customExecAddOrPutSql(sql);
        return 1;
    }

    async suggest(name, ownerIds) {
        return await this.dao.suggest(name, ownerIds);
    }

    async saveto(etebusi) {
        return await this.create(etebusi);

    }
}

module.exports = EtemplatebusiService;
