const system=require("../system");
const settings=require("../../config/settings");
const moment = require("moment");

class ServiceBase{
  constructor(daoName){
     //this.dbf=system.getObject("db.connection");
     this.db=system.getObject("db.connection").getCon();
     this.cacheManager=system.getObject("db.cacheManager");
     this.daoName=daoName;
     this.dao=system.getObject("db."+daoName);
     this.md5=require("MD5");
  }
  static getDaoName(ClassObj){
    return ClassObj["name"].substring(0,ClassObj["name"].lastIndexOf("Service")).toLowerCase()+"Dao";
  }
  async findAll(obj){
    const objs=await this.dao.model.findAll();
    return objs;
 }
  async findAndCountAll(obj){
     const apps=await this.dao.findAndCountAll(obj);
     return apps;
  }
  async refQuery(qobj){
    return this.dao.refQuery(qobj);
  }
  async bulkDelete(ids){
    var en= await this.dao.bulkDelete(ids);
    return en;
  }
  async delete(qobj){
    return  this.dao.delete(qobj);
  }
  async create(qobj){
    return this.dao.create(qobj);
  }
  async update(qobj,tm=null){
    return this.dao.update(qobj,tm);
  }
  async updateByWhere(setObj,whereObj,t){
      return this.dao.updateByWhere(setObj,whereObj,t);
  }
  async customExecAddOrPutSql(sql,paras=null){
    return this.dao.customExecAddOrPutSql(sql,paras);
  }
  async customQuery(sql,paras,t){
    return this.dao.customQuery(sql,paras,t);
  }
  async findCount(whereObj=null){
    return this.dao.findCount(whereObj);
  }
  async findSum(fieldName,whereObj=null){
    return this.dao.findSum(fieldName,whereObj);
  }
  async getPageList(pageIndex,pageSize,whereObj=null,orderObj=null,attributesObj=null,includeObj=null){
    return this.dao.getPageList(pageIndex,pageSize,whereObj,orderObj,attributesObj,includeObj);
  }
  async findOne(obj){
    return this.dao.findOne(obj);
  }
  async findById(oid){
    return this.dao.findById(oid);
  }
  async getUidInfo(len, radix) {
      var chars = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ'.split('');//长度62，到yz长度为长36
      var uuid = [], i;
      radix = radix || chars.length;
      if (len) {
        for (i = 0; i < len; i++) uuid[i] = chars[0 | Math.random()*radix];
      } else {
        var r;
        uuid[8] = uuid[13] = uuid[18] = uuid[23] = '-';
        uuid[14] = '4';
        for (i = 0; i < 36; i++) {
          if (!uuid[i]) {
            r = 0 | Math.random()*16;
            uuid[i] = chars[(i == 19) ? (r & 0x3) | 0x8 : r];
          }
        }
      }
      return uuid.join('');
  }
  encryptPasswd(passwd) {
    if(!passwd) {
			throw new Error("请输入密码");
		}
		var md5 = this.md5(passwd + "_" + settings.salt);
		return md5.toString().toLowerCase();
  }
  handleDate(row, fields, pattern, addHours) {
    pattern = pattern || "YYYY-MM-DD HH:mm";
    if (!row) {
      return;
    }
    for (var field of fields) {
      if (row[field]) {
        if(addHours) {
          row[field] = moment(row[field]).add(addHours,"hours").format(pattern);
        } else {
          row[field] = moment(row[field]).format(pattern);
        }

      }
    }
  }

  addWhereTime(where, field, begin, end) {
    if(!begin && !end) {
      return;
    }

    if (begin && end) {
      where[field] = {
        [this.db.Op.between]: [begin, end]
      };
    } else if (begin && !end) {
      where[field] = {
        [this.db.Op.gte]: begin
      };
    } else if (!begin && end) {
      where[field] = {
        [this.db.Op.lte]: end
      };
    }
  }

  trim(o) {
    if(!o) {
      return "";
    }
    return o.toString().trim();
  }

    addmonth(params) {
        if (this.trim(params.month)) {
            params.createBegin = moment(params.month).format("YYYY-MM-DD") + " 00:00:00";
            params.createEnd = moment(params.month).add(1, "months").subtract(1, 'days').format("YYYY-MM-DD") + " 23:59:59";
        }
    }
}
module.exports=ServiceBase;
