﻿var url = require("url");
var System = require("../../base/system");
const settings = require("../settings");
const logCtl = System.getObject("web.oplogCtl");
module.exports = function (app) {

	app.get('/ec', async function (req, res) {
		var code = req.query.code;
		var state = req.query.state;
		if (code) {
			try {
				var loginCtl = System.getObject("web.userCtl");
				var homeUrl = await loginCtl.wxlogin(code, state, req);
				if (homeUrl) {
					return res.redirect(homeUrl);
				}
			} catch (e) {
				logCtl.error({
					optitle: "web 根接口调用登录异常error:",
					op: "userCtl/login",
					content: e.stack,
					clientIp: System.get_client_ip(req),
					agent: req.headers["user-agent"],
				});
			}
		}
		res.render("h5", {});
	});

	app.get('/ecyd', async function (req, res) {
		try {
			var loginCtl = System.getObject("web.userCtl");
			var homeUrl = await loginCtl.loginyd(req);
			if (homeUrl) {
				return res.redirect(homeUrl);
			}
		} catch (e) {
			logCtl.error({
				optitle: "web 根接口调用登录异常error:",
				op: "userCtl/login",
				content: e.stack,
				clientIp: System.get_client_ip(req),
				agent: req.headers["user-agent"],
			});
		}
		res.render("h5", {});
	});

	app.get('/ecyd2', async function (req, res) {
		try {
			var loginCtl = System.getObject("web.userCtl");
			var homeUrl = await loginCtl.loginyd2(req);
			if (homeUrl) {
				return res.redirect(homeUrl);
			}
		} catch (e) {
			logCtl.error({
				optitle: "web 根接口调用登录异常error:",
				op: "userCtl/login",
				content: e.stack,
				clientIp: System.get_client_ip(req),
				agent: req.headers["user-agent"],
			});
		}
		res.render("h5yd", {});
	});

	app.get('/ec3rd', async function (req, res) {
		try {
			var loginCtl = System.getObject("web.userCtl");
			var homeUrl = await loginCtl.login3rd(req);
			if (homeUrl) {
				return res.redirect(homeUrl);
			}
		} catch (e) {
			logCtl.error({
				optitle: "web 根接口调用登录异常error:",
				op: "userCtl/login",
				content: e.stack,
				clientIp: System.get_client_ip(req),
				agent: req.headers["user-agent"],
			});
		}
		res.render("h5", {});
	});

	app.get('/ts', async function (req, res) {
		try {
			var dksignCtl = System.getObject("web.dksignCtl");
			var homeUrl = await dksignCtl.logints(req);
			if (homeUrl) {
				return res.redirect(homeUrl);
			}
		} catch (e) {
			logCtl.error({
				optitle: "web 根接口调用登录异常error:",
				op: "userCtl/login",
				content: e.stack,
				clientIp: System.get_client_ip(req),
				agent: req.headers["user-agent"],
			});
		}
	});

	app.get('/bpoent',async function (req, res) {

		try {
			var entcontractCtl = System.getObject("web.entcontractCtl");
			var esign = await entcontractCtl.geturl(req);
			if (esign.code ==0) {
				return res.redirect(esign.data);
			}
		} catch (e) {
			logCtl.error({
				optitle: "web 根接口调用登录异常error:",
				op: "userCtl/login",
				content: e.stack,
				clientIp: System.get_client_ip(req),
				agent: req.headers["user-agent"],
			});
		}

	});

	app.all("/web/*", function (req, res, next) {
		if (req.url.indexOf("getRouteConfigWithoutProduct") > 0 ||
			req.url.indexOf("getRsConfig") > 0 ||
			req.url.indexOf("checkLogin") > 0 ||
			req.url.indexOf("getDicConfig") > 0 ||
			req.url.indexOf("fetchVcode") > 0 ||
			req.url.indexOf("register") > 0 ||
			req.url.indexOf("login") > 0 ||
			req.url.indexOf("userCtl/wxlogin") > 0 ||
			req.url.indexOf("userCtl/patnerValid") > 0 ||
			req.url.indexOf("userCtl/sendSMSCode") > 0 ||
			req.url.indexOf("userCtl/saveCompanyForget") > 0 ||
			req.url.indexOf("userCtl/regCompanyUser") > 0 ||
			req.url.indexOf("wxCtl/fetchOAuthPath") > 0 ||
			req.url.indexOf("wxCtl/getJsApiConfig") > 0 ||
			req.url.indexOf("wxCtl/wxuseropenid") > 0 ||
			req.url.indexOf("ecompanywxuserCtl/saveuser") > 0 ||
			req.url.indexOf("ecompanywxuserCtl/companyName") > 0 ||
			req.url.indexOf("ecompanywxuserCtl/validateSign") > 0 ||

			req.url.indexOf("ecompanywxuserCtl/saveEcidUser") > 0 ||
			req.url.indexOf("ecompanywxuserCtl/validateECSign") > 0 ||
			req.url.indexOf("ecompanywxuserCtl/companyByEcid") > 0 ||

			/dksignCtl\/./.test(req.url) ||
			/cwxsignapiCtl\/./.test(req.url) ||

			req.url.indexOf("econtractCtl/getPayNotify") > 0 ||
			req.url.indexOf("ecompanyCtl/wxsignCompany") > 0 ||
			req.url.indexOf("taskCtl/restartTasks2") > 0 ||
			req.url.indexOf("loopplay") > 0 ||
			req.url.indexOf("newschannel") > 0 ||
			req.url.indexOf("article") > 0 ||
			req.url.indexOf("channelquery") > 0 ||
			req.url.indexOf("metaCtl") > 0 ||
			req.url.indexOf("epartnerCtl/apply") > 0 ||
			req.url.indexOf("esettleCtl/busiAccount") > 0 ||
			req.url.indexOf("esettleCtl/transfer") > 0 ||
			req.url.indexOf("esettleCtl/getSign") > 0 ||

			req.url.indexOf("etemplateCtl/info") > 0 ||
            req.url.indexOf("userCtl/getCurrentUser") > 0 ||
            req.url.indexOf("ecompanyCtl/findOne") > 0 ||
            req.url.indexOf("userCtl/updateSigner") > 0 ||
            req.url.indexOf("econtractCtl/genContract") > 0 ||

			req.url.indexOf("authCtl/test") > 0 ||

            req.url.indexOf("getOssConfig") > 0) {
			// 韵达电子签免登陆, 因为它们牛逼闪闪的技术只会用iframe丢cookie
			return next();
		}
		if (!req.session.user) {
			var x = {
				status: -99,
				msg: "no login"
			};
			res.end(JSON.stringify(x));
		} else {
			//console.log(req.headers);
			next();
		}
	});
	app.get('/web/:qname/:method', function (req, res) {
		console.log(req.headers);
		req.codepath = req.headers["codepath"];

		var classPath = req.params["qname"];
		var methodName = req.params["method"];
		var params = [];
		params.push(req.query);
		params.push(req);
		params.push(res);
		var p = null;
		var invokeObj = System.getObject("web." + classPath);
		if (invokeObj[methodName]) {
			p = invokeObj[methodName].apply(invokeObj, params);
		}
		p.then(r => {
			if(r) {
				res.end(JSON.stringify(r));
			} else {
				res.end();
			}
		}).then(() => {
			params.pop();
			try {
				logCtl.info({
					optitle: "web get接口调用info:",
					op: classPath + "/" + methodName,
					content: "参数：" + JSON.stringify(req.query || {}),
					clientIp: System.get_client_ip(req),
					agent: req.headers["user-agent"],
				});
			} catch (error) {

			}
		}).catch(e => {
			console.log(e);
			logCtl.error({
				optitle: "web get接口调用异常error:",
				op: classPath + "/" + methodName,
				content: e.stack,
				clientIp: System.get_client_ip(req),
				agent: req.headers["user-agent"],
			});
		});
	});
	app.post('/web/:qname/:method', function (req, res) {
		req.codepath = req.headers["codepath"];
		var classPath = req.params["qname"];
		var methodName = req.params["method"];
		var params = [];
		console.log("requestBody----------", req.body, new Date());
		params.push(req.query);
		params.push(req.body);
		params.push(req);
		params.push(res);
		var p = null;
		var invokeObj = System.getObject("web." + classPath);
		if (invokeObj[methodName]) {
			p = invokeObj[methodName].apply(invokeObj, params);
		}
		p.then(r => {
			if(r) {
				res.end(JSON.stringify(r));
			} else {
				res.end();
			}
		}).then(() => {
			params.pop();
			logCtl.info({
				optitle: "web post接口调用info:",
				op: classPath + "/" + methodName,
				content: "参数：" + JSON.stringify(req.body || {}),
				clientIp: System.get_client_ip(req),
				agent: req.headers["user-agent"],
			});
		}).catch(e => {
			var s = System.getResult2(null, null, null, e.message);
			logCtl.error({
				optitle: "web post接口调用异常error:",
				op: classPath + "/" + methodName,
				content: e.stack,
				clientIp: System.get_client_ip(req),
				agent: req.headers["user-agent"],
			});
			if(s) {
				res.end(JSON.stringify(s));
			} else {
				res.end();
			}
		});

	});

	app.get('/blank', function (req, res) {
		res.render("blank", {});
	});
	app.get('/bpoproxy', function (req, res) {
		res.render("bpoproxy", {});
	});

	app.get('/bpoproxypc', function (req, res) {
		res.render("bpoproxypc", {});
	});

	app.get('/h5', function (req, res) {
		res.render("h5", {});
	});
	app.get('/pdfh5', function (req, res) {
		res.render("pdfh5", {});
	});
	app.get('/bposettle', function (req, res) {
		res.render("bposettle", {});
	});
	app.get('/loginbpohhr', function (req, res) {
		res.render("login/loginbpohhr", {});
	});
	app.get('/loginbpoent', function (req, res) {
		res.render("login/loginbpoent", {});
	});
	app.get('/loginbpoadmin', function (req, res) {
		res.render("login/loginbpoadmin", {});
	});
	app.get('/forgetent', function (req, res) {
		res.render("login/forgetent", {});
	});
	app.get('/regent', function (req, res) {
		res.render("login/regent", {});
	});
	app.get('/bpostat', function (req, res) {
		res.render("bpostat", {});
	});
	app.get('/wxsign', function (req, res) {
		res.render("wxsign", {});
	});
	app.get('/wxsignaggreement', function (req, res) {
		res.render("wxsignaggreement", {});
	});
	app.get('/bpowxsignaggreement2', function (req, res) {
		res.render("bpowxsignaggreement2", {});
	});
	app.get('/bpowxsignaggreement3', function (req, res) {
		res.render("bpowxsignaggreement3", {});
	});
	app.get('/wxsign3rd', function (req, res) {
		res.render("wxsign3rd", {});
	});
	app.get('/bpowxsign', function (req, res) {
		res.render("bpowxsign", {});
	});

	app.get('/errpage', function (req, res) {
		res.render("errpage", {});
	});

	app.get('/h5yd', function (req, res) {
		res.render("h5yd", {});
	});
	app.get('/tsign', function (req, res) {
		res.render("tsign", {});
	});
	app.get('/paynotify', function (req, res) {
		res.render("paynotify", {});
	});
	// app.get('/bpoent', function (req, res) {
	// 	res.render("bpoent", {});
	// });
	app.get('/', function (req, res) {
		res.render("main", {});
	});
};
