{
    template: '${tmpl}',
        data: function() {
            var validateOldPwd = (rule, value, callback) => {
                if (!value) {
                    return callback(new Error('密码不能为空'));
                } else {
                    callback();
                }
            };
            var validateNewPwd = (rule, value, callback) => {
                if (value === '') {
                    callback(new Error('请输入密码'));
                } else {
                    callback();
                }
            };
            var validateConfimPwd = (rule, value, callback) => {
                if (value === '') {
                    callback(new Error('请再次输入密码'));
                } else if (value !== this.pwdForm.newPassword) {
                    callback(new Error('两次输入密码不一致!'));
                } else {
                    callback();
                }
            };
            return {
                currentUser: null,
                dialogTableVisible: false,
                dialogFormVisible: false,
                pwdSaveLoading: false,
                companyForm: {
                    name: '',
                    account: '',
                    password: '',
                    partnerType: '',
                    partnerLevel: ''
                },
                pwdForm: {
                    oldPassword: '',
                    newPassword: '',
                    confimPassword: ''
                },
                formLabelWidth: '115px',
                rules: {
                    oldPassword: [
                        { validator: validateOldPwd, trigger: 'blur' }
                    ],
                    newPassword: [
                        { validator: validateNewPwd, trigger: 'blur' }
                    ],
                    confimPassword: [
                        { validator: validateConfimPwd, trigger: 'blur' }
                    ]
                },
            }
        },
    mounted: function() {
        this.getUserInfo();
    },
    created: function() {

    },
    methods: {
        getUserInfo() {
            var self = this;
            self.$root.postReq("/web/epartnerCtl/info", {}).then(function (d) {
                if (d.status == 0) {
                    var user = d.data.user || {};
                    var epartner = d.data.epartner || {};

                    self.companyForm.account = user.userName || "";
                    self.companyForm.partnerType = epartner.partnerTypeName || "";
                    self.companyForm.partnerLevel = epartner.partnerLevelName || "";
                }
            });
        },
        cancel: function() {
            this.initDialog();
        },
        save: function() {
            var self = this;            
            self.pwdSaveLoading = true;

            setTimeout(() => {
                self.pwdSaveLoading = false;
            }, 5000);
            this.$refs['pwdForm'].validate((valid) => {
                if (valid) {
                    var getOldPwd = self.pwdForm.oldPassword;
                    var getNewPwd = self.pwdForm.newPassword;
                    var getConfPwd = self.pwdForm.confimPassword;
                    self.$root.postReq("/web/epartnerCtl/updatePwd", { oldPwd: getOldPwd, newPwd: getNewPwd, confPwd: getConfPwd }).then(function (d) {
                        console.info(d,"---------------------");
                        self.pwdSaveLoading = false;
                        if (d.status == 0) {
                            self.initDialog();
                            self.companyForm.password = getNewPwd;
                        }else{
                            self.pwdForm.oldPassword = "";
                            self.$message.error('当前密码输入有误！'); 
                        }
                    });
                } else {
                    self.pwdSaveLoading = false;
                    return false;
                }
            });
        },
        initDialog: function() {
            this.dialogFormVisible = false;
            this.$refs['pwdForm'].resetFields();
        }
    },
    vname: "gsb-bpouser"
}

