{
    template: '${tmpl}',
    data: function () {
        var validMethod = (rule, value, callback) => {
            return this.validfileds(rule, value, callback);
        };

        return {
            dkaggreement: {},
            editTitle: "新增",
            showEdit: false,
            saveLoading: false,

            uploadResult: null,
            fileList:[],
            search: {
                list: [],
                currentPage: 1,
                pageSize: 20,
                total : 0,
                name:'',
            },
            rules: {
                name : [
                    { required: true, message: '请输入协议名称', trigger: 'blur' },
                ],
                filepath: [
                    { required: true, message: '请上传签约协议', trigger: 'blur' },
                ],
                a : [],
            },
        }
    },
    mounted: function () {
        this.resetSearch(true);
    },
    created: function () {},
    methods: {
        getEmptySearch() {
            return {
                list: [],
                currentPage: 1,
                pageSize: 20,
                total : 0,
                name:'',
            }
        },
        resetSearch() {
            this.search = this.getEmptySearch();
            this.getList();
        },
        tableHeaderColor({ row, column, rowIndex, columnIndex }) {
            if (rowIndex === 0) {
                return 'background-color: #F5F5F5;color: #2F2F2F;font-size: 14px;font-weight:400;'
            }
        },
        opSearch() {
            this.search.currentPage = 1;
            this.search.total = 0;
            this.getList();
        },
        getList() {
            var self = this;
            var params = this.getParams();
            this.$root.postReq("/web/dkaggreementCtl/list", {
                search: params
            }).then(function (d) {
                if (d.status == 0) {
                    self.search.list = d.data.rows || [];
                    self.search.total = d.data.count || 0;
                } else {
                }
            });
        },
        getParams() {
            var params = {};
            for(var f in this.search) {
                if(f == "list") {
                    continue;
                }
                params[f] = this.search[f];
            }
            return params;
        },

        onColFormater(row, column, cellValue, index) {
            return cellValue || "---";
        },
        getdkaggreement(id) {
            var self = this;
            self.$root.postReq("/web/dkaggreementCtl/info", {
                id: id,
            }).then(function (d) {
                if (d.status == 0) {
                    if(d.data) {
                        d.data.isEnabled = d.data.isEnabled ? true : false;
                    }
                    self.dkaggreement = d.data;
                    if(self.dkaggreement.filepath) {
                        self.fileList = [{
                            name: "模板文件",
                            url: self.dkaggreement.filepath,
                        }];
                    } else {
                        self.uploadResult = null;
                    }
                    console.log(self.uploadResult);
                } else {
                    self.$message.warning(d.msg || `您的网络不稳定, 请稍后重试`);
                }
            });
        },
        toDetail(id) {
        },
        openEdit(id) {
            this.clearUpload();
            if(id) {
                this.editTitle = "修改";
                this.getdkaggreement(id);
            } else {
                this.editTitle = "修改";
                this.dkaggreement = {isEnabled:true};
            }
            this.showEdit = true;
        },
        handleSizeChange(val) {
            this.search.pageSize = val;
            this.resetSearch();
        },
        handleCurrentChange(val) {
            this.search.currentPage = val;
            this.getList();
        },
        validfileds(rule, value, callback) {
            var self = this;
            if(rule.field == "ecompanyName") {
                if(!self.dkaggreement.dkcompany_id) {
                    return callback(new Error("请重新选择公司名称"));
                }
            }
            return callback();
        },
        clearUpload() {
            var self = this;
            self.uploadResult = null;
            self.dkaggreement.filepath = "";
            if(self.$refs.upload3 && self.$refs.upload3.$refs && self.$refs.upload3.$refs.upload) {
                self.$refs.upload3.$refs.upload.clearFiles();
            }
        },
        uploadsuccess(v) {
            if(!v || !v[0] || !v[0].url) {
                this.$message.warning("上传失败");
                return;
            }
            this.dkaggreement.filepath = v[0].url;
        },

        dosave() {
            var self = this;
            self.$refs.dkaggreement.validate((valid) => {
                if (valid) {
                    self.saveLoading = true;
                    setTimeout(() => {
                        self.saveLoading = false;
                    }, 15000);
                    self.$root.postReq("/web/dkaggreementCtl/mysave", self.dkaggreement).then(function (d) {
                        if (d.status == 0) {
                            self.$message.success(`保存成功`);
                            self.showEdit = false;
                            self.getList();
                        } else {
                            self.$alert(d.msg || '保存失败', '提示', {
                                confirmButtonText: '确定',
                                callback: action => {}
                            });
                        }
                        self.saveLoading = false;
                    });
                } else {
                    self.saveLoading = false;
                    return false;
                }
            });
        },
    },
    vname: "gsb-dkaggreement"
}