{
    template: '${tmpl}',
    data: function () {
        return {
            laststatus: '0',
            statustab: '0',
            detailTitle: '查看详情',
            isAudit: false,
            showReject: false,
            auditJobId: 0,
            showDetail: false,
            auditLoading: false,
            auditStatus: '1',
            auditRemark: '',
            jobDetail: {},
            search0: null,
            search1: null,
            search2: null,
            search: {
                list: [],
                currentPage: 1,
                pageSize: 20,
                total : 0,
                applyBegin:'',
                applyEnd:'',
                publishBegin:'',
                publishEnd:'',
                rejectBegin:'',
                rejectEnd:'',
                cancelBegin:'',
                cancelEnd:'',
                num:'',
                name: '',
                workTimeBegin:'',
                workTimeEnd:'',
                sex: '',
                settleType: '',
            },
            sexOptions:[
                {
                    value: 'all',
                    label: '不限'
                },
                {
                    value: 'male',
                    label: '男'
                },
                {
                    value: 'female',
                    label: '女'
                },
            ],
            settleTypeOptions:[
                {
                    value: '0',
                    label: '计时+计件'
                },
                {
                    value: '1',
                    label: '计时'
                },
                {
                    value: '2',
                    label: '计件'
                },
            ],
        }
    },
    mounted: function () {
        this.resetSearch(true);
    },
    created: function () {},
    methods: {
        statusChange(v) {
            this["search" + this.laststatus] = this.search;
            this.statustab = v;
            if(this["search" + this.statustab]) {
                this.search = this["search" + this.statustab];
            } else {
                this.search = this.getEmptySearch();
            }

            this.laststatus = this.statustab;
            if(!this.search.list || this.search.list.length == 0) {
                this.getList();
            }
            console.log(this["search" + this.statustab]);
            console.log(this.search0, this.search1, this.search2);
        },
        getEmptySearch() {
            return {
                currentPage: 1,
                pageSize: 20,
                total : 0,
                list:[],    
                applyBegin:'',
                applyEnd:'',
                publishBegin:'',
                publishEnd:'',
                rejectBegin:'',
                rejectEnd:'',
                cancelBegin:'',
                cancelEnd:'',
                num:'',
                name: '',
                workTimeBegin:'',
                workTimeEnd:'',
                sex: '',
                settleType: '',
            }
        },
        resetSearch(all) {
            console.log(all);
            this.search = this.getEmptySearch();
            if(all) {
                this.search0 = this.getEmptySearch();
                this.search1 = this.getEmptySearch();
                this.search2 = this.getEmptySearch();
            } else {
                this["search" + this.statustab] = this.search;
            }
            this.getList();
        },
        tableHeaderColor({ row, column, rowIndex, columnIndex }) {
            if (rowIndex === 0) {
                return 'background-color: #F5F5F5;color: #2F2F2F;font-size: 14px;font-weight:400;'
            }
        },
        opSearch() {
            this.search.currentPage = 1;
            this.search.total = 0;
            this.getList();
        },
        getList() {
            var self = this;
            var params = this.getParams();
            params.status = this.statustab.toString();
            this.$root.postReq("/web/ejobCtl/allJobs", {
                search: params
            }).then(function (d) {
                if (d.status == 0) {
                    self.search.list = d.data.rows || [];
                    self.search.total = d.data.count || 0;
                } else {
                }
            });
        },
        getParams() {
            var params = {};
            for(var f in this.search) {
                if(f == "list") {
                    continue;
                }
                params[f] = this.search[f];
            }
            return params;
        },
        onColFormater(row, column, cellValue, index) {
            return cellValue || "---";
        },
        getJobDetail(id) {
            var self = this;
            self.$root.postReq("/web/ejobCtl/jobInfo", {
                jobId: id,
                pattern: {
                    datePattern : "YYYY-MM-DD HH:mm:ss",
                    timesPattern : "YYYY.MM.DD"
                }
            }).then(function (d) {
                if (d.status == 0) {
                    self.jobDetail = d.data;
                    self.showDetail = true;
                } else {
                    self.$message.warning(d.msg || `您的网络不稳定, 请稍后重试`);
                }
            });
        },
        toaudit(id) {
            this.isAudit = true;
            this.auditRemark = "";
            this.auditStatus = "1";
            this.auditJobId = id;
            this.detailTitle = "需求审核";
            
            this.getJobDetail(id);
        },
        toDetail(id) {
            this.detailTitle = "查看详情";
            this.isAudit = false;
            this.getJobDetail(id);
        },
        handleSizeChange(val) {
            this.search.pageSize = val;
            this.resetSearch();
        },
        handleCurrentChange(val) {
            this.search.currentPage = val;
            this.getList();
        },
        showApplys(item) {
            this.$root.pushx({
                title : "查看详情",
                name : "/ejoballapplys",
                params: {ejobId: item.id},
            });
        },
        audit() {
            var self = this;
            if(self.auditStatus == '2' && !self.auditRemark) {
                self.$message.warning(`请填写驳回原因`);
                return;
            }
            self.$root.postReq("/web/ejobCtl/audit", {
                jobId: self.auditJobId,
                auditStatus: self.auditStatus,
                auditRemark: self.auditRemark,
            }).then(function (d) {
                self.auditLoading = false;
                if (d.status == 0) {
                    self.$message.success(`审核成功`);
                    self.getList();
                    self.showDetail = false;
                } else {
                    self.$message.warning(d.msg || `您的网络不稳定, 请稍后重试`);
                }
            });
            setTimeout(() => {
                self.auditLoading = false;
            }, 5000);
        },
    },
    vname: "gsb-ejoballmanager"
}