var system = require("../../../system")
const http = require("http")
const querystring = require('querystring');
var settings = require("../../../../config/settings");
const CtlBase = require("../../ctl.base");
const logCtl = system.getObject("web.common.oplogCtl");
const uuidv4 = require('uuid/v4');
var svgCaptcha = require('svg-captcha');

var cacheBaseComp = null;
class MerchanttradeprocessCtl extends CtlBase {
  constructor() {
    super("merchant", CtlBase.getServiceName(MerchanttradeprocessCtl));

    this.redisClient = system.getObject("util.redisClient");

    this.merchantSve = system.getObject("service.merchant.merchantSve");
  }

  async processList(pobj, pobj2, req) {
    try {
      var condition = {
        currentPage: pobj.currentPage,
        pageSize: pobj.pageSize,
        merchantId: pobj.merchantId,
        busiType: pobj.busiType,
        invoiceApplyNo: this.trim(pobj.invoiceApplyNo),
        createdBegin: this.trim(pobj.createdBegin),
        createdEnd: this.trim(pobj.createdEnd),
      }

      this.doTimeCondition(condition, ["createdBegin", "createdEnd"]);

      var page = await this.service.pageByCondition(condition);
      return system.getResultSuccess(page);
    } catch (error) {
      console.log(error);
      return system.getResultFail(500, "接口异常：" + error.message);
    }
  }



  // try {
  // } catch (error) {
  //   return system.getResultFail(500, "接口异常：" + error.message);
  // }


}
module.exports = MerchanttradeprocessCtl;