const system = require("../../../system");
const ServiceBase = require("../../svems.base");
const settings = require("../../../../config/settings");
const PROVINCE_CODE_MAP = require("../../../utils/province/province.js");
var moment = require('moment');
class InvoiceService extends ServiceBase {
  constructor() {
    super();
    this.userSve = system.getObject("service.uc.userSve");
  }
  async processDics(params) {
    var rs = await this.callms("invoice", "processDics", params);
    return rs;
  }

  async invoiceApply(params) {
    var rs = await this.callms("invoice", "invoiceApply", params);
    return rs;
  }

  async invoicePage(params) {
    params.currentPage = Number(params.currentPage || 1);
    params.pageSize = Number(params.pageSize || 10);

    var rs = await this.callms("invoice", "invoicePage", params);
    if (rs.data && rs.data.rows) {
      for (let item of rs.data.rows) {
        item.invoice_amount = system.f2y(item.invoice_amount);
      }
    }
    return rs;
  }


  async deliverInvoicePage(params) {
    params.currentPage = Number(params.currentPage || 1);
    params.pageSize = Number(params.pageSize || 10);
    var rs = await this.callms("invoice", "deliverInvoicePage", params);
    if (rs.data && rs.data.rows) {
      for (let item of rs.data.rows) {
        item.invoice_amount = system.f2y(item.invoice_amount);
      }
    }
    return rs;
  }

  async handleStatus(params) {
    return await this.callms("invoice", "handleStatus", params);
  }

  async invoice(params) {
    var rs = await this.callms("invoice", "invoice", params);
    await this.setUcUser([rs.data]);
    return rs;
  }

  async setUcUser(rows) {
    if (!rows || rows.length == 0) {
      return;
    }

    let ids = [];
    for (let row of rows) {
      if (row.bd_id) {
        ids.push(row.bd_id);
      }
      if (row.assign_user_id) {
        ids.push(row.assign_user_id);
      }
    }

    let userRs = await this.userSve.mapByIds({ ids: ids });
    let userMap = userRs.data || {};

    for (let row of rows) {
      let user = userMap[row.bd_id] || {};
      row.bd_name = user.realName || "";

      let assignUser = userMap[row.assign_user_id] || {};
      row.assign_user_name = assignUser.realName || "";
    }
  }

  /**
   * fn:为了对接财务宝 格式化发票类型
   * 
   * @param {*} invoice_type 
   */
  formatInvoiceType (invoicesummaryinfo){
    let _billType = null;
    if(!invoicesummaryinfo.invoice_type){
      return system.getResult(null,`系统错误 发票类型错误`);
    }
    if(invoicesummaryinfo['invoice_type']=='10'){
      _billType = `1`;
    }else if(invoicesummaryinfo['invoice_type']=='20'){
      _billType = `2`;
    }else if(invoicesummaryinfo['invoice_type']=='30'){
      _billType = `0`;
    }else{
      return system.getResult(null,`系统错误 发票类型错误`);
    }
    return _billType;
  }

  /**
   * fn:为了对接财务宝 格式化发票联次
   * 
   * @param {*} invoice_type 
   */
  formatInvoiceJoin (invoicesummaryinfo){
    let invoiceOrder = null;
    if(!invoicesummaryinfo.invoice_join){
      return system.getResult(null,`系统错误 发票联次错误`);
    }
    if(invoicesummaryinfo['invoice_join']=='10'){
      invoiceOrder = `3`;
    }else if(invoicesummaryinfo['invoice_join']=='20'){
      invoiceOrder = `0`;
    }else if(invoicesummaryinfo['invoice_join']=='30'){
      invoiceOrder = `1`;
    }else if(invoicesummaryinfo['invoice_join']=='40'){
      invoiceOrder=`2`;
    }else{
      return system.getResult(null,`系统错误 发票类型错误`);
    }
    return invoiceOrder;
  }

  /**
   * fn:为了对接财务宝 格式化发票摘要
   * @param {*} invoicesummaryinfo 
   */
  formatSummary(invoicesummaryinfo){
    if(!invoicesummaryinfo.summary){
      return system.getResult("系统错误 发票摘要信息错误");
    }
    let _res = [];
    for(let item of invoicesummaryinfo.summary){
      // item = JSON.parse(item);
      let temp = {
        abstractMsg:item.summaryInfo,
        attr:{"standard":item.category,"unit":item.unit,"number":item.number,"unit_price":item.unitPrice},
        amount:item.amount,
        tax:item.taxAmount,
        totalPrice:Number(item.amount)+Number(item.taxAmount),
        taxRate:item.taxRate,
        abstractType:item.summaryType
      };
      _res.push(temp);
    }
    return _res;
  }
  /**
   * fn:提交发票道财税系统
   * @param {*} invoice_id 
   */
  async uploadDetail(invoice_id){
    let invoice = await this.callms("invoice", "invoice", {id:invoice_id});
    if(!invoice || !invoice.data){
      return system.getResult(`发票不存在`);
    }
    //获取个体户信息 拿到customer  在order服务下  参数：通过merchant_credit_code或者是merchant_id (购买方商户)
    if(!invoice.data.invoicesummaryinfo ||!invoice.data.invoicesummaryinfo.businessmen_credit_code ){
      return system.getResult(`发票信息错误`);
    }
    let businessmen = await this.callms("order", "queryObusinessmenByCreditCode", {credit_code:invoice.data.invoicesummaryinfo.businessmen_credit_code});
    //获取交付商信息 拿到companyID  在common服务下 参数：通过deliver_id
    if(!invoice.data.deliver_id){
      return system.getResult(`交付商不存在`);
    }
    var deliver = await this.callms("common", "deliverInfo", {id: invoice.data.deliver_id});
    if(!deliver.data ){
      return system.getResult(null,`交付商不存在`);
    }
    if(!deliver.data.nt_company_id){
      return system.getResult(null,`个体户还未建账，请先建账`);
    }
    let _params=await this.buildParams(businessmen.data,invoice.data,deliver.data) || {};
    try {
      if(!_params){
        console.log("推送失败，参数错误");
        return system.getResult("推送失败，参数错误");
      }
      let url = settings.ntapi().uploadDetail;
      let res = await this.callApi(url, _params, "提交发票");
      console.log(res);
      if(!res || res.code!='000000') {
        return system.getResult(null, "提交发票失败");
      }
      //更新发票建账
      await this.callms("invoice", "uploadDetail", {id:invoice_id});
      return system.getResultSuccess();
    } catch (error) {
       console.log(error);
       return system.getResult(null,`系统错误 推送失败`); 
    }
  }
  // http://nga-api.gongsibao.com/nga-api/uploadDetail		
  /**
   * 推送票据
   */
  async buildParams(businessmen,invoice,deliver){
    try {
      let _invoicesummaryinfo = invoice.invoicesummaryinfo || null;
      if(!_invoicesummaryinfo){
        return system.getResult(null, `系统错误 发票信息错误`);
      }
      let params = {
        companyId:deliver.nt_company_id,                                           //公司ID
        customerId:businessmen.customer_id,                                        //客户ID
        uploadPeriod:moment(businessmen.create_account_time).format('YYYYMM'),     //上传账期
        imageName: invoice['invoice_img'].slice(invoice['invoice_img'].lastIndexOf("/")+1,-1) ||"",   //图片名称
        imageBasename:invoice['invoice_img'] || "",                                //图片url
        billType:this.formatInvoiceType(_invoicesummaryinfo),                           //发票类型
        isDaikai:`1`,                                                              //是否代开 1:yes  0:no                                                        
        signDate:moment(_invoicesummaryinfo.invoice_time).format("YYYY-MM-DD"),    //开票时间
        invoiceCode:_invoicesummaryinfo.invoice_no,                                //发票代码
        invoiceNumber:_invoicesummaryinfo.invoice_number,                          //发票号码
        invoiceOrder:this.formatInvoiceJoin(_invoicesummaryinfo),                       //发票联次
        payName:_invoicesummaryinfo.merchant_name,
        receiveName:_invoicesummaryinfo.businessmen_name,
        payBank:_invoicesummaryinfo.merchant_bank,
        payAccount:_invoicesummaryinfo.merchant_account,
        payTel:_invoicesummaryinfo.merchant_mobile,
        payAddress:_invoicesummaryinfo.merchant_addr,
        payAccountAame:"",                                                         //xxxx
        payerTaxIdentificationNumber:_invoicesummaryinfo.merchant_credit_code,          
        receiveBank:_invoicesummaryinfo.businessmen_bank,
        receiveAccount:_invoicesummaryinfo.businessmen_account,
        receiveTel:_invoicesummaryinfo.businessmen_mobile,
        receiveAddress:_invoicesummaryinfo.businessmen_addr,
        receiveTaxIdentificationNumber:_invoicesummaryinfo.businessmen_credit_code,
        province:PROVINCE_CODE_MAP[_invoicesummaryinfo.province],
        receiveAccountName:"",                                                     //xxxx
        sourceClient:"0",                                                          //票据来源
        createDate:moment(_invoicesummaryinfo.created_at).format("YYYY-MM-DD HH:ss:mm"),    //创建时间
        // createDate:new Date(_invoicesummaryinfo.created_at),    //创建时间
        list:this.formatSummary(_invoicesummaryinfo)
      }  
      return params;
    } catch (error) {
      console.log(error);
      return {};
    }
  }


  
}
module.exports = InvoiceService;