const system = require("../../../system");
const Dao = require("../../dao.base");

class WorkloadDao extends Dao {
  constructor() {
    super(Dao.getModelName(WorkloadDao));
  }

  async countHistory(params) {
    var sql = [];
    sql.push("SELECT COUNT(DISTINCT(id_nu)) AS num FROM `workload_info` WHERE status = 1");
    this.setCondition(sql, params);

    let rs = await this.customQuery(sql.join(" "), params);
    if (!rs || rs.length == 0) {
      return 0;
    }

    return rs[0].num || 0;
  }

  async pageHistory(params) {
    var sql = [];
    sql.push("SELECT");
    sql.push("`id`, `username`, `iphone`, `id_nu`, `card_nu`, `send_amount`,");
    sql.push("`created_at`, `updated_time`, `workload`, ");
    sql.push("`created_time`, `updated_at`, `status`,");
    sql.push("sum(send_amount) AS allAmount, COUNT(1) AS times");
    sql.push("FROM `workload_info`");
    sql.push("WHERE status = 1");
    this.setCondition(sql, params);

    sql.push("GROUP BY id_nu");
    sql.push("LIMIT :startRow, :pageSize");
    return await this.customQuery(sql.join(" "), params);
  }

  async findByIdNo(params) {
    var sql = [];
    sql.push("SELECT");
    sql.push("`id`, `username`, `iphone`, `id_nu`, `card_nu`, `send_amount`,");
    sql.push("`created_at`, `updated_time`, `workload`, ");
    sql.push("`created_time`, `updated_at`, `status`");
    sql.push("FROM `workload_info`");
    sql.push("WHERE id_nu = :id_nu AND user_id = :user_id");
    return await this.customQuery(sql.join(" "), params);
  }

  setCondition(sql, params) {
    if (params.user_id) {
      sql.push("AND user_id = :user_id");
    }
    if (params.username) {
      sql.push("AND username = :username");
    }
    if (params.iphone) {
      sql.push("AND iphone = :iphone");

    }
    if (params.id_nu) {
      sql.push("AND id_nu = :id_nu");
    }
  }
}

module.exports = WorkloadDao;
