const system=require("../../../system");
const Dao=require("../../dao.base");
class RecruitDao extends Dao{
  constructor(){
    super(Dao.getModelName(RecruitDao));
  }

  async findListByName(obj){//获取岗位名称招聘信息，返回符合条件的列表
    if (!obj.recruit_name){
      return system.getResult(null,"参数错误!");
    }
    var recruit_name = obj.recruit_name;
    var pageSize=obj.page_size || 10;
    var currentPage=obj.current_page || 1;
    try {
      var sql = "SELECT * FROM recruit_info WHERE recruit_name LIKE :name order by publish_date desc limit :one,:two";
      var list = await this.customQuery(sql, {name : "%" + recruit_name + "%",one:(currentPage - 1) * pageSize,two:pageSize}) || [];
      return system.getResult(list);
    }catch (e) {
      console.log(e);
      return system.getResult(null,"操作失败");
    }
  }

   //更新审核状态 
  async updatestatus(id, cur_type, t) {
    var sql = [];
    var cur_status = "";
    if (cur_type == 1){
      cur_status = "展示中";
    }
    else if (cur_type == 2){
      cur_status = "已下架";
    }
    else if (cur_type == 3){
      cur_status = "已过期";
    }
    else if (cur_type == 4){
      cur_status = "审核未通过";
    }
    // UPDATE xgg_merchant_account SET available_amt = available_amt - :amt, frozen_amt = frozen_amt + :amt WHERE id = 1 AND available_amt - :amt >= 0
    sql.push("UPDATE");
    sql.push("recruit_info");
    sql.push("SET");
    sql.push("cur_type = :cur_type, cur_status = :cur_status");
    sql.push("WHERE id = :id");
    return await this.customUpdate(sql.join(" "), {
      id: id,
      cur_type: cur_type,
      cur_status: cur_status,
    }, t);
  }

}
module.exports=RecruitDao;

