const system = require("../../../system");
const Dao = require("../../dao.base");

class TaxinfoDao extends Dao {
  constructor() {
    super(Dao.getModelName(TaxinfoDao));
  }

  async statCount(companyNames) {
    var result = {};
    if (!companyNames || companyNames.length == 0) {
      return result;
    }
    var sql = "SELECT company_name, COUNT(1) AS num FROM `tax_info` WHERE company_name IN (:companyNames) GROUP BY name";

    let list = await this.customQuery(sql, {companyNames: companyNames});

    if (list || list.length == 0) {
      return result;
    }

    for (var item of list) {
      result[item.company_name] = item.num || 0;
    }
    return result;
  }

  async statCounts(companyNames) {
    var result = {};
    if (!companyNames || companyNames.length == 0) {
      return result;
    }
    var sql = "SELECT company_name, SUM(actual_amount) AS num FROM `tax_info` WHERE company_name IN (:companyNames) GROUP BY name";

    let list = await this.customQuery(sql, {companyNames: companyNames});

    if (list || list.length == 0) {
      return result;
    }

    for (var item of list) {
      result[item.company_name] = item.num || 0;
    }
    return result;
  }

  async sCount(idno) {
    var result = {};
    if (!idno || idno.length == 0) {
      return result;
    }
    var sql = "SELECT id_no, COUNT(1) AS num FROM `tax_info` WHERE id_no IN (:idno) GROUP BY name";

    let list = await this.customQuery(sql, {idno: idno});

    if (list || list.length == 0) {
      return result;
    }

    for (var item of list) {
      result[item.id_no] = item.num || 0;
    }
    return result;
  }

  async sCountS(inno) {
    var result = {};
    if (!inno || inno.length == 0) {
      return result;
    }
    var sql = "SELECT id_no, SUM(actual_amount) AS num FROM `tax_info` WHERE company_name IN (:inno) GROUP BY name";

    let list = await this.customQuery(sql, {inno: inno});

    if (list || list.length == 0) {
      return result;
    }

    for (var item of list) {
      result[item.id_no] = item.num || 0;
    }
    return result;
  }

  async countByUser(params) {
    var sql = [];
    sql.push("SELECT COUNT(DISTINCT(id_no)) AS num FROM `tax_info` WHERE 1 = 1");
    this.setCondition(sql, params);

    let rs = await this.customQuery(sql.join(" "), params);
    if (!rs || rs.length == 0) {
      return 0;
    }
    return rs[0].num || 0;
  }

  async pageByUser(params) {
    var sql = [];
    sql.push("SELECT");
    sql.push("*,");
    // sql.push("`id`, `company_name`, `usc_code`, `name`, `id_no`, `actual_amount`, `income_tax`,");
    // sql.push("`tax_time`, `sign_body`, `tax_url`, `created_at`, `updated_at`, `deleted_at`,");
    // sql.push("`version`, `redundance_1`, `redundance_2`, `redundance_3`, `redundance_4`,");
    sql.push("count(1) AS times");
    sql.push("FROM `tax_info`");
    sql.push("WHERE 1 = 1");
    this.setCondition(sql, params);

    sql.push("GROUP BY id_no");
    sql.push("LIMIT :startRow, :pageSize");
    return await this.customQuery(sql.join(" "), params);
  }

  async byIdNo(idNo) {
    var sql = [];
    sql.push("SELECT");
    sql.push("*");
    sql.push("FROM `tax_info`");
    sql.push("WHERE id_no = :idNo");
    return await this.customQuery(sql.join(" "), {idNo: idNo});
  }

  setCondition(sql, params) {
    if (params.user_id) {
      sql.push("AND user_id = :user_id");
    }
    if (params.idNo) {
      sql.push("AND id_no = :idNo");
    }
    if (params.name) {
      sql.push("AND name = :name");
    }
  }
}

module.exports = TaxinfoDao;