const system=require("../../../system");
const Dao=require("../../dao.base");
class TransactioninfoDao extends Dao{
    constructor(){
        super(Dao.getModelName(TransactioninfoDao));
    }

    async findListByIdno(obj){//获取岗位名称招聘信息，返回符合条件的列表
      var id_no = obj.id_no;
      var pageSize=obj.page_size;
      var currentPage=obj.current_page;
      try {
        var sql = "SELECT * FROM transaction_info WHERE id_no =:name order by transaction_time desc limit :one,:two";
        var list = await this.customQuery(sql, {name:id_no,one:(currentPage - 1) * pageSize,two:pageSize}) || [];
        return system.getResult(list);
      }catch (e) {
        console.log(e);
        return system.getResult(null,"操作失败");
      }
  }
}
module.exports=TransactioninfoDao;
