const system = require("../../../system");
const Dao = require("../../dao.base");

class UserlabourDao extends Dao {
  constructor() {
    super(Dao.getModelName(UserlabourDao));
  }

  async findLabourIdsByUserId(userId) {
    var sql = "select labour_id from user_labour where user_id = :userId";
    var list = await this.customQuery(sql, {userId: userId});

    var result = [];
    if(list) {
      for (var item of list) {
        result.push(item.labour_id);
      }
    }
    return result;
  }

  async findMapByUserIds(userIds) {
    var result = {};
    if (!userIds || userIds.length == 0) {
      return result;
    }

    var sql = "select user_id, labour_id from user_labour where id user_id (:userIds)";
    var list = await this.customQuery(sql, {userIds: userIds});
    if (!list || list.length == 0) {
      return result;
    }

    for (var item of list) {
      var lst = result[item.id];
      if(!lst) {
        lst = [];
      }
      lst.push(item.labour_id);
      result[item.id] = lst;
    }
    return result;
  }
}

module.exports = UserlabourDao;

// var tesk = new UsersDao();
// var res = tesk.nameList();
// console.log(res);
