const system = require("../../../system");
const ServiceBase = require("../../sve.base");
const settings = require("../../../../config/settings");
/**
 * 招聘信息
 */
class RecruitService extends ServiceBase {
  constructor() {
    super("operator", ServiceBase.getDaoName(RecruitService));
    this.usersDao = system.getObject("db.operator.usersDao");
    //this.restClient = system.getObject("util.restClient");
  }

  async SaveRecruitInfo(params){//添加或更新招聘信息
    var id = params.id;
    var recruit;
    if (id){
      recruit = await this.dao.findById(id);
      recruit.recruit_name = params.recruit_name;
      recruit.recruit_type = params.recruit_type;
      recruit.recruit_count = params.recruit_count;
      recruit.pay_type = params.pay_type;
      recruit.pay_name = params.pay_name;
      recruit.pay_unit = params.pay_unit;
      recruit.work_duration = params.work_duration;
      recruit.basic_salary = params.basic_salary;
      recruit.compre_salary = params.compre_salary;
      recruit.rfee_type = params.rfee_type;
      recruit.rfee_unit = params.rfee_unit;
      recruit.rfee_duration = params.rfee_duration;
      recruit.rfee_time = params.rfee_time;
      recruit.age_range = params.age_range;
      recruit.work_address = params.work_address;
      recruit.publish_date = params.publish_date;
      recruit.end_date = params.end_date;
      recruit.pic_path = params.pic_path;
      recruit.recrui_require = params.recrui_require;
      recruit.phone_no = params.phone_no;
      recruit.counter_mark = params.counter_mark;
      recruit.user_id = params.user_id;
      recruit.cur_type = params.cur_type;
      recruit.cur_status = params.cur_status;
      recruit = await recruit.save();
      recruit = await this.dao.findById(id);
    }
    else{
      recruit = await this.dao.create(params);
    }

    return system.getResultSuccess(recruit);
  }

  async findAllList(obj){//获取全部招聘信息，返回符合条件的列表
    var pageSize=obj.page_size || 10;
    var currentPage=obj.current_page || 1;
    try {
      var where = {};
      if(obj.userId) {
        where.user_id = obj.userId;
      }
      var sqlwhere = {
          order: [["publish_date", 'desc']],
          limit: pageSize,
          offset: (currentPage - 1) * pageSize,
          raw: true,
          where: where
      };
      //var list = await this.dao.model.findAll(sqlwhere);
      var list = await this.dao.model.findAndCountAll(sqlwhere) || [];
      return system.getResult(list);
    }catch (e) {
      console.log(e);
      return system.getResult(null,"操作失败");
    }
  }

  async findListByUserid(obj){//获取userid招聘信息，返回符合条件的列表
    if (!obj.user_id){
      return system.getResult(null,"参数错误!");
    }
    
    var user_id = obj.user_id;
    // var curStatus = obj.curStatus;//当前的状态
    var curType = obj.curType;//当前的状态

    let where={};
    if(user_id){
      where.user_id=user_id;
    }
    if(curType){
      where.cur_type=curType;
    }
    // if(curStatus){
    //   where.cur_status=curStatus;
    // }
    var pageSize=obj.page_size || 10;
    var currentPage=obj.current_page || 1;
    try {
      var sqlwhere = {
          where:where,
          order: [["publish_date", 'desc']],
          limit: pageSize,
          offset: (currentPage - 1) * pageSize,
          raw: true
      };
      var list = await this.dao.model.findAndCountAll(sqlwhere) || [];
      return system.getResult(list);
    }catch (e) {
      console.log(e);
      return system.getResult(null,"操作失败");
    }
  }

  /**
   * 更新上架 或下架
   */
  async UpdateCurStatus(params){
    try {
      let cur_type = params.curType;
      let id = Number(params.id);
      let data = {};
      //1:展示中、2:已下架、3:已过期、4:审核未通过 
      if(cur_type){
        data.cur_type=cur_type;
        if(cur_type==1){
          data.cur_status='展示中';
        }else if(cur_type==2){
          data.cur_status='已下架';
        }else if(cur_type==3){
          data.cur_status='已过期、4';
        }else if(cur_type==4){
          data.cur_status='审核未通过';
        }else{
          return system.getResult("参数错误 状态码不存在");
        }
      }
      let res = await this.dao.model.update(data,{where:{id:id}});
      return system.getResult(res);
    } catch (error) {
      return system.getResult(-1, `系统错误 错误信息 ${error}`);
    }
  }

  async findListByName(obj){//获取岗位名称招聘信息，返回符合条件的列表
    //return await this.dao.findListByName(obj);
    if (!obj.recruit_name){
      return system.getResult(null,"参数错误!");
    }
    var recruit_name = obj.recruit_name;
    var pageSize=obj.page_size || 10;
    var currentPage=obj.current_page || 1;
    try{
      var sqlwhere = {
        where:{recruit_name:{[this.db.Op.like]: "%" + recruit_name + "%"}},
        order: [["publish_date", 'desc']],
        limit: pageSize,
        offset: (currentPage - 1) * pageSize,
        raw: true
      };
      var list = await this.dao.model.findAndCountAll(sqlwhere) || [];
      return system.getResult(list);
    }
    catch{
      return system.getResult(null,"操作失败");
    }
  }

  async findListByMark(obj){//获取标签招聘信息，返回符合条件的列表
    if (!obj.counter_mark){
      return system.getResult(null,"参数错误!");
    }
    var counter_mark = obj.counter_mark;
    var pageSize=obj.page_size || 10;
    var currentPage=obj.current_page || 1;
    try {
      var sqlwhere = {
          where:{counter_mark:{[this.db.Op.like]: "%" + counter_mark + "%"}},
          order: [["publish_date", 'desc']],
          limit: pageSize,
          offset: (currentPage - 1) * pageSize,
          raw: true
      };
      var list = await this.dao.model.findAndCountAll(sqlwhere) || [];
      return system.getResult(list);
    }catch (e) {
      return system.getResult(null,"操作失败");
    }
  }

  async findListByAddress(obj){//获取工作地址招聘信息，返回符合条件的列表-用于同城好单
    if (!obj.work_address){
      return system.getResult(null,"参数错误!");
    }
    var work_address = obj.work_address;
    var pageSize=obj.page_size || 10;
    var currentPage=obj.current_page || 1;
    try {
      var sqlwhere = {
          where:{work_address:{[this.db.Op.like]: "%" + work_address + "%"}},
          order: [["publish_date", 'desc']],
          limit: pageSize,
          offset: (currentPage - 1) * pageSize,
          raw: true
      };
      var list = await this.dao.model.findAndCountAll(sqlwhere) || [];
      return system.getResult(list);
    }catch (e) {
      return system.getResult(null,"操作失败");
    }
  }

  async findRecruitByWhere(obj){//根据条件获取招聘信息
    var pageSize=obj.page_size || 10;
    var currentPage=obj.current_page || 1;
    var where = {};
    if (obj.id){
      where.id = obj.id;
    }
    if (obj.recruit_name){
      where.recruit_name = obj.recruit_name;
    }
    if (obj.recruit_type && obj.recruit_type != "全部"){
      where.recruit_type = obj.recruit_type;
    }
    if (obj.pay_name && obj.pay_name != "全部"){
      where.pay_name = obj.pay_name;
    }
    if (obj.rfee_type && obj.rfee_type != "全部"){
      if (obj.rfee_type == "面议"){
        where.rfee_type = 0;
      }
      else if (obj.rfee_type == "时返"){
        where.rfee_type = 3;
      }
      else if (obj.rfee_type == "月返"){
        where.rfee_type = 1;
      }
      else if (obj.rfee_type == "日返"){
        where.rfee_type = 2;
      }
      else if (obj.rfee_type == "一次返"){
        where.rfee_type = 4;
      }
    }
    if (obj.work_address && obj.work_address != "全部"){
      where.work_address = {[this.db.Op.like]: "%" + obj.work_address + "%"};
    }
    if (obj.user_id){
      where.user_id = obj.user_id;
    }
    
    if (obj.phone_no){
      where.phone_no = obj.phone_no;
    }
    if (obj.cur_status && obj.cur_status != "全部"){
      where.cur_status = obj.cur_status;
    }

    try {
      var sqlwhere = {
          where: where,
          order: [["publish_date", 'desc']],
          limit: pageSize,
          offset: (currentPage - 1) * pageSize,
          raw: true
      };
      var list = await this.dao.model.findAndCountAll(sqlwhere) || [];
      if(list) {
        await this.setUserInfo(list.rows);
      }
      return system.getResult(list);
    }catch (e) {
      console.log(e);
      return system.getResult(null,"操作失败");
    }

  }

  async setUserInfo(rows) {
    if (!rows || rows.length == 0) {
      return;
    }
    var ids = [];
    for (var row of rows) {
      ids.push(row.user_id);
    }
    var map = await this.usersDao.findUserInfoByids(ids);
    for (var row of rows) {
      row.userInfo = map[row.user_id] || {};
    }
  }

  async updatestatus(obj){//更新状态信息
    try{
      var whereobj = {where:{id: obj.id}};
      var setobj = {};
      setobj.cur_status = obj.cur_status;
      if (obj.cur_status == "展示中"){
        setobj.cur_type = 1;
      }
      else if (obj.cur_status == "已下架"){
        setobj.cur_type = 2;
      }
      else if (obj.cur_status == "已过期"){
        setobj.cur_type = 3;
      }
      else if (obj.cur_status == "审核未通过"){
        setobj.cur_type = 4;
      }

      var self = this;
      var v = await this.db.transaction(async function (t) {
        await self.dao.updateByWhere(setobj,whereobj,t);
      });
      
      return 1;
    }
    catch (e){
      console.log(e);
      return 0;
    }
  }
  /**
   * 删除用户下制定 招聘或这是供招信息记录
   * @param {*} params 
   */
  async RemRecOrLob(params){
    try {
      let res= await this.dao.model.destroy({
        where:{
          id:params.id,
          user_id:params.userId
        }
      });
      return system.getResult(res);
    } catch (error) {
      return system.getResult(-1, `系统错误 错误信息 ${error}`);
    }
  }
  /**
   * 定时刷新招聘
   */
  async UpdateRecruitExpired(){
    try {
      let nowTime=new Date();
      await this.dao.model.update({
        cur_type:3,
        cur_status:"已过期"
      },{
        where:{
          end_date:{
            [this.db.Op.between]: ["1970-01-02",nowTime ],
          }
        }
      });
      console.log(`定时更新成功`);
    } catch (error) {
      console.log(`系统错误 错误信息 ${error}`);
    }
  }

  async ParamRecruitExcel(obj) {//批量上传
    var resu = obj.dataList;
    try {
        await this.dao.model.bulkCreate(resu, {fields: ["recruit_name", "recruit_type", "recruit_count", "pay_type", "pay_name", 
        "pay_unit", "basic_salary", "compre_salary","work_duration","rfee_type","rfee_unit","rfee_duration","rfee_time","age_range",
        "work_address","publish_date","end_date","pic_path","recrui_require","phone_no","user_id","counter_mark","cur_type","cur_status"]});
        return 1;
    } catch (e) {
        console.log(e);
        return 0;
    }
  }

}
module.exports = RecruitService;

// var tesk = new RecruitService();
// var par = {
//   id:1,
//   cur_type:1,
//   recruit_name:"物流"
// };
// tesk.findListByName(par).then(function(result){
//   console.log((result));
// }).catch(function(e){
//   console.log(e);
// });
