const system = require("../../../system");
const ServiceBase = require("../../sve.base");
const settings = require("../../../../config/settings");
var moment = require('moment');

class TaxinfoService extends ServiceBase {
  constructor() {
    super("operator", ServiceBase.getDaoName(TaxinfoService));
  }

  /**
   * 按月查询
   * @param {*} params
   */
  async taxinfoListByMonth(params) {
    try {
      var currentPage = Number(params.currentPage || 1);
      var pageSize = Number(params.pageSize || 10);
      if (!params.userId) {
        return system.getResult(null, `参数错误 userId不能为空`);
      } else {
        params.user_id = this.trim(params.userId);
      }
      var where = {};

      if (params.curDate) {
        let curDate = this.trim(params.curDate);
        let maxDate = moment(curDate, "YYYY-MM").daysInMonth() // 29

        let beginTime = `${curDate}-01 00:00:00`;
        let endTime = `${curDate}-${maxDate} 23:59:59`;

        where.tax_time = {
          [this.db.Op.between]: [beginTime, endTime]
        };
      }
      where.user_id = params.user_id;
      var orderby = [
        ["id", 'desc']
      ];
      var page = await this.getPageList(currentPage, pageSize, where, orderby);
      if (page && page.rows) {
        for (var row of page.rows) {
          this.handleDate(row, ["tax_time"], null, -8);
        }
      }
      return system.getResult(page);
    } catch (error) {
      console.log(error);
      return system.getResult(-1, `系统错误 错误信息 ${error}`);
    }
  }

  /**
   * 按ren查询按照人信息
   * @param {*} params
   */
  async taxinfoListByUser(params) {
    try {
      params.currentPage = Number(params.currentPage || 1);
      params.pageSize = Number(params.pageSize || 10);

      let total = await this.dao.countByUser(params);
      if (total === 0) {
        let res = {count: 1, rows: []};
        return system.getResult(res);
      }
      params.startRow = (params.currentPage - 1) * params.pageSize;
      let list = await this.dao.pageByUser(params);
      if (list) {
        for (var item of list) {
          this.handleDate(item, ["tax_time"], null, -8);
        }
      }
      let res = {count: total, rows: list};
      return system.getResult(res);
    } catch (error) {
      console.log(error);
      return system.getResult(-1, `系统错误 错误信息 ${error}`);
    }
  }

  /**
   * 查询明细
   * @param {}} params
   */
  async taxinfoById(params) {
    try {
      if (!params.id) {
        return system.getResult(-1, `参数错误 ID不能为空`);
      }
      let info = await this.findById(this.trim(params.id));

      if (!info) {
        return system.getResultSuccess([]);
      }

      let list = await this.dao.byIdNo(info.id_no) || [];
      for (var row of list) {
        this.handleDate(row, ["tax_time"], null, -8);
      }
      return system.getResultSuccess(list);
    } catch (error) {
      console.log(error);
      return system.getResult(null, `系统错误 错误信息${error}`);
    }
  }

   /**
   * 根据身份证和年份查询明细
   * @param {}} params
   */
  async taxinfoListByIdnoAndYear(params) {
    if (!params.id_no && !params.tax_year ){
      return system.getResult(null,"参数错误!");
    }

    var where={};
    where.id_no=params.id_no;
    var beginTime = `${params.tax_year}-01-01 00:00:00`;
    var endTime = `${params.tax_year}-12-31 23:59:59`;

    where.tax_time = {
      [this.db.Op.between]: [beginTime, endTime]
    };
    try {
      var sqlwhere = {
          where:where,
          order: [["tax_time", 'desc']],
          raw: true
      };
      var list = await this.dao.model.findAndCountAll(sqlwhere) || [];
      return system.getResult(list);
    }catch (e) {
      console.log(e);
      return system.getResult(null,"操作失败");
    }
  }
}

module.exports = TaxinfoService;