const system = require("../../../system");
const ServiceBase = require("../../sve.base");
const settings = require("../../../../config/settings");

class TransactioninfoService extends ServiceBase {
    constructor() {
        super("operator", ServiceBase.getDaoName(TransactioninfoService));
    }

    async findListByIdno(obj){//根据身份证获取费用信息，返回符合条件的列表
        if (!obj.id_no){
            return system.getResult(null,"参数错误!");
        }
      
        var where={};
        where.id_no=obj.id_no;
        var pageSize=obj.page_size || 10;
        var currentPage=obj.current_page || 1;
        try {
            var sqlwhere = {
                where:where,
                order: [["transaction_time", 'desc']],
                limit: pageSize,
                offset: (currentPage - 1) * pageSize,
                raw: true
            };
            var list = await this.dao.model.findAndCountAll(sqlwhere) || [];
            return system.getResult(list);
          }catch (e) {
            console.log(e);
            return system.getResult(null,"操作失败");
          }
    }
}
module.exports = TransactioninfoService;
