const system = require("../../../system");
const ServiceBase = require("../../sve.base");
const settings = require("../../../../config/settings");

class UserlabourService extends ServiceBase {
  constructor() {
    super("operator", ServiceBase.getDaoName(UserlabourService));
    this.userlabourDao = system.getObject("db.operator.userlabourDao");
  }

  async SaveUserLabourInfo(params) {//添加或更新招聘信息
    var id = params.id;
    var userlabour;
    if (id) {
      userlabour = await this.dao.findById(id);
      userlabour.user_id = params.user_id;
      if (params.labour_id) {
        userlabour.labour_id = params.labour_id;
      }
      userlabour.recruit_id = params.recruit_id;
      userlabour.labour_user_id = params.labour_user_id;
      if (params.ecid) {
        userlabour.ecid = params.ecid;
      }
      userlabour.apply_stauts = params.apply_stauts;
      if (params.interview_time) {
        userlabour.interview_time = params.interview_time;
      }
      if (params.sign_at) {
        userlabour.sign_at = params.sign_at;
      }
      if (params.contract_url) {
        userlabour.contract_url = params.contract_url;
      }
      userlabour = await userlabour.save();
      userlabour = await this.dao.findById(id);
    } else {
      userlabour = await this.dao.create(params);
    }

    return system.getResultSuccess(userlabour);
  }

  async finduserlabourByWhere(obj) {//根据条件获取应聘信息
    var pageSize = obj.page_size || 10;
    var currentPage = obj.current_page || 1;
    var where = {};
    if (obj.id) {
      where.id = obj.id;
    }
    if (obj.user_id) {
      where.user_id = obj.user_id;
    }
    if (obj.labour_id) {
      where.labour_id = obj.labour_id;
    }
    if (obj.recruit_id) {
      where.recruit_id = obj.recruit_id;
    }
    if (obj.labour_user_id) {
      where.labour_user_id = obj.labour_user_id;
    }
    if (obj.ecid) {
      where.ecid = obj.ecid;
    }
    if (obj.apply_stauts) {
      where.apply_stauts = obj.apply_stauts;
    }

    try {
      var sqlwhere = {
        where: where,
        //order: [["publish_date", 'desc']],
        limit: pageSize,
        offset: (currentPage - 1) * pageSize,
        raw: true
      };
      var list = await this.dao.model.findAndCountAll(sqlwhere) || [];
      if (list) {
        return system.getResult(list);
      } else {
        return system.getResult(null, "没有应聘信息");
      }

    } catch (e) {
      console.log(e);
      return system.getResult(null, "操作失败");
    }

  }

  async updateStatus(obj) {//更新状态信息
    try {
      var whereobj = {where: {id: obj.id}};
      var setobj = {};
      if (obj.apply_stauts == "已申请") {
        setobj.apply_stauts = 10;
      } else if (obj.apply_stauts == "邀请面试") {
        setobj.apply_stauts = 20;
        setobj.interview_time = (new Date()).Format("yyyy-MM-dd");
      } else if (obj.apply_stauts == "面试成功") {
        setobj.apply_stauts = 30;
      } else if (obj.apply_stauts == "面试失败") {
        setobj.apply_stauts = 40;
      } else if (obj.apply_stauts == "待签约") {
        setobj.apply_stauts = 50;
      } else if (obj.apply_stauts == "签约成功") {
        setobj.apply_stauts = 60;
        setobj.sign_at = (new Date()).Format("yyyy-MM-dd");
      }

      var self = this;
      var v = await this.db.transaction(async function (t) {
        await self.dao.updateByWhere(setobj, whereobj, t);
      });

      return 1;
    } catch (e) {
      console.log(e);
      return 0;
    }
  }
}

module.exports = UserlabourService;

// var tesk = new UsersService();
// var par = {
//   // phone_no:"333",
//   // user_type:"招人方",
//   // status_type:1,
//   // status_name:"正常",
//   // reg_time:(new Date()).Format("yyyy-MM-dd")
//   id = 3
// };
// var user_id = 3; 
// tesk.findUserInfoByid(user_id).then(function(result){
//   console.log((result));
// }).catch(function(e){
//   console.log(e);
// });
