var APIBase = require("../../api.base");
var system = require("../../../system");
var settings = require("../../../../config/settings");
const uuidv4 = require('uuid/v4');
/**
 * icp通知接口（百度icp接入）
 * 庄冰 2020.10.22
 */
class Consultation extends APIBase {
    constructor() {
        super();
        this.gatewaypushlogSve = system.getObject("service.common.gatewaypushlogSve");
    }

    getUUID() {
        var uuid = uuidv4();
        var u = uuid.replace(/\-/g, "");
        return u;
    }
    getResultSuccess(requestId) {
        return {
        "status": 0,
        "msg": "success",
        "data":null,
        "requestId": requestId
        };
    }
    getResultFail(errmsg) {
        var self = this;
        return {
        "status":-1,
        "msg": errmsg,
        "requestId": self.getUUID(),
        "data":null,
        "bizmsg":"empty"
        };
    }

    //icp需求提交
    async submit(pobj,obj,req) {
        var self = this;
        if(!pobj.appInfo || !pobj.appInfo.uapp_key || !pobj.appInfo.uapp_secret){
            return self.getResultFail("未知应用或应用未启用");
        }
        if (!pobj.intentionBizId) {
            return self.getResultFail("intentionBizId不能为空");
        }
        if (!pobj.phone) {
            return self.getResultFail("mobile不能为空");
        }
        if (!pobj.consultType) {
            return self.getResultFail("consultType不能为空");
        }
        if (pobj.consultType=="ICP") {
            pobj.consultType="5";
        }
        if (pobj.consultType=="EDI") {
            pobj.consultType="7";
        }
        pobj.type = pobj.consultType;
        pobj.mobile = pobj.phone;
        pobj.action_type = "submitIcpNeed";
        if (pobj.area) {
            switch (pobj.area) {
                case "1":
                    pobj.area = "北京";
                    break;
                case "2":
                    pobj.area = "上海";
                    break;
                case "3":
                    pobj.area = "福建";
                    break;
                case "4":
                    pobj.area = "广西";
                    break;
                case "5":
                    pobj.area = "广东";
                    break;
                case "6":
                    pobj.area = "安徽";
                    break;
                case "7":
                    pobj.area = "河南";
                    break;
                case "8":
                    pobj.area = "湖北";
                    break;
                case "9":
                    pobj.area = "浙江";
                    break;
                case "10":
                    pobj.area = "江苏";
                    break;
                case "11":
                    pobj.area = "山东";
                    break;
                case "12":
                    pobj.area = "陕西";
                    break;
                case "13":
                    pobj.area = "宁夏";
                    break;
                case "14":
                    pobj.area = "甘肃";
                    break;
                case "15":
                    pobj.area = "新疆";
                    break;
                case "16":
                    pobj.area = "青海";
                    break;
                case "17":
                    pobj.area = "天津";
                    break;
                case "18":
                    pobj.area = "重庆";
                    break;
                case "19":
                    pobj.area = "河北";
                    break;
                case "20":
                    pobj.area = "山西";
                    break;
                case "21":
                    pobj.area = "辽宁";
                    break;
                case "22":
                    pobj.area = "吉林";
                    break;
                case "23":
                    pobj.area = "黑龙江";
                    break;
                case "24":
                    pobj.area = "江西";
                    break;
                case "25":
                    pobj.area = "湖南";
                    break;
                case "26":
                    pobj.area = "四川";
                    break;
                case "27":
                    pobj.area = "贵州";
                    break;
                case "28":
                    pobj.area = "云南";
                    break;
                case "29":
                    pobj.area = "内蒙古";
                    break;
                case "30":
                    pobj.area = "西藏";
                    break;
                case "31":
                    pobj.area = "含外资";
                    break;
                case "32":
                    pobj.area = "全外资";
                    break;
                case "33":
                    pobj.area = "香港";
                    break;
                case "34":
                    pobj.area = "海南";
                    break;
                case "BEIJING":
                    pobj.area = "北京";
                    break;
                case "SHANGHAI":
                    pobj.area = "上海";
                    break;
                case "FUJIAN":
                    pobj.area = "福建";
                    break;
                case "GUANGXI":
                    pobj.area = "广西";
                    break;
                case "GUANGDONG":
                    pobj.area = "广东";
                    break;
                case "ANHUI":
                    pobj.area = "安徽";
                    break;
                case "HENAN":
                    pobj.area = "河南";
                    break;
                case "HUBEI":
                    pobj.area = "湖北";
                    break;
                case "ZHEJIANG":
                    pobj.area = "浙江";
                    break;
                case "JIANGSU":
                    pobj.area = "江苏";
                    break;
                case "SHANDONG":
                    pobj.area = "山东";
                    break;
                case "SHANGXI_SHAN":
                    pobj.area = "陕西";
                    break;
                case "NINGXIA":
                    pobj.area = "宁夏";
                    break;
                case "GANSU":
                    pobj.area = "甘肃";
                    break;
                case "XINJIANG":
                    pobj.area = "新疆";
                    break;
                case "QINGHAI":
                    pobj.area = "青海";
                    break;
                case "TIANJIN":
                    pobj.area = "天津";
                    break;
                case "CHONGQING":
                    pobj.area = "重庆";
                    break;
                case "HEBEI":
                    pobj.area = "河北";
                    break;
                case "SHANXI_JIN":
                    pobj.area = "山西";
                    break;
                case "LIAONING":
                    pobj.area = "辽宁";
                    break;
                case "JINLIN":
                    pobj.area = "吉林";
                    break;
                case "HEILONGJIANG":
                    pobj.area = "黑龙江";
                    break;
                case "JIANGXI":
                    pobj.area = "江西";
                    break;
                case "HUNAN":
                    pobj.area = "湖南";
                    break;
                case "SICHUAN":
                    pobj.area = "四川";
                    break;
                case "GUIZHOU":
                    pobj.area = "贵州";
                    break;
                case "YUNNAN":
                    pobj.area = "云南";
                    break;
                case "NEIMENGGU":
                    pobj.area = "内蒙古";
                    break;
                case "XIZANG":
                    pobj.area = "西藏";
                    break;
                case "HANWAIZI":
                    pobj.area = "含外资";
                    break;
                case "QUANWAIZI":
                    pobj.area = "全外资";
                    break;
                case "XIANGGANG":
                    pobj.area = "香港";
                    break;
                case "HAINAN":
                    pobj.area = "海南";
                    break;
                default:
                    pobj.area = "";
                    break;
            }
        }
        if (!pobj.area) {
            return self.getResultFail("area参数错误");
        }
        var param = {
            requestId: req.requestId || self.getUUID(),
            requestUrl: "/icp/consultation/submit",
            requestjson: JSON.stringify(pobj),//请求地址
            pushUrl: "/action/intentionapi/springBoard",//调用地址
            pushActionType: "submitIcpNeed",//调用参数
            pushtimes: 0,//推送次数
            pushStatus: "wts",//推送状态
        }
        await self.gatewaypushlogSve.create(param);
        return self.getResultSuccess(param.requestId);
    }
}
module.exports = Consultation;