var APIBase = require("../../api.base");
var system = require("../../../system");
var settings = require("../../../../config/settings");
class edi extends APIBase {
  constructor() {
    super();
    this.centerorderSve = system.getObject("service.common.centerorderSve");
    this.utilsOrderSve = system.getObject("service.utilsSve.utilsOrderSve");
    this.utilsNeedSve = system.getObject("service.utilsSve.utilsNeedSve");
    this.utilsServiceSve = system.getObject("service.utilsSve.utilsServiceSve");
  }

  async create(pobj,query,req) {
    console.log(pobj);
    this.logCtl.info({
      op: "service/impl/utilsSve/service.js/create",
      content: "参数=" + JSON.stringify(pobj),
      clientIp: req.client_ip || "",
      optitle: "服务单创建接口 controller层"
    });
    // 校验必填 pannong 2.1
    var checkResult = await this.serviceCreateCheck(pobj,req.headers);
    if(checkResult.status != 0) {
      return checkResult;
    }
    var qobj = {appInfo:pobj.appInfo};
    qobj.actionBody = pobj;
    var result = await this.utilsServiceSve.submitService(qobj,qobj.actionBody,req);
    return result
  }

  async notify(pobj,query,req) {
    console.log(pobj);
    // 校验必填 pannong 2.1
    var checkResult = await this.serviceNotifyCheck(pobj,req.headers);
    if(checkResult.status != 0) {
      return checkResult;
    }
    var qobj = {appInfo:pobj.appInfo};
    qobj.actionBody = pobj;
    var result = await this.utilsServiceSve.notifyService(qobj,qobj.actionBody,req);
    return result
  }

  async notice(pobj,query,req) {
    console.log("/api/opreceive/service/notice",pobj)
    if(!pobj.actionType) {
      return system.getResult(null, "pobj.actionType cannot be empty");
    }
    var result = await this.utilsServiceSve.noticeService(pobj,pobj.actionBody,req);
    return result
  }

  async serviceCreateCheck(pobj,headers) {
    if(!headers.appkey) {
      return system.getResult(null, "headers.appkey cannot be empty");
    }
    if(!headers.sign) {
      return system.getResult(null, "headers.sign cannot be empty");
    }
    if(!pobj.bizId) {
      return system.getResult(null, "bizId cannot be empty");
    }
    if(!pobj.contactName) {
      return system.getResult(null, "contactName cannot be empty");
    }
    if(!pobj.contactMobile) {
      return system.getResult(null, "contactMobile cannot be empty");
    }
    if(!pobj.timeUnit) {
      return system.getResult(null, "timeUnit cannot be empty");
    }
    if(!pobj.quantity) {
      return system.getResult(null, "quantity cannot be empty");
    }
    if(!pobj.companyInfo) {
      return system.getResult(null, "companyInfo cannot be empty");
    }
    if(!pobj.companyInfo.corpName) {
      return system.getResult(null, "corpName cannot be empty");
    }
    if(!pobj.companyInfo.taxpayerTypeEnum) {
      return system.getResult(null, "taxpayerTypeEnum cannot be empty");
    }
    if(!pobj.companyInfo.acctgSystemId) {
      return system.getResult(null, "acctgSystemId cannot be empty");
    }
    if(!pobj.companyInfo.enterpriseFormEnum) {
      return system.getResult(null, "enterpriseFormEnum cannot be empty");
    }
    if(!pobj.companyInfo.taxIndustryId) {
      return system.getResult(null, "taxIndustryId cannot be empty");
    }
    if(!pobj.companyInfo.taxNo) {
      return system.getResult(null, "taxNo cannot be empty");
    }
    if(!pobj.companyInfo.serviceTypeEnum) {
      return system.getResult(null, "serviceTypeEnum cannot be empty");
    }
    if(!pobj.companyInfo.taxClaimMethodEnum) {
      return system.getResult(null, "taxClaimMethodEnum cannot be empty");
    }
    return system.getResultSuccess()
  }

  async serviceNotifyCheck(pobj,headers) {
    if(!headers.appkey) {
      return system.getResult(null, "headers.appkey cannot be empty");
    }
    if(!headers.sign) {
      return system.getResult(null, "headers.sign cannot be empty");
    }
    if(!pobj.bizId) {
      return system.getResult(null, "bizId cannot be empty");
    }
    if(!pobj.status) {
      return system.getResult(null, "status cannot be empty");
    }
    if(pobj.status != 4 && pobj.status != 8 && pobj.status != 16) {
      return system.getResult(null, "status error");
    }
    return system.getResultSuccess()
  }
}
module.exports = edi;