const system = require("../../../system");
var settings = require("../../../../config/settings");
const AppServiceBase = require("../../app.base");
//(文网文状态2020-9-26)
const wangwenStatusDisct = {
  601: "PARTNER_SUBMIT_MATERIAL",
  602: "CERT_ACCOUNT_REGISTERED",
  603: "CERT_MATERIAL_SUBMITTED",
  604: "CERT_GXB_ACCEPT",
  605: "CERT_GXB_REFUSE",
  606: "CERT_GXB_SUCCESS",
  607: "CERT_GXB_FAIL"
};
//区分渠道的uappid
const uappId = {
  'ali':"18",  //(阿里icp、edi)
  'baidu':"44"   //(百度icp、edi)
}
//tui song baidu zhuanyong pinyin 2020-11-6
const cityLetter = {
  "北京":"BEIJING",
  "上海":"SHANGHAI",
  "福建":"FUJIAN",
  "广西":"GUANGXI",
  "广东":"GUANGDONG",
  "安徽":"ANHUI",
  "河南":"HENAN",
  "湖北":"HUBEI",
  "浙江":"ZHEJIANG",
  "江苏":"JIANGSU",
  "山东":"SHANDONG",
  "陕西":"SHANXI_SHAN",
  "宁夏":"NINGXIA",
  "甘肃":"GANSU",
  "新疆":"XINJIANG",
  "青海":"QINGHAI",
  "天津":"TIANJIN",
  "重庆":"CHONGQING",
  "河北":"HEBEI",
  "山西":"SHANXI_JIN",
  "辽宁":"LIAONING",
  "吉林":"JILIN",
  "黑龙江":"HEILONGJIANG",
  "江西":"JIANGXI",
  "湖南":"HUNAN",
  "四川":"SUCHUAN",
  "贵州":"GUIZHOU",
  "云南":"YUANNAN",
  "内蒙古":"NEIMENGGU",
  "西藏":"XIZANG",
  "外资":"WAIZI",
  "海南":"HAINAN"
}

//baidu pinyinzhuanyong 2020-11-6
const baiduIcpStatus = {
  507: "REGISTRATION",
  508: "SUBMITTED",
  509: "ACCEPTED",
  510: "NOT_ACCEPTED",
  511: "APPROVED",
  512: "NOT_APPROVED"
};
/**
 * 资质信息提报相关接口(ICP\EDI)
 */
class BaseCenterOrderService extends AppServiceBase {
  constructor() {
    super();
    this.centerOrderUrl = settings.centerOrderUrl();
    this.execClient = system.getObject("util.execClient");
    this.aliclient = system.getObject("util.aliyunClient");
    this.cacheManager = system.getObject("db.common.cacheManager");
    this.utilsOrderSve = system.getObject("service.utilsSve.utilsOrderSve");
    this.utilsPushSve = system.getObject("service.utilsSve.utilsPushSve");
    this.utilsTmAliyunSve = system.getObject("service.utilsSve.utilsTmAliyunSve");//测试用
    this.opPushQueueUrl = settings.opPushQueueUrl();
    this.baiduclient = system.getObject("util.baiduClient");
  };
  //调用center-order 
  async reqCenterOrderApi(pobj, reqUrl) {
    var url = this.centerOrderUrl + "action/qcapi/springBoard";
    if (reqUrl) {
      var url = this.centerOrderUrl + reqUrl;
    }
    var rtn = await this.execClient.execPost(pobj, url);
    var data = JSON.parse(rtn.stdout);
    return data;
  }

  //提交Icp注册方案
  async submitIcpProgramme(pobj) {
    var res = await this.reqCenterOrderApi(pobj, "action/qcapi/springBoard");
    if (res && res.status == 0 && res.data && res.data.needinfo && res.data.needsolution) {
      var needinfo = res.data.needinfo;//需求信息
      var needsolution = res.data.needsolution;//方案信息
      var ab = pobj.actionBody;
      if (typeof (ab.solutionContent) == "string") {
        ab.solutionContent = JSON.parse(ab.solutionContent);
      }
      if (typeof (needsolution.solutionContent) == "string") {
        needsolution.solutionContent = JSON.parse(needsolution.solutionContent);
      }
      var solution = needsolution.solutionContent.solution;
      if(ab.isTest && ab.isTest==1){
        var reqPushParams = {
          actionBody: {
            uapp_id:needinfo.uapp_id,
            channelNeedNo:needinfo.channelNeedNo,
            CompanyName:solution.CompanyName,
            IcpType:solution.IcpType,
            CompanyAddress:solution.CompanyAddress,
            Area:solution.Area,
            Note: solution.Note,
            ActionType:solution.ActionType,
            channelSolutionNo:needsolution.channelSolutionNo,
            solutionNo:needsolution.solutionNo,
          },
          appInfo: pobj.appInfo
        };
        await this.utilsPushSve.business2Channel(reqPushParams, "pushIcpSolution2Channel");
      }else{
        var self = this;
        //2020-10-26 laolan 区分百度与阿里
        if(needinfo.uapp_id == uappId.ali){
          //推送数据至阿里
          // var bizType = needinfo.channelTypeCode;//业务类型里
          var pushObj = {
            IntentionBizId: needinfo.channelNeedNo,
            CompanyName: solution.CompanyName, 
            IcpType: solution.IcpType, 
            CompanyAddress: solution.CompanyAddress,
            Area: solution.Area, 
            Note: solution.Note,
            ActionType:solution.ActionType,
            Source:"官网"
          };
          if (needsolution.channelSolutionNo) {
            pushObj["BizId"] = needsolution.channelSolutionNo;
          }
          var pushIcpSolutionRes = await this.pushIcpSolution(pushObj, needsolution.solutionNo, pobj.appInfo, self);
        }
  
        if(needinfo.uapp_id == uappId.baidu){
          //推送数据至baidu
          // var bizType = needinfo.channelTypeCode;//业务类型里
          solution.Area = cityLetter[solution.Area]
          console.log('solution.Area++',solution.Area)
          var pushObj = {
            requirementId: needinfo.channelNeedNo,
            companyName: solution.CompanyName,
            companyAddress: solution.CompanyAddress,
            area: solution.Area, 
            type:solution.IcpType
          };
          if (needsolution.channelSolutionNo) {
            pushObj["bizId"] = needsolution.channelSolutionNo;
          }
          console.log('pushObj++',pushObj)
          var pushIcpSolutionRes = await this.pushBaiduIcpSolution(pushObj, needsolution.solutionNo, pobj.appInfo, self);
        }
        this.logCtl.info({
          appid: pobj.appInfo ? pobj.appInfo.uapp_id || "" : "",
          appkey: pobj.appInfo ? pobj.appInfo.uapp_key || "" : "",
          requestId: pobj.requestId || "",
          op: "service/impl/common/qcCenterOrderSve.js/submitIcpProgramme",
          content: JSON.stringify(pobj),
          resultInfo: JSON.stringify(needinfo),
          optitle: "createSolution推送蜂擎获取的接口信息->aliBusiness2Delivery",
        });
      }
      
      var reqParams = {
        actionBody: {
          intentionBizId: needinfo.channelNeedNo,
          status: "createSolution"
        },
        appInfo: pobj.appInfo
      }
      await this.utilsPushSve.aliBusiness2Delivery(reqParams, "updateChanceStatus");
      // 
      // return system.getResultSuccess(pushIcpSolutionRes);
    }
    return res;
  }

  //推送ICP方案至渠道方
  async pushIcpSolution2Channel(pobj){
    var actionBody = pobj.actionBody;
    var appInfo = pobj.appInfo;
    var pushRes = {
      status:-1,msg:"推送失败"
    };
    var self = this;
    if(actionBody){
      //2020-10-26 laolan 区分百度与阿里
      if(actionBody.uapp_id == uappId.ali){
        //推送数据至阿里
        var pushObj = {
          IntentionBizId: actionBody.channelNeedNo,
          CompanyName: actionBody.CompanyName, 
          IcpType: actionBody.IcpType, 
          CompanyAddress: actionBody.CompanyAddress,
          Area: actionBody.Area, 
          Note: actionBody.Note,
          ActionType:actionBody.ActionType,
          Source:"官网"
        };
        if (actionBody.channelSolutionNo) {
          pushObj["BizId"] = actionBody.channelSolutionNo;
        }
        pushRes = await this.pushIcpSolution(pushObj, actionBody.solutionNo, actionBody.appInfo, self);
      }
      if(actionBody.uapp_id == uappId.baidu){
        //推送数据至baidu
        actionBody.Area = cityLetter[actionBody.Area];
        var pushObj = {
          requirementId: actionBody.channelNeedNo,
          companyName: actionBody.CompanyName,
          companyAddress: actionBody.CompanyAddress,
          area: actionBody.Area, 
          type:actionBody.IcpType
        };
        if (actionBody.channelSolutionNo) {
          pushObj["bizId"] = actionBody.channelSolutionNo;
        }
        pushRes = await this.pushBaiduIcpSolution(pushObj, actionBody.solutionNo, actionBody.appInfo, self);
      }
      this.logCtl.info({
        appid: pobj.appInfo ? pobj.appInfo.uapp_id || "" : "",
        appkey: pobj.appInfo ? pobj.appInfo.uapp_key || "" : "",
        requestId: pobj.requestId || "",
        op: "app/base/service/impl/common/baseCenterOrderSve.js/pushIcpSolution2Channel",
        content: JSON.stringify(pobj),
        resultInfo: JSON.stringify(pushRes),
        optitle: "pushIcpSolution2Channel推送ICP方案至渠道方->pushIcpSolution2Channel",
      });
    }
    if(pushRes.status==0 || pushRes.status==1 ){
      return system.getResultRedisQueueSuccess();
    }
    return pushRes;
  }

  //推送ICP方案ali
  async pushIcpSolution(pushObj, solutionNo, appInfo, self) {
    //推送方案信息
    var pushRes = await self.aliclient.reqbyget({ action: "SubmitIcpSolution", reqbody: pushObj, apiVersion: "2019-05-08" });
    if (pushRes && pushRes.status == 0 && pushRes.data) {
      var resData = pushRes.data;
      if (resData.BizId) {
        var reqObj2 = {
          actionType: "receiveProgrammeNo",
          appInfo: appInfo,
          actionBody: {
            solutionNo: solutionNo,
            solutionBizId: resData.BizId
          }
        };
        var a = await self.reqCenterOrderApi(reqObj2);//保存渠道方案id
        if (a && a.status == 0) {
          //推送方案确认信息
          var confirmRes = await self.aliclient.reqbyget({ action: "ConfirmIntention", reqbody: { BizId: pushObj.IntentionBizId }, apiVersion: "2019-05-08" });
          if (confirmRes && confirmRes.status == 0 && confirmRes.data) {
            var confirmResData = confirmRes.data;
            if (confirmResData.ConfirmUrl) {
              var reqObj3 = {
                actionType: "receiveIcpConfirmUrl",
                appInfo: appInfo,
                actionBody: {
                  solutionNo: solutionNo,
                  confirmUrl: confirmResData.ConfirmUrl
                }
              };
              var a = await self.reqCenterOrderApi(reqObj3);//保存用户确认方案url
            }
          }
          // return confirmRes;
        }
      }
    }
    return pushRes;
  }

  //推送ICP方案baidu 2020-10-26 laolan
  async pushBaiduIcpSolution(pushObj, solutionNo, appInfo, self) {
    console.log('pushObj++baidu+++',pushObj)
    //推送方案信息
    var pushRes = await self.baiduclient.baiduReqbyget({  path: "/api/bla/provider/plan", reqbody: pushObj });
    console.log("pushRes++++",pushRes)
    if (pushRes && pushRes.status == 0 && pushRes.data) {
      var resData = pushRes.data;
      if (resData.planId) {
        var reqObj2 = {
          actionType: "receiveProgrammeNo",
          appInfo: appInfo,
          actionBody: {
            solutionNo: solutionNo,
            solutionBizId: resData.planId
          }
        };
        var a = await self.reqCenterOrderApi(reqObj2);//保存渠道方案id
        console.log("保存渠道方案id aaaa++ ",a)
        if (a && a.status == 0 && resData.path) {
          var reqObj3 = {
            actionType: "receiveIcpConfirmUrl",
            appInfo: appInfo,
            actionBody: {
              solutionNo: solutionNo,
              confirmUrl: resData.path
            }
          };
          var url = await self.reqCenterOrderApi(reqObj3);//保存用户确认方案url
          console.log('save confirmUrl ++ ',url)
          // return pushRes;
        }
      }
    }
    return pushRes;
  }

  //服务商icp方案关闭 2020-10-26 laolan
  async abolishIcpProgramme(pobj) {
    var res = await this.reqCenterOrderApi(pobj, "action/qcapi/springBoard");
    if (res && res.status == 0 && res.data) {
      var needsolution = res.data;//方案信息
      var ab = pobj.actionBody;
      if (typeof (ab.material) == "string") {
        ab.material = JSON.parse(ab.material);
      }
      //推送数据至阿里
      var pushObj = {
        BizId: ab.BizId, Note: ab.Note
      };
      //关闭方案
      this.aliclient.reqbyget({ action: "CloseIcpProduce", reqbody: pushObj, apiVersion: "2019-05-08" });
      return system.getResultSuccess();
    }
    return res;
  }

  //交付材料提交
  async serviceProviderSubmitMaterial(pobj) {
    var res = await this.reqCenterOrderApi(pobj, "action/qcapi/springBoard");
    if (res && res.status == 0 && res.data) {
      var needsolution = res.data;//方案信息
      var ab = pobj.actionBody;
      if (typeof (ab.material) == "string") {
        ab.material = JSON.parse(ab.material);
      }
      var material = ab.material;
      if(res.data.uapp_id == uappId.ali){
        //推送数据至阿里 
        var BizId = needsolution.channelSolutionNo;//⽅案业务ID
        var pushObj = {
          "BizId": BizId,
          "Domain": material.Domain,
          "CorporateName": material.CorporateName,
          "IncludeForeignInvestment": material.IncludeForeignInvestment,
          "PartnerBusinessLicense": material.PartnerBusinessLicense,
          "PartnerIdCardList": material.PartnerIdCardList,
          "PartnerDomainCertificate": material.PartnerDomainCertificate,
          "PartnerPreviewOtherList": material.PartnerPreviewOtherList || [],
          "PartnerPlan": material.PartnerPlan || "",
          "PartnerForeignInvestment": material.PartnerForeignInvestment || "",
          "PartnerLaw": material.PartnerLaw || "",
          "PartnerStampOtherList": material.PartnerStampOtherList || [],
          "PartnerSignOtherList": material.PartnerSignOtherList || [],
          "PartnerSignAndStampOtherList": material.PartnerSignAndStampOtherList || []
        };
        var self = this;
        //推送方案材料
        self.aliclient.reqbyget({ action: "SavePartnerSubmitMaterial", reqbody: pushObj, apiVersion: "2019-05-08" });
      }

      if(res.data.uapp_id == uappId.baidu){
        //推送数据至百度 
        var BizId = needsolution.orderChannelNo;
        console.log('BizId++',BizId)
        var pushObj = {
          "businessLicense" : {
            "createdAt" : material.BusinessLicense.CreatedAt || "",
            "enterpriseCode" :material.BusinessLicense.EnterpriseCode || "",
            "legalRepresentative" :material.BusinessLicense.LegalRepresentative || "",
            "address" :material.BusinessLicense.Address || "",
            "registeredCapital" : material.BusinessLicense.RegisteredCapital || "",
            "name" :material.BusinessLicense.Name || "",
            "businessTerm" :material.BusinessLicense.BusinessTerm || "",
            "type" : material.BusinessLicense.Type || "",
            "scopeBusiness" :material.BusinessLicense.ScopeBusiness || ""
          },
          "partnerForeignInvestment": material.PartnerForeignInvestment || "",
          "orderNo": BizId,
          "domain": material.Domain,
          "corporateName": material.CorporateName,
          "includeForeignInvestment": material.IncludeForeignInvestment,
          "partnerBusinessLicense": material.PartnerBusinessLicense,
          "partnerIdCardList": material.PartnerIdCardList,
          "partnerDomainCertificate": material.PartnerDomainCertificate,
          "partnerPreviewOtherList": material.PartnerPreviewOtherList || [],
          "partnerPlan": material.PartnerPlan || "",
          "partnerLaw": material.PartnerLaw || "",
          "partnerStampOtherList": material.PartnerStampOtherList || [],
          "partnerSignOtherList": material.PartnerSignOtherList || [],
          "partnerSignAndStampOtherList": material.PartnerSignAndStampOtherList || []
        };
        var self = this;
        //推送方案材料
        var r = await self.baiduclient.baiduReqbyget({ path: "/api/bla/provider/license/material", reqbody: pushObj });
        console.log('rrrr+++++',r)
      }
      return system.getResultSuccess();
    }
    return res;
  }
  //通知交付状态变更
  async serviceProviderNotification(pobj) {
    var res = await this.reqCenterOrderApi(pobj, "action/qcapi/springBoard");
    if (res && res.status == 0 && res.data) {
        if(res.data.uapp_id == uappId.ali){
           //推送数据至阿里
          var pushObj = {
            BizId: res.data.BizId,
            OfficialFileURL: res.data.OfficialFileURL,
            ApplicationStatus: res.data.ApplicationStatus
          };
          //推送状态变更
          this.aliclient.reqbyget({ action: "AcceptPartnerNotification", reqbody: pushObj, apiVersion: "2019-05-08" });
        }

        if(res.data.uapp_id == uappId.baidu){
          res.data.ApplicationStatus = baiduIcpStatus[res.data.ApplicationStatus];
          console.log('res.data.channelOrderNo',res.data.channelOrderNo)
          //推送数据至百度
         var pushObj = {
           orderNo: res.data.channelOrderNo,
           status: res.data.ApplicationStatus
         };
         //推送状态变更
         this.baiduclient.baiduReqbyget({ path: "/api/bla/provider/license/update", reqbody: pushObj });
       }
      return system.getResultSuccess();
    }
    return res;
  }
  //交付单关闭
  async closeOrderDelivery(pobj) {
    var res = await this.reqCenterOrderApi(pobj, "action/qcapi/springBoard");
    if (res && res.status == 0 && res.data) {
      var needsolution = res.data;//方案信息
      var ab = pobj.actionBody;
      //推送数据至阿里
      var pushObj = {
        BizId: needsolution.channelSolutionNo, Note: ab.note
      };
      //关闭方案
      this.aliclient.reqbyget({ action: "CloseIcpProduce", reqbody: pushObj, apiVersion: "2019-05-08" });
      return system.getResultSuccess();
    }
    return res;
  }
}
module.exports = BaseCenterOrderService;