const system = require("../../../system");
var settings = require("../../../../config/settings");
const AppServiceBase = require("../../app.base");

//区分渠道的uappid
const uappId = {
  'ali':"18",  //(阿里icp、edi)
  'baidu':"44"   //(百度icp、edi)
}
//推送百度城市拼音转义 2020-11-6
const cityLetter = {
  "北京":"BEIJING",
  "上海":"SHANGHAI",
  "福建":"FUJIAN",
  "广西":"GUANGXI",
  "广东":"GUANGDONG",
  "安徽":"ANHUI",
  "河南":"HENAN",
  "湖北":"HUBEI",
  "浙江":"ZHEJIANG",
  "江苏":"JIANGSU",
  "山东":"SHANDONG",
  "陕西":"SHANXI_SHAN",
  "宁夏":"NINGXIA",
  "甘肃":"GANSU",
  "新疆":"XINJIANG",
  "青海":"QINGHAI",
  "天津":"TIANJIN",
  "重庆":"CHONGQING",
  "河北":"HEBEI",
  "山西":"SHANXI_JIN",
  "辽宁":"LIAONING",
  "吉林":"JILIN",
  "黑龙江":"HEILONGJIANG",
  "江西":"JIANGXI",
  "湖南":"HUNAN",
  "四川":"SUCHUAN",
  "贵州":"GUIZHOU",
  "云南":"YUANNAN",
  "内蒙古":"NEIMENGGU",
  "西藏":"XIZANG",
  "外资":"WAIZI",
  "海南":"HAINAN"
}

//百度拼音转义 2020-11-11 laolan
const baiduIcpStatus = {
  507: "REGISTRATION",
  508: "SUBMITTED",
  509: "ACCEPTED",
  510: "NOT_ACCEPTED",
  511: "APPROVED",
  512: "NOT_APPROVED"
};
/**
 * 广电相关接口(RT)
 */
class RtService extends AppServiceBase {
  constructor() {
    super();
    this.centerOrderUrl = settings.centerOrderUrl();
    this.execClient = system.getObject("util.execClient");
    this.cacheManager = system.getObject("db.common.cacheManager");
    this.utilsOrderSve = system.getObject("service.utilsSve.utilsOrderSve");
    this.utilsPushSve = system.getObject("service.utilsSve.utilsPushSve");
    this.utilsTmAliyunSve = system.getObject("service.utilsSve.utilsTmAliyunSve");//测试用
    this.opPushQueueUrl = settings.opPushQueueUrl();
    this.baiduclient = system.getObject("util.baiduClient");
  };
  //调用center-order 
  async reqCenterOrderApi(pobj, reqUrl) {
    var url = this.centerOrderUrl + "action/qcapi/springBoard";
    if (reqUrl) {
      var url = this.centerOrderUrl + reqUrl;
    }
    var rtn = await this.execClient.execPost(pobj, url);
    var data = JSON.parse(rtn.stdout);
    return data;
  }


  //查询需求列表 2020-11-11 laolan
  async rtGetNeedList(pobj){
    var res = await this.reqCenterOrderApi(pobj, "action/qcapi/springBoard");
    if (res && res.status == 0 && res.data) {
      if(res.data.uapp_id == uappId.baidu){
        var pushObj = {
          type:res.data.type,
          begin:res.data.begin || "",
          end:res.data.end || "",
          intentionBizId:res.data.intentionBizId,
          status:res.data.status,
          area:res.data.area,
          pagreSize:res.data.pagreSize || 10,
          pageNum:res.data.pageNum || 1
        }
        //查询需求列表
        var r = await this.baiduclient.baiduReqbyget({ path: "////", reqbody: pushObj });
        console.log('rt rrrr+++++',r)
      }
      return getResultSuccess();
    }
    return res
  }

  //交付材料提交 2020-11-11 laolan
  async rtSubmitMaterial(pobj) {
    var res = await this.reqCenterOrderApi(pobj, "action/qcapi/springBoard");
    if (res && res.status == 0 && res.data) {
      var needsolution = res.data;//方案信息
      var ab = pobj.actionBody;
      if (typeof (ab.material) == "string") {
        ab.material = JSON.parse(ab.material);
      }
      var material = ab.material;
      if(res.data.uapp_id == uappId.baidu){
        //推送数据至百度 
        var bizId = needsolution.orderChannelNo;
        console.log('rt bizId++',bizId)
        var pushObj = {
          "orderNo": bizId,
          "businessLicense" : {
            "name" :material.businessLicense.name || "",
            "type" : material.businessLicense.type || "",
            "address" :material.businessLicense.address || "",
            "createdAt" : material.businessLicense.createdAt || "",
            "businessTerm" :material.businessLicense.businessTerm || "",
            "scopeBusiness" :material.businessLicense.scopeBusiness || "",
            "enterpriseCode" :material.businessLicense.enterpriseCode || "",
            "registeredCapital" : material.businessLicense.registeredCapital || "",
            "legalRepresentative" :material.businessLicense.legalRepresentative || "",
          },
          "partnerBusinessLicense": material.partnerBusinessLicense || "",
          "legalPersonIdentityCard":material.legalPersonIdentityCard || "",
          "administrativeLicenseAuthorization":material.administrativeLicenseAuthorization || "",
          "companyPolicy":material.companyPolicy || "",
          "mainManagement":material.mainManagement || "",
          "radioAndTelevisionQualifications":material.radioAndTelevisionQualifications || "",
          "registeredAddressCertificateDocument":material.registeredAddressCertificateDocument || "",
          "partnerOtherList":material.partnerOtherList || ""
        };
        //推送方案材料
        var r = await this.baiduclient.baiduReqbyget({ path: "/api/bla/provider/license/material", reqbody: pushObj });
        console.log('rt rrrr+++++',r)
      }
      return system.getResultSuccess();
    }
    return res;
  }
  //通知交付状态变更 2020-11-11 laolan
  async rtNotification(pobj) {
    var res = await this.reqCenterOrderApi(pobj, "action/qcapi/springBoard");
    if (res && res.status == 0 && res.data) {
      if(res.data.uapp_id == uappId.baidu){
        res.data.applicationStatus = baiduIcpStatus[res.data.applicationStatus];
        console.log('rt res.data.channelOrderNo+++',res.data.channelOrderNo)
        //推送数据至百度
        var pushObj = {
          orderNo: res.data.channelOrderNo,
          status: res.data.applicationStatus,
        };
        //推送状态变更
        var r = await this.baiduclient.baiduReqbyget({ path: "/api/bla/provider/license/update", reqbody: pushObj });
        console("rt tongzhi+++",r)
      }
      return system.getResultSuccess();
    }
    return res;
  }


  //提交方案 2020-11-11 laolan
  async rtSubmitSolution(pobj) {
    console.log('rt+++pobj',pobj)
    var res = await this.reqCenterOrderApi(pobj, "action/qcapi/springBoard");
    console.log('rt+++res',res)
    if (res && res.status == 0 && res.data) {
      console.log('rt solutionContent+++',res.data.needsolution.solutionContent);
      var solution = res.data.needsolution.solutionContent;
      var needsolution = res.data.needsolution;//方案信息
      solution = JSON.parse(solution);
      solution = solution.solution
      solution = JSON.stringify(solution)

        //推送交付系统
        var reqParams = {
          actionBody: {
            intentionBizId: pobj.actionBody.needNo,
            status: "createSolution"
          },
          opType: "updateChanceStatus",
          appInfo: pobj.appInfo
        }
        var self = this;
        self.utilsPushSve.aliBusiness2Delivery(reqParams, "updateChanceStatus");
        //日志记录
        self.logCtl.info({
          appid: pobj.appInfo ? pobj.appInfo.uapp_id || "" : "",
          appkey: pobj.appInfo ? pobj.appInfo.uapp_key || "" : "",
          requestId: pobj.requestId || "",
          op: "service/impl/common/rtSve.js/rtSubmitSolution",
          content: JSON.stringify(reqParams),
          resultInfo: "",
          optitle: "updateChanceStatus推送蜂擎获取的接口信息->aliBusiness2Delivery",
        });
      if(res.data.uapp_id == uappId.baidu){
        //推送数据至baidu
        var pushObj = {
          intentionBizId: res.data.needinfo.channelNeedNo,
          bizType: res.data.needinfo.channelTypeCode,
          // solution: res.data.needsolution.solutionContent
          solution: solution
        };
        console.log("rt pushObj+++",pushObj);
        var r = await this.pushBaiduRtSubmitSolution(pushObj, needsolution.solutionNo, pobj.appInfo, self);
        console.log('rt rr+++',r)
        return system.getResultSuccess();
      }
    }
    return res;
  }

  //推送方案baidu 2020-11-11 laolan
  async pushBaiduRtSubmitSolution(pushObj, solutionNo, appInfo, self) {
    //推送状态变更
    var pushRes = await this.baiduclient.baiduReqbyget({ path: "///", reqbody: pushObj });
    console.log(' rt++++pushRes',pushRes)
    if (pushRes && pushRes.status == 0 && pushRes.data) {
      var resData = pushRes.data;
      var reqObj2 = {
        actionType: "rtReceiveProgrammeNo",
        appInfo: appInfo,
        actionBody: {
          solutionNo: solutionNo,
          solutionBizId: resData.SolutionBizId
        }
      };
      var a = await self.reqCenterOrderApi(reqObj2);//保存渠道方案id
      return a;
    }
  }


  //提交沟通记录 2020-11-11 laolan
  async rtWriteCommunicationRecord(pobj) {
    console.log('rt 提交沟通记录pobj',pobj)
    var res = await this.reqCenterOrderApi(pobj, "action/qcapi/springBoard");
    console.log('rt 提交沟通记录res',res)
    if(res && res.data && res.status == 0){
      //推送交付系统
      var reqParams = {
        actionBody: {
          intentionBizId: pobj.actionBody.needNo,
          status: "followingUp"
        },
        opType: "updateChanceStatus",
        appInfo: pobj.appInfo
      }
      var push = await self.utilsPushSve.aliBusiness2Delivery(reqParams, "updateChanceStatus");
      if( push && res.data.uapp_id == uappId.baidu){
        //推送数据至baidu
        var pushObj = {
          intentionBizId: pobj.actionBody.needNo,
          note: pobj.actionBody.note
        };
        //提交沟通记录
        var r = await this.baiduclient.baiduReqbyget({ path: "////", reqbody: pushObj });
      }
      console.log('rt 提交沟通记录r++',r)
      return system.getResultSuccess();
    }
  }

  //查看沟通记录 2020-11-11 laolan
  async rtGetCommunicationRecord(pobj) {
    var res = await this.reqCenterOrderApi(pobj, "action/qcapi/springBoard");
    console.log('rt 查看沟通记录res-----',res)
    if(res && res.data && res.status == 0){
    if(res.data.uapp_id == uappId.baidu){
        //推送数据至baidu
        var pushObj = {
          beginTime: pobj.actionBody.beginTime ? pobj.actionBody.beginTime : "",
          endTime: pobj.actionBody.endTime ? pobj.actionBody.endTime : "",
          intentionBizId: pobj.actionBody.needNo,
          pageNum: pobj.actionBody.pageNum || 1,
          pageSize: pobj.actionBody.pageSize || 10,
        };
        //查看沟通记录
        var r = await this.baiduclient.baiduReqbyget({ path: "////", reqbody: pushObj });
        if(r && r.data && r.data.data){
          var len = r.data.data.length;
          for(var i=0; i<len;i++){
            r.data.data[i].createTime = r.data.data[i].createTime / 1000
          }
        }
        console.log('rt 查看沟通记录++',r)
      }
      return system.getResultSuccess(r);
    }
  }


  //关闭需求 2020-11-11 laolan
  async rtCloseNeed(pobj) {
    pobj.actionBody.intentionBizId = pobj.actionBody.channelNeedNo;
    pobj.actionType = "rtClosePlan"
    var reqUrl = this.centerOrderUrl + "action/qcapi/springBoard";
    var result = await this.restPostUrl(pobj, reqUrl);
    console.log('rt 关闭需求result-----',result)
    if (result.status == 0) {
      if (result.data) {
        pobj.actionBody.orderNo = result.data;
        var orderrtn = await self.utilsOrderSve.delOrder(pobj, pobj.actionBody);
        if (orderrtn.status < 0) {
          return system.getResultFail(-5022, "订单关闭失败");
        }
      }

      //推送交付系统
      var reqParams = {
        actionBody: {
          intentionBizId: pobj.actionBody.needNo,
          status: "closeNeed"
        },
        opType: "updateChanceStatus",
        appInfo: pobj.appInfo
      }
      this.utilsPushSve.aliBusiness2Delivery(reqParams, "updateChanceStatus");
      //日志记录
      this.logCtl.info({
        appid: pobj.appInfo ? pobj.appInfo.uapp_id || "" : "",
        appkey: pobj.appInfo ? pobj.appInfo.uapp_key || "" : "",
        requestId: pobj.requestId || "",
        op: "service/impl/common/rtSve.js/rtCloseNeed",
        content: JSON.stringify(reqParams),
        resultInfo: "",
        optitle: "updateChanceStatus推送蜂擎获取的接口信息->aliBusiness2Delivery",
      });
      if(res.data.uapp_id == uappId.baidu){
        // 推送baidu
        var pushObj  =  { 
          intentionBizId: pobj.actionBody.needNo, 
          bizType: pobj.actionBody.bizType,
          note : pobj.actionBody.note
        }
        var a = await this.baiduclient.baiduReqbyget({ path: "////", pushObj });
        console.log('rt closeNeed+++',a)
      }
      this.utilsPushSve.aliBusiness2Fq(pobj, "pushCloseRtNeed");
      return system.getResultSuccess();
    } else {
      return system.getResult(null, "close fail　100389  ");
    }
  }


  //服务商方案关闭 2020-11-11 laolan
  async rtClosePlan(pobj) {
    var res = await this.reqCenterOrderApi(pobj, "action/qcapi/springBoard");
    if (res && res.status == 0 && res.data) {
      var needsolution = res.data;//方案信息
      var ab = pobj.actionBody;
      if (typeof (ab.material) == "string") {
        ab.material = JSON.parse(ab.material);
      }
      if(res.data.uapp_id == uappId.baidu){
        //推送数据至baidu
        var pushObj = {
          bizId: ab.bizId,
          note: ab.note
        };
        //关闭方案
        var r  = await this.baiduclient.baiduReqbyget({ path: "////", reqbody: pushObj });
        console.log('rt closePlan +++',r)
      }
      return system.getResultSuccess();
    }
    return res;
  }

  //交付单关闭 2020-11-11 laolan
  async rtCloseOrderDelivery(pobj) {
    var res = await this.reqCenterOrderApi(pobj, "action/qcapi/springBoard");
    if (res && res.status == 0 && res.data) {
      var needsolution = res.data;//方案信息
      var ab = pobj.actionBody;
      if(res.data.uapp_id == uappId.baidu){
        //推送数据至baidu
        var pushObj = {
          bizId: needsolution.channelSolutionNo,
          note: ab.note
        };
        //关闭方案
        var r = await this.baiduclient.baiduReqbyget({ path: "///", reqbody: pushObj });
        console.log('rt 交付单关闭+++',r)
      }
      return system.getResultSuccess();
    }
    return res;
  }
}
module.exports = RtService;