const system = require("../../../system")
const settings = require("../../../../config/settings")
const md5 = require("MD5");
class SignService{
  constructor() {
    this.centerAppUrl = settings.centerAppUrl();
    this.restClient = system.getObject("util.restClient");
    this.redisClient = system.getObject("util.redisClient");
  }
  async restPostUrl(pobj, url) {
    try {
      var rtn = await this.restClient.execPost(pobj, url);
      if (!rtn || !rtn.stdout) {
        return system.getResult(null, "restPost data is empty");
      }
      var result = JSON.parse(rtn.stdout);
      return result;
    } catch (e) {
      var errorMsg = "error：" + e.stack;
      return system.getResult(null, errorMsg);
    }
  }
  async getAppInfoByAppKey(appkey){
    try {
        var shaStr = "getAppInfoByAppKey_"+appkey;
        var cacheRes = await this.redisClient.get(shaStr);
        if (cacheRes) {
            return JSON.parse(cacheRes);
        }
        let url = this.centerAppUrl + 'payment/paymentApi/getAppInfoByAppKey';
        let appInfoRt = await this.restPostUrl({ appKey: appkey }, url);
        if(appInfoRt && appInfoRt.status==0){
            //保存缓存
            await this.redisClient.setWithEx(shaStr, JSON.stringify(appInfoRt), 3600);
        }
        return appInfoRt;
    } catch (error) {
        var errres = system.getResultFail("获取应用信息失败！");
        return errres;
    }
  }
  /**
    * 验证签名
    * @param {*} params 要验证的参数 
    * @param {*} app_secret 应用的校验key
    */
   async verifySign(params, app_secret) {
    if (!params) {
      return system.getResult(null, "请求参数为空");
    }
    if (!params.sign) {
      return system.getResult(null, "请求参数sign为空");
    }
    var signArr = [];
    var keys = Object.keys(params).sort();
    if (keys.length == 0) {
      return system.getResult(null, "请求参数信息为空");
    }
    for (let k = 0; k < keys.length; k++) {
      const tKey = keys[k];
      if (tKey != "sign" && params[tKey]) {
        let tmpKeyValue = params[tKey];
        if (tmpKeyValue instanceof Array || tmpKeyValue instanceof Object) {
          tmpKeyValue = JSON.stringify(tmpKeyValue);
        }
        signArr.push(tKey + "=" + tmpKeyValue);
      }
    }
    if (signArr.length == 0) {
      return system.getResult(null, "请求参数组装签名参数信息为空");
    }
    var resultSignStr = signArr.join("&") + "&key=" + app_secret;
    var resultTmpSign = md5(resultSignStr).toUpperCase();
    // console.log("----------------resultSignStr start");
    // console.log(resultSignStr)
    // console.log("----------------resultSignStr end");
    // console.log("----------------resultTmpSign start");
    // console.log(resultTmpSign)
    // console.log("----------------resultTmpSign end");
    // console.log("----------------params.sign start");
    // console.log(params.sign)
    // console.log("----------------params.sign end");
    if (params.sign != resultTmpSign) {
      return system.getResult(null, "返回值签名验证失败");
    }
    return system.getResultSuccess();
   }
   async createSign(params, app_key) {
    if (!params) {
      return system.getResultFail(-310, "请求参数为空");
    }
    var signArr = [];
    var keys = Object.keys(params).sort();
    if (keys.length == 0) {
      return system.getResultFail(-330, "请求参数信息为空");
    }
    for (let k = 0; k < keys.length; k++) {
      const tKey = keys[k];
      if (tKey != "sign" && params[tKey]) {
        let tmpKeyValue = params[tKey];
        if (tmpKeyValue instanceof Array || tmpKeyValue instanceof Object) {
          tmpKeyValue = JSON.stringify(tmpKeyValue);
        }
        signArr.push(tKey + "=" + tmpKeyValue);
      }
    }
    if (signArr.length == 0) {
      return system.getResultFail(-350, "请求参数组装签名参数信息为空");
    }
    var resultSignStr = signArr.join("&") + "&key=" + app_key;
    var resultTmpSign = md5(resultSignStr).toUpperCase();
    return system.getResultSuccess(resultTmpSign);
  }
}
module.exports = SignService;
// var task = new SignService();

// var obj = {
//   "intentionBizId": "TRE-vLTWoPv99nfceshishuju2",
//   "description": "测试用户关闭2",
//   "intentionStatus": 5
// };
// task.createSign(obj,"7cbb892450174167b5c7e01we4716t51").then(d=>{
//     console.log(d,"!!!!!!!!!!!!!!!!!!!!!!!!!!");
// });

// var obj = {
// 	"orderNo":"c76a7c1a0cf747db92e9fc6beab770f0",
// 	"remark":"lin"
// }

// var obj = {
// 	"bizId":"202011031421",
// 	"status":"16"
// }
// var obj = {
// 	"bizId":"OD2020110629779501",
// 	"companyInfo":{
// 		"companyName":"苏州磐荣信息科技有限公司",
// 		"taxpayerTypeEnum":"NORMAL_TAXPAYER",
// 		"acctgSystemId":"10001",
// 		"enterpriseFormEnum":"1",
// 		"taxIndustryId":1,	
// 		"taxNo":"123456789",
// 		"serviceTypeEnum":"ACCOUTING",
// 		"taxClaimMethodEnum":"TAX_DECLARATION"
// 	},
//     "contactMobile":"18550295628",
//     "contactName":"范锋华",
// 	"timeUnit":"year",
// 	"quantity":1
// }

// }
// task.createSign(obj,"7cbb892450174167b5c7e01we4717z51").then(d=>{
//     console.log(d,"!!!!!!!!!!!!!!!!!!!!!!!!!!");
// });