var system = require("../../../system");
var settings = require("../../../../config/settings");
const AppServiceBase = require("../../app.base");
const md5 = require('md5')

//阿里支付类
class utils360Sve extends AppServiceBase {
    constructor() {
        super();
        this.centerAppUrl = settings.centerAppUrl();
        this.utilsAuthSve = system.getObject("service.utilsSve.utilsAuthSve")
        this.pushlogSve = system.getObject("service.common.pushlogSve");
    }


  //组合参数，由前端传到360
  async getParamsFor360(pobj, actionBody) {
    if (!actionBody.orderNo) {
      return system.getResult(null, "actionBody.orderNo can not be empty，100110");
    }
    pobj.actionType = "getPayOrderInfo";
    let orderUrl = settings.centerOrderUrl() + "action/order/springBoard";
    let orderResult = await this.restPostUrl(pobj, orderUrl);
    if (orderResult.status != 0) {
      return orderResult;
    }
    pobj.actionType ="getOrderDeliveryInfo";
    var deliveryResult = await this.restPostUrl(pobj,orderUrl);
    if (deliveryResult.status != 0) {
      return deliveryResult;
    }
    let sku_id = orderResult.data.orderProduct.itemCode;
    let price = Number(orderResult.data.orderProduct.price)*100;
    let quantity = orderResult.data.orderProduct.quantity;
    let amount = Number(orderResult.data.receiptVoucher.totalSum)*100;
    let order_id = orderResult.data.receiptVoucher.sourceOrderNo;
    let consignee = deliveryResult.data.orderContact.contactName;
    let mobile = deliveryResult.data.orderContact.mobile;
    let email = deliveryResult.data.orderContact.email;
    let singStr = sku_id + quantity + price + amount + order_id + pobj.appInfo.uapp_secret;
    let sign = md5(singStr).toUpperCase();
    let result ={
      sku_id,
      price,
      quantity,
      amount,
      order_id,
      consignee,
      mobile,
      email,
      sign
    }
    return system.getResult(result);
  }

    //更新订单状态到360
    async pushOrderStatus(pobj) {
        try {
            var verifyResult = await this.verifyParam(pobj);
            if (verifyResult.status != 0) {
                return await this.disposePushResultFail(pobj, verifyResult, "status->pushOrderStatus->verifyResult", this.pushlogFailType.FAILLOG);
            }
            var interface_params_info = verifyResult.data;
            let token = await this.utilsAuthSve.get360Token();
            let url = interface_params_info.opUrl + '?token=' + token.access_token;
            let order_id = pobj.actionBody.orderNo;
            let ApplicationStatus = pobj.pushObj.ApplicationStatus;
            let status = 0;
            if (Number(ApplicationStatus) < 508) {
                status = 30
            } else {
                status = 40;
            }
            let pushObj = {
                order_id, status
            }
            let result = await this.restPostUrl(pushObj, url);
            if (result.code == 200) {
                this.pushlogSve.createDb({
                    op: "360-pushOrderStatus",
                    content: JSON.stringify(pushObj),//推送的参数信息
                    resultInfo: JSON.stringify(result),
                    returnType: '1',
                    logLevel: '1',
                    opTitle: "推送360信息返回成功"
                });
            } else {
                this.logCtl.error({
                    appid: pobj.appInfo ? pobj.appInfo.uapp_id || "" : "",
                    appkey: pobj.appInfo ? pobj.appInfo.uapp_key || "" : "",
                    requestId: pobj.requestId || "",
                    op: "utilsSve/utils360Sve/pushOrderStatus",
                    content: "error：" + result.msg,
                    // clientIp: pobj.clientIp,
                    optitle: pobj.opType + "推送操作异常status->pushOrderStatus",
                });
            }
            console.log(result, '-------------push360-----------------')
            return result;
        } catch (e) {
            this.logCtl.error({
                appid: pobj.appInfo ? pobj.appInfo.uapp_id || "" : "",
                appkey: pobj.appInfo ? pobj.appInfo.uapp_key || "" : "",
                requestId: pobj.requestId || "",
                op: "utilsSve/utils360Sve/pushOrderStatus",
                content: "error：" + e.stack,
                // clientIp: pobj.clientIp,
                optitle: pobj.opType + "推送操作异常status->pushOrderStatus",
            });
        }
    }

    // 参数信息验证
    async verifyParam(pobj) {
        var verify = system.getResultSuccess();
        if (!pobj.interface_params) {
            verify = system.getResult(null, "interface_params can not be empty，100400");
        }
        var interface_params_info = JSON.parse(pobj.interface_params);
        if (!interface_params_info || !interface_params_info.opUrl) {
            verify = system.getResult(null, "interface_params（pushUrl） can not be empty，100430");
        }
        verify.data = interface_params_info;
        return verify;
    }

}

module.exports = utils360Sve;
