var system = require("../../../system");
const AppServiceBase = require("../../app.base");
var settings = require("../../../../config/settings");

//此类用来db中配置来进行调用-主要功能是推送渠道合作方
class UtilsChannelPartnerService extends AppServiceBase {
  constructor() {
    super();
    this.opPushQueueUrl = settings.opPushQueueUrl();
    this.signSve = system.getObject("service.common.signSve");
  }
  /**
   * 推送业务信息到渠道合作方
   * 业务操作的信息不变外加增加组装的一些参数（推送方案、订单交付信息）
   * @param {*} pobj 
   */
  async pushBusiness2Channel(pobj) {//推送业务信息到渠道合作方
    console.log(pobj,"pushBusiness2Channel-zhuangbing------------------------------");
    var verifyResult = await this.verifyParam(pobj);
    if (verifyResult.status != 0) {
      return await this.disposePushResultFail(pobj, verifyResult, "deliver->pushBusiness2Channel->verifyResult", this.pushlogFailType.FQ);
    }
    var actionbody = pobj.actionBody;
    var interface_params_info = verifyResult.data;
    if(interface_params_info.headData){
      interface_params_info.headData.appcode = pobj.appInfo.app_code;
      interface_params_info.headData.sign = verifyResult.sign;
      interface_params_info.headData.appkey = pobj.appInfo.uapp_key;
    }
    var reqParams = {
      actionType: "produceData",// Y 功能名称
      actionBody: {
        pushUrl: interface_params_info.pushUrl,// Y 推送地址
        actionType: interface_params_info.actionType,// Y 推送地址接收时的功能名称
        notifyUrl: interface_params_info.notifyUrl || "",// N 推送成功后通知的Url                 
        identifyCode: interface_params_info.identifyCode,// Y 操作的业务标识
        messageBody: actionbody, // Y 推送的业务消息，必须有一项对象属性值
        headData: interface_params_info.headData //N 请求头信息，Json格式，如：{token:"XXXXXXX"}
      },
      requestId: pobj.requestId || "" // N 请求id
    }
    var opQueuePushClientPostRes =  await this.opQueuePushClientPost(pobj, this.opPushQueueUrl, reqParams);
    console.log(opQueuePushClientPostRes,"pushBusiness2Channel-zhuangbing----2--------------------------");
  }

  //--------------------------------------------------内部辅助方法-------------------start-----------------

  async opQueuePushClientPost(pobj, pushQueueUrl, reqParams) {
    try {
      var rtn = await this.restPostUrl(reqParams, pushQueueUrl);
      if (rtn.status != 1) {
        return system.getResult(null, "推送队列接收数据失败，失败原因：" + JSON.stringify(rtn));
      }
      return system.getResultSuccess(null, "推送成功");
    } catch (e) {
      //日志记录
      this.logCtl.error({
        appid: pobj.appInfo ? pobj.appInfo.uapp_id || "" : "",
        appkey: pobj.appInfo ? pobj.appInfo.uapp_key || "" : "",
        requestId: pobj.requestId || "",
        op: "utilsSve/utilsChannelPartnerSve/opQueuePushClientPost",
        content: "error：" + e.stack,
        // clientIp: pobj.clientIp,
        optitle: pobj.opType + "推送操作异常deliver->opQueuePushClientPost",
      });
      return system.getResult(null, "推送操作异常deliver->opQueuePushClientPost->error：" + e.stack);
    }
  }
  async verifyParam(pobj) {//参数信息验证
    var verify = system.getResultSuccess();
    if (!pobj.interface_params) {
      verify = system.getResult(null, "interface_params can not be empty，100400");
    }
    var interface_params_info = JSON.parse(pobj.interface_params);
    if (!interface_params_info || !interface_params_info.pushUrl || !interface_params_info.headData) {
      verify = system.getResult(null, "interface_params（pushUrl、headData） can not be empty，100430");
    }
    if(!pobj || !pobj.appInfo || !pobj.appInfo.app_code){
      verify = system.getResult(null, "appInfo can not be empty，100450");
    }
    var signRes = await this.signSve.createSign({actionBody:pobj.actionBody,actionType: interface_params_info.actionType},pobj.appInfo.uapp_secret);
    if(signRes && signRes.status==0){
      verify.sign=signRes.data;
    }else{
      verify = system.getResult(null, "creatSign fail!，100470");
    }
    verify.data = interface_params_info;
    console.log(verify,"app/base/service/impl/utilsSve/utilsChannelPartnerSve.js____verifyParam___________________");
    return verify;
  }

  //--------------------------------------------------内部辅助方法-------------------end-----------------
}
module.exports = UtilsChannelPartnerService;
