var system = require("../../../system");
const AppServiceBase = require("../../app.base");
var settings = require("../../../../config/settings");

//此类用来db中配置来进行调用-主要功能是推送交付系统
class UtilsDeliverSystemService extends AppServiceBase {
  constructor() {
    super();
    this.opPushQueueUrl = settings.opPushQueueUrl();
  }
  /**
   * 推送业务信息到交付系统
   * 业务操作的信息不变外加增加组装的一些参数（推送需求商机、关闭需求、订单商机、关闭订单）
   * @param {*} pobj 
   */
  async pushBusiness2DeliverSystem(pobj) {//推送业务信息到交付系统
    console.log(pobj,"pushBusiness2DeliverSystem-zhuangbing------------------------------");
    var verifyResult = await this.verifyParam(pobj);
    if (verifyResult.status != 0) {
      return await this.disposePushResultFail(pobj, verifyResult, "deliver->pushBusiness2DeliverSystem->verifyResult", this.pushlogFailType.FQ);
    }
    var interface_params_info = verifyResult.data;
    if(interface_params_info.headData){
      if(pobj && pobj.appInfo && pobj.appInfo.app_code){
        interface_params_info.headData.appcode = pobj.appInfo.app_code;
      }
    }
    var reqParams = {
      actionType: "produceData",// Y 功能名称
      actionBody: {
        pushUrl: interface_params_info.pushUrl,// Y 推送地址
        actionType: interface_params_info.actionType,// Y 推送地址接收时的功能名称
        notifyUrl: interface_params_info.notifyUrl || "",// N 推送成功后通知的Url                 
        identifyCode: interface_params_info.identifyCode,// Y 操作的业务标识
        messageBody: pobj.actionBody, // Y 推送的业务消息，必须有一项对象属性值
        headData: interface_params_info.headData //N 请求头信息，Json格式，如：{token:"XXXXXXX"}
      },
      requestId: pobj.requestId || "" // N 请求id
    }
    var opQueuePushClientPostRes =  await this.opQueuePushClientPost(pobj, this.opPushQueueUrl, reqParams);
    console.log(opQueuePushClientPostRes,"pushBusiness2DeliverSystem-zhuangbing----2--------------------------");
  }

  //--------------------------------------------------内部辅助方法-------------------start-----------------

  async opQueuePushClientPost(pobj, pushQueueUrl, reqParams) {
    try {
      var rtn = await this.restPostUrl(reqParams, pushQueueUrl);
      if (rtn.status != 1) {
        return system.getResult(null, "推送队列接收数据失败，失败原因：" + JSON.stringify(rtn));
      }
      return system.getResultSuccess(null, "推送成功");
    } catch (e) {
      //日志记录
      this.logCtl.error({
        appid: pobj.appInfo ? pobj.appInfo.uapp_id || "" : "",
        appkey: pobj.appInfo ? pobj.appInfo.uapp_key || "" : "",
        requestId: pobj.requestId || "",
        op: "utilsSve/utilsDeliverSystemSve/opQueuePushClientPost",
        content: "error：" + e.stack,
        // clientIp: pobj.clientIp,
        optitle: pobj.opType + "推送操作异常deliver->opQueuePushClientPost",
      });
      return system.getResult(null, "推送操作异常deliver->opQueuePushClientPost->error：" + e.stack);
    }
  }
  async verifyParam(pobj) {//参数信息验证
    var verify = system.getResultSuccess();
    if (!pobj.interface_params) {
      verify = system.getResult(null, "interface_params can not be empty，100400");
    }
    var interface_params_info = JSON.parse(pobj.interface_params);
    if (!interface_params_info || !interface_params_info.pushUrl || !interface_params_info.headData) {
      verify = system.getResult(null, "interface_params（pushUrl、headData） can not be empty，100430");
    }
    verify.data = interface_params_info;
    return verify;
  }

  //--------------------------------------------------内部辅助方法-------------------end-----------------
}
module.exports = UtilsDeliverSystemService;
