var childproc = require('child_process');
const util = require('util');
const exec = util.promisify(require('child_process').exec);
const querystring = require('querystring');
var settings = require("../../config/settings");
const uuidv4 = require('uuid/v4');
class RestClient {
  constructor() {
    this.cmdGetPattern = "curl {-G} -k  -d '{data}' {url}";
    this.cmdPostPattern = "curl -k -H 'Content-type: application/json' -d '{data}' '{url}'";

    this.cmdPostPatternWithAK = "curl -k -H 'Content-type: application/json' -H 'AccessKey:{ak}' -H 'request-id:{requestId}' -d '{data}' {url}";

    this.cmdPostWithHValue = "curl -k -H 'Content-type: application/json' -H 'ak:{ak}' -d '{data}' {url}";

    this.cmdDownLoadFilePattern = "curl -G -o {fileName} {url}";
    this.cmdPostPattern2 = "curl -k -H 'Content-type: application/x-www-form-urlencoded' -d '{data}' {url}";
    // form-data形式post  data参数类型 md5=2&data=1
    this.cmdPostPattern5 = "curl -k --data '{data}' {url}";
    // authorization=[token]
    this.cmdPostpatternToken = "curl -k -H 'Content-type: application/json' -H 'authorization:{token}' -X POST {url}"
  }
  getUUID() {
    var uuid = uuidv4();
    var u = uuid.replace(/\-/g, "");
    return u;
  }
  FetchGetCmd(subData, url) {
    var cmd = this.cmdGetPattern.replace(/\{\-G\}/g, "-G").replace(
      /\{data\}/g, subData).replace(/\{url\}/g, url);
    return cmd;
  }
  FetchPostCmd(subData, url) {
    var data = JSON.stringify(subData);
    var cmd = this.cmdPostPattern.replace(/\{data\}/g,
      data).replace(/\{url\}/g, url);
    return cmd;
  }
  FetchPostCmdWithAK(subData, url, acck) {
    var data = JSON.stringify(subData);
    var requestId = this.getUUID();
    var cmd = this.cmdPostPatternWithAK.replace(/\{data\}/g,
      data).replace(/\{url\}/g, url).replace(/\{ak\}/g, acck).replace(/\{requestId\}/g, requestId);
    return cmd;
  }
  FetchPostCmdWithHValue(subData, url, hValue) {
    var data = JSON.stringify(subData);
    var cmd = this.cmdPostWithHValue.replace(/\{data\}/g,
      data).replace(/\{url\}/g, url).replace(/\{ak\}/g, hValue);
    return cmd;
  }
  FetchrestPostWithHAuthorizationUrl(userToken, url) {
    var cmd = this.cmdPostpatternToken.replace(/\{url\}/g, url).replace(/\{token\}/g, userToken);
    return cmd;
  }
  FetchPostCmd2(subData, url) {
    var data = subData;
    var cmd = this.cmdPostPattern2.replace(/\{data\}/g,
      data).replace(/\{url\}/g, url);
    return cmd;
  }
  FetchPostCmd5(subData, url) {
    var data = subData;
    var cmd = this.cmdPostPattern5.replace(/\{data\}/g,
      data).replace(/\{url\}/g, url);
    return cmd;
  }
  FetchDownLoadCmd(outfname, url) {
    // console.log(this.cmdPattern);
    var cmd = this.cmdDownLoadFilePattern.replace(/\{fileName\}/g, outfname).replace(
      /\{url\}/g, url);
    return cmd;
  }
  async exec(cmd, options) {
    //await后面表达式返回的promise对象，是then的语法糖，await返回then函数的返回值
    //异常需要try/catch自己捕获或外部catch捕获
    if (options) {
      const { stdout, stderr } = await exec(cmd, options);
      return { stdout, stderr };
    } else {
      const { stdout, stderr } = await exec(cmd);
      return { stdout, stderr };
    }

  }
  async execDownload(url, outfname) {
    let cmd = this.FetchDownLoadCmd(outfname, url);
    var result = await this.exec(cmd);
    return result;
  }
  async execGet(subData, url) {
    let cmd = this.FetchGetCmd(subData, url);
    var result = await this.exec(cmd);
    return result;
  }
  async execGet2(subData, url) {
    var data = querystring.stringify(subData);
    let cmd = this.FetchGetCmd(data, url);
    var result = await this.exec(cmd);
    return result;
  }
  async execPost(subData, url) {
    let cmd = this.FetchPostCmd(subData, url);
    console.log(cmd, "cmd............");
    var result = await this.exec(cmd, {
      maxBuffer: 10000 * 1024
    });
    return result;
  }
  async execPostWithAK(subData, url, ak) {
    let cmd = this.FetchPostCmdWithAK(subData, url, ak);
    var result = await this.exec(cmd, {
      maxBuffer: 1024 * 1024 * 15
    });
    var rtn = result.stdout;
    if (rtn) {
      return JSON.parse(rtn);
    } else {
      return null;
    }
  }
  async execPostWithHValue(subData, url, hValue) {
    let cmd = this.FetchPostCmdWithHValue(subData, url, hValue);
    console.log(cmd, "cmd............");
    var result = await this.exec(cmd, {
      maxBuffer: 1024 * 1024 * 15
    });
    return result;
  }
  async restPostWithHAuthorizationUrl(userToken, url) {
    let cmd = this.FetchrestPostWithHAuthorizationUrl(userToken, url);
    console.log(cmd, "cmd............");
    var result = await this.exec(cmd, {
      maxBuffer: 1024 * 1024 * 15
    });
    return result;
  }
  async execPost2(subData, url) {
    let cmd = this.FetchPostCmd2(subData, url);
    console.log(cmd);
    var result = await this.exec(cmd);
    return result;
  }
  async execPost3(subData, url) {
    let cmd = this.FetchPostCmd3(subData, url);
    console.log(cmd);
    var result = await this.exec(cmd);
    return result;
  }
  async execGet3(url) {
    let cmd = this.FetchGetCmd3(url);
    console.log("execGet3-----01");
    console.log(cmd);
    var result = await this.exec(cmd);
    return result;
  }
  async execPostESignBao(subData, url) {
    let cmd = this.FetchPostCmd4(subData, url);
    console.log(cmd);
    var result = await this.exec(cmd);
    return result;
  }
  async execPostForm(subData, url) {
    let cmd = this.FetchPostCmd5(subData, url);
    console.log(cmd);
    var result = await this.exec(cmd);
    return result;
  }
  async execCustomPostESignBao(cmd) {
    console.log(cmd);
    var result = await this.exec(cmd);
    return result;
  }
  async execDeliveryPost(subdata,url){
    let cmd = this.FetchPostCmd(subdata,url)
    cmd += " -H 'XAPPKEY:647a68c9-da01-40d3-9763-1ffa0f64cf3f'"
    var result = await this.exec(cmd);
    return result;
  }
  test() {
    console.log("hello");
  }
}
module.exports = RestClient;
// var x=new RestClient();
// x.execGet("","http://www.163.com").then(function(r){
//   console.log(r.stdout);
//   console.log(r.stderr);
// });
