const CacheBase=require("../cache.base");
const system=require("../../system");
const settings = require("../../../config/settings");
//缓存首次登录的赠送的宝币数量
class AppCache extends CacheBase{
   constructor(){
     super();
     this.prefix="g_appkey:";
     this.appDao=system.getObject("db.common.appDao");
   }
   isdebug(){
    return settings.env=="dev";
  }
   desc(){
     return "缓存本地应用对象";
  }
  prefix(){
     return "g_applocal_"
  }
  async buildCacheVal(cachekey,inputkey, val, ex, ...items) {
    const configValue=await this.appDao.findOne2(inputkey);
    if (configValue) {
      return JSON.stringify(configValue);
    }
    return null;
  }
}
module.exports=AppCache;
