const system=require("../../../system");
const Dao=require("../../dao.base");
class ChannelDao extends Dao{
  constructor(){
    super(Dao.getModelName(ChannelDao));
  }
  extraModelFilter(){
    //return {"key":"include","value":[{model:this.db.models.app,},{model:this.db.models.role,as:"Roles",attributes:["id","name"],joinTableAttributes:['created_at']}]};
    return {"key":"include","value":[{model:this.db.models.role,as:"Roles",attributes:["id","name"]}]};
  }
  async preUpdate(u){
    if(u.roles.length>0){
      var roles=await this.db.models.role.findAll({where:{id:{[this.db.Op.in]:u.roles}}});
      console.log("xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx");
      console.log(roles);
      u.roles=roles
    }
    return u;
  }
  async update(obj){
    var obj2=await this.preUpdate(obj);
    console.log("update....................");
    console.log(obj2);
    await this.model.update(obj2,{where:{id:obj2.id}});
    var channel=await this.model.findOne({where:{id:obj2.id}});
    channel.setRoles(obj2.roles);
    return channel;
  }
}
module.exports=ChannelDao;
