const system=require("../../../system");
const Dao=require("../../dao.base");
class TradeDao extends Dao{
  constructor(){
    super(Dao.getModelName(TradeDao));
    this.pAccountDao=system.getObject("db.pAccountDao");
    this.accountDao=system.getObject("db.accountDao");
    this.appDao=system.getObject("db.appDao");
  }
  extraWhere(obj,w){
     if(obj.codepath && obj.codepath!=""){
       //ptraderecord----财务人员中的平台帐户、平台运营中的交易记录两项，查询的为全部的信息，不加条件，recommendFee:推荐分润----显示负数

       if(obj.codepath.indexOf("mytraderecord")>=0|| obj.codepath.indexOf("ucmytrades")>=0){
          //个人用户的交易记录：bizs/wx76a324c5d201d1a4/mytrades.js
          //orderPersonFee:订单个人分润、recommendFee:推荐分润----显示正数、cashWithdrawal: 现金提现、fill:充值宝币、gift:赠送宝币、consume: 消费宝币
          w["account_id"]=obj.account_id;
          w[this.db.Op.and]={[this.db.Op.or]:[{tradeType: 'orderPersonFee'}, {tradeType: 'recommendFee'},
                            {tradeType: 'cashWithdrawal'},{tradeType: 'gift'},
                            {tradeType: 'consume'},{tradeType: 'fill'}]};
       }
       if(obj.codepath.indexOf("petrades")>=0){
         //官费记录：bizs/wx76a324c5d201d1a4/petrades.js
         // subPublicExpense:上缴官费、returnPublicExpense:官费退回
         w[this.db.Op.and]={[this.db.Op.or]:[{tradeType: 'subPublicExpense'},{tradeType: 'returnPublicExpense'}]};
       }
       if(obj.codepath.indexOf("fintraderecord")>=0){
          //财务人员中的交易记录：bizs/wx76a324c5d201d1a4/fintrades.js
          //orderTrade: 订单交易、cashWithdrawal: 现金提现、subPublicExpense:上缴官费、returnPublicExpense:官费退回、fill: 充值宝币
          w[this.db.Op.and]={[this.db.Op.or]:[{tradeType: 'fill'}, {tradeType: 'orderTrade'},
          {tradeType: 'cashWithdrawal'},{tradeType: 'subPublicExpense'},
          {tradeType: 'returnPublicExpense'}]};
      }
     }
     return w;
  }
  //to do cache accountid
  // async findAccountBalanceByUserId(aid){
  //   var tone= await this.model.findOne({
  //     where:{user_id:uid},
  //     include:[{"model":this.db.models.account,}]
  //   });
  //   var tmp={};
  //   var ac=await tone.getAccount();
  //   tmp.baoBalance=ac.baoBalance;
  //   tmp.renBalance=ac.renBalance;
  //   return tmp;
  // }
  async create(user,account,tradeobj,t){
    console.log("tradeDao—————————————————————————————————————新用户测试创建---------user");
    console.log(user);
    var app = await this.appDao.findById(user.app_id);
    console.log("tradeDao——————————————————————————————————————新用户测试------app");
    console.log(app);
    console.log("tradeDao——————————————————————————————————————新用户测试----------------account");
    console.log(account);
    var trade=null;
      if(app && app.appid=="wx76a324c5d201d1a4"){
        var tradeToSave=await this.model.build(tradeobj);
        tradeToSave.tradeType="gift";
        trade=await tradeToSave.save({transaction:t});
        await trade.setUser(user,{transaction:t});
        await trade.setAccount(account,{transaction:t});
        //账户的交易处理
        if(tradeToSave.tradeType=="gift" || tradeToSave.tradeType=="fill"){
          // account.baoBalance+=tradeToSave.baoAmount;
          // account.renBalance+=tradeToSave.renAmount;
          account.baoBalance=Number(account.baoBalance)+Number(tradeToSave.baoAmount);
          if(tradeToSave.tradeType!="fill"){
            account.renBalance=Number(account.renBalance)+Number(tradeToSave.renAmount);
          }
        }else{
          // account.baoBalance-=tradeToSave.baoAmount;
          account.baoBalance=Number(account.baoBalance)-Number(tradeToSave.baoAmount);
          //account.renBalance-=tradeToSave.renAmount;
        }
        await account.save({transaction:t});
        //平台账户的交易处理
        var paccount=  await  this.pAccountDao.findPAccount({transaction:t});
        if(tradeToSave.tradeType=="gift" || tradeToSave.tradeType=="fill"){
          // paccount.baoBalance-=tradeToSave.baoAmount;
          // paccount.renBalance+=tradeToSave.renAmount?tradeToSave.renAmount:0.0;
          paccount.baoBalance=Number(paccount.baoBalance)-Number(tradeToSave.baoAmount);
          if(tradeToSave.tradeType=="fill"){
            paccount.renBalance=Number(paccount.renBalance)-Number(tradeToSave.renAmount?tradeToSave.renAmount:0.0);
          }
        }else {
          // paccount.baoBalance+=tradeToSave.baoAmount;
          paccount.baoBalance=Number(paccount.baoBalance)+Number(tradeToSave.baoAmount);
        }
        var rc=system.getObject("util.redisClient");
        await rc.delete("account_balance_"+account.id+"_"+user.app_id);
        await paccount.save({transaction:t});
      }
      return trade;
  }

  async create2(user,account,tradeobj,t){
    console.log("!!!!!!!@@@@@@@@@@@@@@##############$");
      console.log(tradeobj);
      var tradeToSave=await this.model.build(tradeobj);
      console.log(tradeToSave);

      //账户的交易处理
      console.log(tradeToSave);
      if(tradeToSave.tradeType=="gift" || tradeToSave.tradeType=="fill"){
        account.baoBalance=Number(account.baoBalance)+Number(tradeToSave.baoAmount);
        if(tradeToSave.tradeType!="fill"){
          account.renBalance=Number(account.renBalance)+Number(tradeToSave.renAmount);
        }
      }else{
        account.baoBalance=Number(account.baoBalance)-Number(tradeToSave.baoAmount);
      }
      await account.save({transaction:t});
      //平台账户的交易处理
      var paccount=  await  this.pAccountDao.findPAccount({transaction:t});
      if(tradeToSave.tradeType=="gift" || tradeToSave.tradeType=="fill"){
        paccount.baoBalance=Number(paccount.baoBalance)-Number(tradeToSave.baoAmount);
        if(tradeToSave.tradeType=="fill"){
          paccount.renBalance=Number(paccount.renBalance)-Number(tradeToSave.renAmount?tradeToSave.renAmount:0.0);
        }

      }
      else {
        paccount.baoBalance=Number(paccount.baoBalance)+Number(tradeToSave.baoAmount);
      }
      await paccount.save({transaction:t});
      var tradeToSave = await this.preCreate(tradeToSave);
      var trade=await tradeToSave.save({transaction:t});
      await trade.setUser(user,{transaction:t});
      await trade.setAccount(account,{transaction:t});

      return trade;
  }
  preCreate(u){
    // "fill": "充值", "consume": "消费", "gift": "赠送", "giftMoney": "红包", "refund": "退款","payment":"付款",
    //               "orderTrade": "订单交易", "orderRefund": "订单退款", "orderPersonFee": "订单个人分润",
    //               "orderPlatformFee": "订单平台分润","recommendFee": "推荐分润", "tmSubDeductCoin": "商标提报宝币扣除",
    //               "cashWithdrawal": "现金提现","platUseFee":"平台使用费","publicExpense":"官费","invoiceTaxes":"税费"

    //个人：
    //  1.人民币： 订单个人分润+ 推荐分润+ 现金提现-
    //  2.宝币：   赠送+ 消费- 充值+ 商标提报宝币扣除-

    //平台：
    //  1.人民币：订单交易+ 订单退款- 订单个人分润- 订单平台分润+ 推荐分润- 平台使用费+ 官费+ 税费+
    //  2.宝币：  赠送- 消费+ 充值-+ 商标提报宝币扣除+
    if(u.tradeType=="consume" || u.tradeType=="cashWithdrawal" || u.tradeType=="tmSubDeductCoin" ){//消费 现金提现 商标提报宝币扣除
      u.baoAmount=Math.abs(u.baoAmount)*(-1);
      u.renAmount=Math.abs(u.renAmount)*(-1);
    }
    return u;
  }
  async updatePAccount(obj,t){
    var bao = obj.bao;
    var ren = obj.ren;
    var paccount=  await  this.pAccountDao.findPAccount({transaction:t});
    paccount.renBalance=parseFloat(paccount.renBalance)-parseFloat(ren);
    console.log(obj);
    console.log(paccount.renBalance);
    console.log(paccount);
    await this.pAccountDao.update(paccount.dataValues,t);
  }
  async createOrderTrade(u,t){
    console.log("createOrderTrade DAO+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++");
    console.log(u);
      if(u.tradeType=="orderTrade"){//订单交易
        var paccount=  await  this.pAccountDao.findPAccount({transaction:t});
        paccount.renBalance=parseFloat(paccount.renBalance)+parseFloat(u.renAmount);
        //await paccount.save({transaction:t});
        await this.pAccountDao.update(paccount.dataValues,t);
      }
      if(u.tradeType=="orderPersonFee"){//订单个人分润
        var account = await this.accountDao.findById(u.account_id);
        account=account.dataValues;
        console.log("订单个人分润");
        console.log(account);
        // paccount.renBalance=Number(paccount.renBalance)-Number(u.renAmount);
        // //await paccount.save({transaction:t});
        // await this.pAccountDao.update(paccount.dataValues,t);
        account.renBalance=parseFloat(account.renBalance)+parseFloat(u.renAmount);
        await this.accountDao.update(account,t);
      }
      if(u.tradeType=="recommendFee"){//推荐分润
        console.log("推荐分润");
        console.log(account);
        var account = await this.accountDao.findById(u.account_id);
        account=account.dataValues;
        // paccount.renBalance=Number(paccount.renBalance)-Number(u.renAmount);
        // //await paccount.save({transaction:t});
        // await this.pAccountDao.update(paccount.dataValues,t);
        account.renBalance=parseFloat(account.renBalance)+parseFloat(u.renAmount);
        await this.accountDao.update(account,t);
      }
      if(u.tradeType=="orderPlatformFee" || u.tradeType=="publicExpense" || u.tradeType=="invoiceTaxes"){//平台分润 官费 税费
        //平台分润 官费 税费 只创建交易数据 平台账户余额不变
      }
      if(u.tradeType=="platUseFee"){//平台使用费
        console.log("平台使用费");
        //平台使用费 只创建交易数据 账户余额不变
      }
      if(u.tradeType=="consume"){//消费宝币
        var paccount=  await  this.pAccountDao.findPAccount({transaction:t});
        var account = await this.accountDao.findById(u.account_id);
        account=account.dataValues;
        paccount.renBalance=Number(paccount.renBalance)+Number(u.renAmount);
        paccount.baoBalance=Number(paccount.baoBalance)+Number(u.baoAmount);
        //await paccount.save({transaction:t});
        await this.pAccountDao.update(paccount.dataValues,t);
        account.renBalance=Number(account.renBalance)-Number(u.renAmount);
        account.baoBalance=Number(account.baoBalance)-Number(u.baoAmount);
        await this.accountDao.update(account,t);
      }
      var u2=this.preCreate(u);
      return this.model.create(u2,{transaction: t}).then(u=>{
        return u;
      });

  }
}
module.exports=TradeDao;
