const system = require("../../../system");
const settings = require("../../../../config/settings");
const uiconfig = system.getUiConfig2(settings.appKey);
module.exports = (db, DataTypes) => {
  return db.define("app", {
    appkey: DataTypes.STRING,//需要在后台补充
    secret: DataTypes.STRING,//需要在后台补充
    name: {
      type: DataTypes.STRING,
      allowNull: false,
    },//和user的from相同，在注册user时，去创建
    domainName: DataTypes.STRING,//域名
    homePage: DataTypes.STRING,//首页
    authUrl: DataTypes.STRING,//认证地址
    docUrl: DataTypes.STRING,//接口文档地址
    uiconfigUrl: DataTypes.STRING,//基础信息配置信息地址
    logoUrl: DataTypes.STRING,//应用Logo
    bkimageUrl: DataTypes.STRING,//应用背景图
    showimgUrl: DataTypes.STRING,//应用显示图标
    detailimgUrl: DataTypes.STRING,//应用详情介绍地址
    opCacheUrl: DataTypes.STRING,//操作缓存地址
    notifyCacheCountUrl: DataTypes.STRING,//接收API使用计数的通知URL
    description: DataTypes.STRING,//应用描述
    isSaas: {
      type: DataTypes.BOOLEAN,
      allowNull: false,
      defaultValue: true
    },//是否启用
    isEnabled: {
      type: DataTypes.BOOLEAN,
      allowNull: false,
      defaultValue: false
    },//是否启用
    isPublish: {
      type: DataTypes.BOOLEAN,
      allowNull: false,
      defaultValue: false
    },//是否对外
    isCommon: {
      type: DataTypes.BOOLEAN,
      allowNull: false,
      defaultValue: false
    },//是否公共服务
    appType: {
      type: DataTypes.ENUM,
      allowNull: true,
      values: Object.keys(uiconfig.config.pdict.app_type),
    },
  }, {
      paranoid: true,//假的删除
      underscored: true,
      version: true,
      freezeTableName: true,
      //freezeTableName: true,
      // define the table's name
      tableName: 'p_app',
      validate: {

      },
      indexes: [
        // Create a unique index on email
        //  {
        //    unique: true,
        //    fields: ['email']
        //  },
        //
        //  // Creates a gin index on data with the jsonb_path_ops operator
        //  {
        //    fields: ['data'],
        //    using: 'gin',
        //    operator: 'jsonb_path_ops'
        //  },
        //
        //  // By default index name will be [table]_[fields]
        //  // Creates a multi column partial index
        //  {
        //    name: 'public_by_author',
        //    fields: ['author', 'status'],
        //    where: {
        //      status: 'public'
        //    }
        //  },
        //
        //  // A BTREE index with a ordered field
        //  {
        //    name: 'title_index',
        //    method: 'BTREE',
        //    fields: ['author', {attribute: 'title', collate: 'en_US', order: 'DESC', length: 5}]
        //  }
      ]
    });
}
