const system=require("../../../system");
const ServiceBase=require("../../sve.base");
class PConfigService extends ServiceBase{
  constructor(){
     super("common",ServiceBase.getDaoName(PConfigService));
     //this.appDao=system.getObject("db.appDao");
  }
  async findOrSetPrice(num,appkey){
     return this.cacheManager["PriceConfigCache"].cacheGlobalVal(num,appkey);
  }
  async create(pobj){
    await this.cacheManager["PConfigCache"].invalidate(pobj.appkey);
    await this.cacheManager["InitGiftCache"].invalidate(pobj.appkey);
    return this.dao.create(pobj);
  }
  async update(pobj,tm=null){
    await this.cacheManager["PConfigCache"].invalidate(pobj.appkey);
    await this.cacheManager["InitGiftCache"].invalidate(pobj.appkey);
    return this.dao.update(pobj,tm);
  }
  async updateByWhere(setObj,whereObj,t){
    await this.cacheManager["PConfigCache"].invalidate(setObj.appkey);
    await this.cacheManager["InitGiftCache"].invalidate(setObj.appkey);
    return this.dao.updateByWhere(setObj,whereObj,t);
  }
  //获取配置的发票税率
  async getInvoiceTaxRate(){
    var tmpInvoiceTaxRate=7;
    var pconfig=await this.cacheManager["PConfigCache"].cachePConfig();
    var pconfigResult= pconfig.find(item => {
        return item.configType === "invoiceTaxRate";
    });
    if(pconfigResult!=null && pconfigResult.configValue!=null && pconfigResult.configValue!=""){
      tmpInvoiceTaxRate=Number(pconfigResult.configValue);
    }
    return tmpInvoiceTaxRate;
  }
  //获取配置的信息
  async getConfigValue(configName){
    var configValue=0;
    var pconfig=await this.cacheManager["PConfigCache"].cachePConfig();
    var pconfigResult= pconfig.find(item => {
        return item.configType === configName;
    });
    if(pconfigResult!=null && pconfigResult.configValue!=null && pconfigResult.configValue!=""){
      configValue=Number(pconfigResult.configValue);
    }
    return configValue;
  }
  //获取配置的推荐人分润比例
  async getReferrerProfitRatio(){
    var tmpInvoiceTaxRate=10;
    var pconfig=await this.cacheManager["PConfigCache"].cachePConfig();
    var pconfigResult= pconfig.find(item => {
        return item.configType === "referrerProfitRatio";
    });
    if(pconfigResult!=null && pconfigResult.configValue!=null && pconfigResult.configValue!=""){
      tmpInvoiceTaxRate=Number(pconfigResult.configValue);
    }
    return tmpInvoiceTaxRate;
  }
  //商机分配渠道配置，格式：wssyh5,yzc等
  async getBussinessAllotChannelConfig(){
    var bussinessAllotChannel="wssyh5";
    var pconfig=await this.cacheManager["PConfigCache"].cachePConfig();
    var pconfigResult= pconfig.find(item => {
        return item.configType === "bussinessAllotChannelConfig";
    });
    if(pconfigResult!=null && pconfigResult.configValue!=null && pconfigResult.configValue!=""){
      bussinessAllotChannel=pconfigResult.configValue;
    }
    return bussinessAllotChannel;
  }
}
module.exports=PConfigService;
