﻿var url = require("url");
var system = require("../../base/system");
var metaCtl=system.getObject("web.common.metaCtl");
var userCtl=system.getObject("web.auth.userCtl");
module.exports = function (app) {
	app.get("/auth",async function(req,res){
		var code=req.query.code;
		var srcKey=req.query.srcKey;
		var companyKey=req.query.companyKey;
		if(!code){
			return res.redirect("/");
		}else{
			await userCtl.authByCode(req);
			if(!companyKey){
				res.redirect("/admin?appKey="+srcKey);
			}else{
				res.redirect("/admin?appKey="+srcKey+"&companyKey="+companyKey);
			}
		
		}
	});
	app.all("/web/*", function (req, res, next) {
		if (req.url.indexOf("register") > 0 ||
			 req.url.indexOf("findAllApps") > 0 ||
			 req.url.indexOf("checkLogin") > 0 ||
			req.url.indexOf("login") > 0 ||
			req.url.indexOf("getApiDoc") > 0 ||
			req.url.indexOf("metaCtl") > 0 ||
			req.url.indexOf("fetchVcode") > 0 ||
			req.url.indexOf("checkSameName") > 0 ||
			req.url.indexOf("goLoginForApp") > 0 ||
			req.url.indexOf("getOssConfig") > 0) {
			return next();
		}
		if (!req.session.user) {
			var x = {
				status: -99,
				msg: "no login"
			};
			res.end(JSON.stringify(x));
		} else {
			//console.log(req.headers);
			next();
		}
	});
	app.get("/",async function(req,res){
		console.log(req.hostname);
		var appinfo=await metaCtl.getAppInfo(req);
		res.render("index",appinfo);
	});
	app.get("/admin",async function(req,res){
		var appinfo=await metaCtl.getAppInfo(req);
		res.render("admin",appinfo);
	});
	app.get('/web/:gname/:qname/:method', function (req, res) {
		req.codepath = req.headers["codepath"];
		var classPath = req.params["qname"];
        var methodName = req.params["method"];
        var gname=req.params["gname"];
        classPath=gname+"."+classPath;
		var params = [];
        params.push(methodName);
		params.push(req.body);
        params.push(req.query);
        params.push(req);
		var p = null;
		var invokeObj = system.getObject("web." + classPath);
		if (invokeObj["doexec"]) {
			p = invokeObj["doexec"].apply(invokeObj, params);
		}
		p.then(r => {
			res.end(JSON.stringify(r));
		});
	});
	app.post('/web/:gname/:qname/:method', function (req, res) {
		req.codepath = req.headers["codepath"];
		var classPath = req.params["qname"];
        var methodName = req.params["method"];
        var gname=req.params["gname"];
        var params = [];
        classPath=gname+"."+classPath;
		var tClientIp = system.get_client_ip(req);
		req.body.clientIp = tClientIp;
		req.body.agent= req.headers["user-agent"];
		req.body.classname=classPath;
		params.push(methodName);
		params.push(req.body);
        params.push(req.query);
        params.push(req);
		var p = null;
		var invokeObj = system.getObject("web." + classPath);
		if (invokeObj["doexec"]) {
			p = invokeObj["doexec"].apply(invokeObj, params);
		}
		p.then(r => {
			res.end(JSON.stringify(r));
		});
	});
};
