var path = require('path');
var ENVINPUT = {
  DB_HOST: process.env.DB_HOST,
  DB_PORT: process.env.DB_PORT,
  DB_USER: process.env.DB_USER,
  DB_PWD: process.env.DB_PWD,
  REDIS_HOST: process.env.REDIS_HOST,
  REDIS_PORT: process.env.REDIS_PORT,
  REDIS_PWD: process.env.REDIS_PWD,
  DB_NAME: process.env.CENTER_TMTRANSACTION_DB_NAME,
  REDIS_DB: process.env.CENTER_TMTRANSACTION_REDIS_DB,
  APP_ENV: process.env.APP_ENV ? process.env.APP_ENV : "dev"
};
var settings = {
  env: ENVINPUT.APP_ENV,
  usertimeout: 3600,//单位秒
  basepath: path.normalize(path.join(__dirname, '../..')),
  port: process.env.NODE_PORT || 4006,
  opLogUrl: function () {
    if (this.env == "dev" || this.env == "test") {
      return "http://er.es.gongsibao.com:7200/center-tm-transaction_log/_doc?pretty";
    } else {
      return "http://er.es.gongsibao.com:7200/center-tm-transaction_log/_doc?pretty";
    }
  },
  opPushUrl: function () {
    if (this.env == "dev" || this.env == "test") {
      return "http://192.168.210.205:4018/api/queueAction/producer/springBoard";
    } else {
      return "http://sytxpublic-msgq-service/api/queueAction/producer/springBoard";
    }
  },
  deliveryUrl: function () {
    if (this.env == "dev" || this.env == "test") {
      return "http://tx.g.com:8000";
    } else {
      return "http://tx.brg.tencentyun.com";
    }
  },
  checkIcNameUrl: function () {
    if (this.env == "dev" || this.env == "test") {
      return "http://127.0.0.1:35502//IcName/CheckName";
    } else {
      return "http://ic-name-service//IcName/CheckName";
    }
  },
  redis: function () {
    if (this.env == "dev" || this.env == "test") {
      var localsettings = require("./localsettings");
      return localsettings.redis;
    } else {
      return {
        host: ENVINPUT.REDIS_HOST,
        port: ENVINPUT.REDIS_PORT,
        password: ENVINPUT.REDIS_PWD,
        db: ENVINPUT.REDIS_DB || 7,
      };
    }
  },
  database: function () {
    if (this.env == "dev" || this.env == "test") {
      var localsettings = require("./localsettings");
      return localsettings.database;
    } else {
      return {
        dbname: ENVINPUT.DB_NAME ||"center-tmtransaction",
        user: ENVINPUT.DB_USER,
        password: ENVINPUT.DB_PWD,
        config: {
          host: ENVINPUT.DB_HOST,
          port: ENVINPUT.DB_PORT,
          dialect: 'mysql',
          pool: {
            max: 5,
            min: 0,
            acquire: 90000000,
            idle: 1000000
          },
          timezone: '+08:00',
          debug: false,
          dialectOptions: {
            requestTimeout: 999999,
            // instanceName:'DEV'
          }  //设置MSSQL超时时间
        },
      };
    }
  }
};
module.exports = settings;
